/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.io;

import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.io.AbstractRecordGroup;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.io.FileFormat;
import com.powsybl.psse.model.io.RecordGroupIO;
import com.powsybl.psse.model.io.RecordGroupIdentification;
import com.powsybl.psse.model.io.Util;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordGroupIOLegacyText<T>
implements RecordGroupIO<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RecordGroupIOLegacyText.class);
    protected final AbstractRecordGroup<T> recordGroup;
    private boolean qRecordFound;

    protected RecordGroupIOLegacyText(AbstractRecordGroup<T> recordGroup) {
        Objects.requireNonNull(recordGroup);
        this.recordGroup = recordGroup;
    }

    protected boolean isQRecordFound() {
        return this.qRecordFound;
    }

    @Override
    public List<T> read(BufferedReader reader, Context context) throws IOException {
        List<String> records = this.readRecords(reader);
        return this.recordGroup.readFromStrings(records, context);
    }

    @Override
    public void write(List<T> psseObjects, Context context, OutputStream outputStream) {
        String[] headers = context.getFieldNames(this.recordGroup.identification);
        String[] actualQuotedFields = Util.retainAll(this.recordGroup.quotedFields(), headers);
        this.writeBegin(outputStream);
        this.write(psseObjects, headers, actualQuotedFields, context, outputStream);
        this.writeEnd(outputStream);
    }

    @Override
    public T readHead(BufferedReader reader, Context context) throws IOException {
        throw new PsseException("Generic record group can not be read as head record");
    }

    @Override
    public void writeHead(T psseObject, Context context, OutputStream outputStream) {
        throw new PsseException("Generic record group can not be written as head record");
    }

    protected void write(List<T> objects, String[] headers, String[] quotedFields, Context context, OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        CsvWriterSettings settings = this.recordGroup.settingsForCsvWriter(headers, quotedFields, context);
        CsvWriter writer = new CsvWriter((Writer)outputStreamWriter, settings);
        writer.processRecords(objects);
        writer.flush();
    }

    public static void skip(RecordGroupIdentification recordGroup, BufferedReader reader) throws IOException {
        String line;
        LOG.debug("read and ignore record group {}", (Object)recordGroup);
        int number = -1;
        do {
            if ((line = reader.readLine()) == null) continue;
            try (Scanner scanner = new Scanner(line);){
                if (!scanner.hasNextInt()) continue;
                number = scanner.nextInt();
            }
        } while (line != null && number != 0);
    }

    public static void writeEmpty(RecordGroupIdentification recordGroup, OutputStream outputStream) {
        RecordGroupIOLegacyText.write(", ", outputStream);
        RecordGroupIOLegacyText.writeBegin(recordGroup.getLegacyTextName(), outputStream);
        RecordGroupIOLegacyText.writeEnd(recordGroup.getLegacyTextName(), outputStream);
    }

    protected void writeBegin(OutputStream outputStream) {
        RecordGroupIOLegacyText.write(", ", outputStream);
        RecordGroupIOLegacyText.writeBegin(this.recordGroup.getIdentification().getLegacyTextName(), outputStream);
    }

    protected void writeEnd(OutputStream outputStream) {
        RecordGroupIOLegacyText.writeEnd(this.recordGroup.getIdentification().getLegacyTextName(), outputStream);
    }

    public static void writeBegin(String legacyTextName, OutputStream outputStream) {
        RecordGroupIOLegacyText.write(String.format("BEGIN %s DATA%n", legacyTextName), outputStream);
    }

    public static void writeEnd(String legacyTextName, OutputStream outputStream) {
        RecordGroupIOLegacyText.write(String.format("0 / END OF %s DATA", legacyTextName), outputStream);
    }

    public static void writeQ(OutputStream outputStream) {
        RecordGroupIOLegacyText.write(String.format("%nQ%n", new Object[0]), outputStream);
    }

    public static void write(List<String> ss, OutputStream outputStream) {
        ss.forEach(s -> RecordGroupIOLegacyText.write(String.format("%s%n", s), outputStream));
    }

    public static void write(String s, OutputStream outputStream) {
        try {
            outputStream.write(s.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected List<String> readRecords(BufferedReader reader) throws IOException {
        ArrayList<String> records = new ArrayList<String>();
        if (!this.isQRecordFound()) {
            String line = RecordGroupIOLegacyText.readRecordLine(reader);
            while (!this.endOfBlock(line)) {
                records.add(line);
                line = RecordGroupIOLegacyText.readRecordLine(reader);
            }
        }
        return records;
    }

    protected boolean endOfBlock(String line) {
        if (line.trim().equals("Q")) {
            this.qRecordFound = true;
            return true;
        }
        return line.trim().equals("0");
    }

    protected static String readRecordLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            throw new PsseException("PSSE. Unexpected end of file");
        }
        StringBuilder newLine = new StringBuilder();
        Matcher m = FileFormat.LEGACY_TEXT_QUOTED_OR_WHITESPACE.matcher(RecordGroupIOLegacyText.removeComment(line));
        while (m.find()) {
            if (m.group().indexOf(FileFormat.LEGACY_TEXT.getQuote()) >= 0) {
                m.appendReplacement(newLine, RecordGroupIOLegacyText.replaceSpecialCharacters(m.group()));
                continue;
            }
            m.appendReplacement(newLine, " ");
        }
        m.appendTail(newLine);
        return newLine.toString().trim();
    }

    private static String removeComment(String line) {
        return line.replaceAll("('[^']*')|(^/[^/]*)|(/[^/]*)", "$1$2");
    }

    private static String replaceSpecialCharacters(String line) {
        return line.replace("\\", "\\\\").replace("$", "\\$");
    }
}

