/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.pf.io;

import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.io.RecordGroupIOLegacyText;
import com.powsybl.psse.model.pf.PsseCaseIdentification;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.io.AreaInterchangeData;
import com.powsybl.psse.model.pf.io.BusData;
import com.powsybl.psse.model.pf.io.CaseIdentificationData;
import com.powsybl.psse.model.pf.io.FactsDeviceData;
import com.powsybl.psse.model.pf.io.FixedBusShuntData;
import com.powsybl.psse.model.pf.io.GeneratorData;
import com.powsybl.psse.model.pf.io.GneDeviceData;
import com.powsybl.psse.model.pf.io.InductionMachineData;
import com.powsybl.psse.model.pf.io.InterareaTransferData;
import com.powsybl.psse.model.pf.io.LoadData;
import com.powsybl.psse.model.pf.io.MultiSectionLineGroupingData;
import com.powsybl.psse.model.pf.io.MultiTerminalDcTransmissionLineData;
import com.powsybl.psse.model.pf.io.NonTransformerBranchData;
import com.powsybl.psse.model.pf.io.OwnerData;
import com.powsybl.psse.model.pf.io.PowerFlowRawDataAllVersions;
import com.powsybl.psse.model.pf.io.PowerFlowRecordGroup;
import com.powsybl.psse.model.pf.io.SwitchedShuntData;
import com.powsybl.psse.model.pf.io.TransformerData;
import com.powsybl.psse.model.pf.io.TransformerImpedanceCorrectionTablesData;
import com.powsybl.psse.model.pf.io.TwoTerminalDcTransmissionLineData;
import com.powsybl.psse.model.pf.io.VoltageSourceConverterDcTransmissionLineData;
import com.powsybl.psse.model.pf.io.ZoneData;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class PowerFlowRawData35
extends PowerFlowRawDataAllVersions {
    @Override
    public PssePowerFlowModel read(ReadOnlyDataSource dataSource, String ext, Context context) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(dataSource.newInputStream(null, ext), StandardCharsets.UTF_8));){
            PsseCaseIdentification caseIdentification = (PsseCaseIdentification)new CaseIdentificationData().readHead(reader, context);
            caseIdentification.validate();
            PssePowerFlowModel model = new PssePowerFlowModel(caseIdentification);
            RecordGroupIOLegacyText.skip(PowerFlowRecordGroup.SYSTEM_WIDE, reader);
            model.addBuses(new BusData().read(reader, context));
            model.addLoads(new LoadData().read(reader, context));
            model.addFixedShunts(new FixedBusShuntData().read(reader, context));
            model.addGenerators(new GeneratorData().read(reader, context));
            model.addNonTransformerBranches(new NonTransformerBranchData().read(reader, context));
            RecordGroupIOLegacyText.skip(PowerFlowRecordGroup.SYSTEM_SWITCHING_DEVICE, reader);
            model.addTransformers(new TransformerData().read(reader, context));
            model.addAreas(new AreaInterchangeData().read(reader, context));
            model.addTwoTerminalDcTransmissionLines(new TwoTerminalDcTransmissionLineData().read(reader, context));
            model.addVoltageSourceConverterDcTransmissionLines(new VoltageSourceConverterDcTransmissionLineData().read(reader, context));
            model.addTransformerImpedanceCorrections(new TransformerImpedanceCorrectionTablesData().read(reader, context));
            model.addMultiTerminalDcTransmissionLines(new MultiTerminalDcTransmissionLineData().read(reader, context));
            model.addLineGrouping(new MultiSectionLineGroupingData().read(reader, context));
            model.addZones(new ZoneData().read(reader, context));
            model.addInterareaTransfer(new InterareaTransferData().read(reader, context));
            model.addOwners(new OwnerData().read(reader, context));
            model.addFacts(new FactsDeviceData().read(reader, context));
            model.addSwitchedShunts(new SwitchedShuntData().read(reader, context));
            model.addGneDevice(new GneDeviceData().read(reader, context));
            model.addInductionMachines(new InductionMachineData().read(reader, context));
            RecordGroupIOLegacyText.skip(PowerFlowRecordGroup.SUBSTATION, reader);
            PssePowerFlowModel pssePowerFlowModel = model;
            return pssePowerFlowModel;
        }
    }

    @Override
    public void write(PssePowerFlowModel model, Context context, DataSource dataSource) throws IOException {
        Objects.requireNonNull(model);
        Objects.requireNonNull(context);
        Objects.requireNonNull(dataSource);
        if (context.getVersion().major() != PsseVersion.Major.V35) {
            throw new PsseException("Unexpected version " + context.getVersion().getMajorNumber());
        }
        try (BufferedOutputStream outputStream = new BufferedOutputStream(dataSource.newOutputStream(null, "raw", false));){
            this.write(model, context, outputStream);
        }
    }

    private void write(PssePowerFlowModel model, Context context, BufferedOutputStream outputStream) {
        new CaseIdentificationData().writeHead(model.getCaseIdentification(), context, outputStream);
        RecordGroupIOLegacyText.writeEnd("SYSTEM-WIDE", outputStream);
        RecordGroupIOLegacyText.write(", ", (OutputStream)outputStream);
        RecordGroupIOLegacyText.writeBegin(PowerFlowRecordGroup.BUS.getLegacyTextName(), outputStream);
        new BusData().write(model.getBuses(), context, outputStream);
        new LoadData().write(model.getLoads(), context, outputStream);
        new FixedBusShuntData().write(model.getFixedShunts(), context, outputStream);
        new GeneratorData().write(model.getGenerators(), context, outputStream);
        new NonTransformerBranchData().write(model.getNonTransformerBranches(), context, outputStream);
        RecordGroupIOLegacyText.writeEmpty(PowerFlowRecordGroup.SYSTEM_SWITCHING_DEVICE, outputStream);
        new TransformerData().write(model.getTransformers(), context, outputStream);
        new AreaInterchangeData().write(model.getAreas(), context, outputStream);
        new TwoTerminalDcTransmissionLineData().write(model.getTwoTerminalDcTransmissionLines(), context, outputStream);
        new VoltageSourceConverterDcTransmissionLineData().write(model.getVoltageSourceConverterDcTransmissionLines(), context, outputStream);
        new TransformerImpedanceCorrectionTablesData().write(model.getTransformerImpedanceCorrections(), context, outputStream);
        new MultiTerminalDcTransmissionLineData().write(model.getMultiTerminalDcTransmissionLines(), context, outputStream);
        new MultiSectionLineGroupingData().write(model.getLineGrouping(), context, outputStream);
        new ZoneData().write(model.getZones(), context, outputStream);
        new InterareaTransferData().write(model.getInterareaTransfer(), context, outputStream);
        new OwnerData().write(model.getOwners(), context, outputStream);
        new FactsDeviceData().write(model.getFacts(), context, outputStream);
        new SwitchedShuntData().write(model.getSwitchedShunts(), context, outputStream);
        new GneDeviceData().write(model.getGneDevice(), context, outputStream);
        new InductionMachineData().write(model.getInductionMachines(), context, outputStream);
        RecordGroupIOLegacyText.writeEmpty(PowerFlowRecordGroup.SUBSTATION, outputStream);
        RecordGroupIOLegacyText.writeQ(outputStream);
    }
}

