/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.pf.io;

import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.io.AbstractRecordGroup;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.io.FileFormat;
import com.powsybl.psse.model.io.RecordGroupIOJson;
import com.powsybl.psse.model.io.RecordGroupIOLegacyText;
import com.powsybl.psse.model.pf.PsseTransformerImpedanceCorrection;
import com.powsybl.psse.model.pf.PsseTransformerImpedanceCorrectionPoint;
import com.powsybl.psse.model.pf.io.PowerFlowRecordGroup;
import com.univocity.parsers.annotations.Nested;
import com.univocity.parsers.annotations.Parsed;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;

class TransformerImpedanceCorrectionTablesData
extends AbstractRecordGroup<PsseTransformerImpedanceCorrection> {
    TransformerImpedanceCorrectionTablesData() {
        super(PowerFlowRecordGroup.TRANSFORMER_IMPEDANCE_CORRECTION_TABLES, new String[0]);
        this.withIO(FileFormat.LEGACY_TEXT, PsseVersion.Major.V32, new IOLegacyText33(this));
        this.withIO(FileFormat.LEGACY_TEXT, PsseVersion.Major.V33, new IOLegacyText33(this));
        this.withIO(FileFormat.LEGACY_TEXT, PsseVersion.Major.V35, new IOLegacyText35(this));
        this.withIO(FileFormat.JSON, new IOJson(this));
    }

    @Override
    protected Class<PsseTransformerImpedanceCorrection> psseTypeClass() {
        return PsseTransformerImpedanceCorrection.class;
    }

    private static class IOLegacyText33
    extends RecordGroupIOLegacyText<PsseTransformerImpedanceCorrection> {
        IOLegacyText33(AbstractRecordGroup<PsseTransformerImpedanceCorrection> recordGroup) {
            super(recordGroup);
        }

        @Override
        public List<PsseTransformerImpedanceCorrection> read(BufferedReader reader, Context context) throws IOException {
            List<ZCorr33> list33 = new ZCorr33Data().read(reader, context);
            return IOLegacyText33.convertToImpedanceCorrectionList(list33);
        }

        @Override
        public void write(List<PsseTransformerImpedanceCorrection> impedanceCorrectionList, Context context, OutputStream outputStream) {
            this.writeBegin(outputStream);
            ZCorr33Data recordData = new ZCorr33Data();
            String[] headers = recordData.fieldNames(context.getVersion());
            String[] quotedFields = recordData.quotedFields();
            impedanceCorrectionList.forEach(impedanceCorrection -> {
                ZCorr33 parser33 = IOLegacyText33.convertToTable(impedanceCorrection);
                String[] writeHeaders = (String[])ArrayUtils.subarray((Object[])headers, (int)0, (int)(1 + 2 * impedanceCorrection.getPoints().size()));
                String record = recordData.buildRecord(parser33, writeHeaders, quotedFields, context);
                IOLegacyText33.write(String.format("%s%n", record), outputStream);
            });
            this.writeEnd(outputStream);
        }

        private static List<PsseTransformerImpedanceCorrection> convertToImpedanceCorrectionList(List<ZCorr33> recordList) {
            ArrayList<PsseTransformerImpedanceCorrection> impedanceCorrectionList = new ArrayList<PsseTransformerImpedanceCorrection>();
            recordList.forEach(record -> impedanceCorrectionList.add(IOLegacyText33.convertToList(record)));
            return impedanceCorrectionList;
        }

        private static PsseTransformerImpedanceCorrection convertToList(ZCorr33 record) {
            PsseTransformerImpedanceCorrection impedanceCorrection = new PsseTransformerImpedanceCorrection(record.getI());
            List<Double> list = Arrays.asList(record.getT1(), record.getF1(), record.getT2(), record.getF2(), record.getT3(), record.getF3(), record.getT4(), record.getF4(), record.getT5(), record.getF5(), record.getT6(), record.getF6(), record.getT7(), record.getF7(), record.getT8(), record.getF8(), record.getT9(), record.getF9(), record.getT10(), record.getF10(), record.getT11(), record.getF11());
            for (int i = 0; i < list.size(); i += 2) {
                if (!IOLegacyText33.validPoint(list.get(i), list.get(i + 1))) continue;
                impedanceCorrection.getPoints().add(new PsseTransformerImpedanceCorrectionPoint(list.get(i), list.get(i + 1)));
            }
            return impedanceCorrection;
        }

        private static boolean validPoint(double t, double f) {
            return t != 0.0 && f != 0.0;
        }

        private static ZCorr33 convertToTable(PsseTransformerImpedanceCorrection impedanceCorrectionTable) {
            ZCorr33 record = new ZCorr33();
            record.setI(impedanceCorrectionTable.getI());
            for (int i = 0; i < impedanceCorrectionTable.getPoints().size(); ++i) {
                record.setTF(i + 1, impedanceCorrectionTable.getPoints().get(i).getT(), impedanceCorrectionTable.getPoints().get(i).getF());
            }
            return record;
        }

        private static class ZCorr33Data
        extends AbstractRecordGroup<ZCorr33> {
            ZCorr33Data() {
                super(PowerFlowRecordGroup.TRANSFORMER_IMPEDANCE_CORRECTION_TABLES, "i", "t1", "f1", "t2", "f2", "t3", "f3", "t4", "f4", "t5", "f5", "t6", "f6", "t7", "f7", "t8", "f8", "t9", "f9", "t10", "f10", "t11", "f11");
                this.withQuotedFields(new String[0]);
            }

            @Override
            protected Class<ZCorr33> psseTypeClass() {
                return ZCorr33.class;
            }
        }

        public static class ZCorr33 {
            @Parsed
            private int i;
            @Parsed
            private double t1 = 0.0;
            @Parsed
            private double f1 = 0.0;
            @Parsed
            private double t2 = 0.0;
            @Parsed
            private double f2 = 0.0;
            @Parsed
            private double t3 = 0.0;
            @Parsed
            private double f3 = 0.0;
            @Parsed
            private double t4 = 0.0;
            @Parsed
            private double f4 = 0.0;
            @Parsed
            private double t5 = 0.0;
            @Parsed
            private double f5 = 0.0;
            @Parsed
            private double t6 = 0.0;
            @Parsed
            private double f6 = 0.0;
            @Parsed
            private double t7 = 0.0;
            @Parsed
            private double f7 = 0.0;
            @Parsed
            private double t8 = 0.0;
            @Parsed
            private double f8 = 0.0;
            @Parsed
            private double t9 = 0.0;
            @Parsed
            private double f9 = 0.0;
            @Parsed
            private double t10 = 0.0;
            @Parsed
            private double f10 = 0.0;
            @Parsed
            private double t11 = 0.0;
            @Parsed
            private double f11 = 0.0;

            public int getI() {
                return this.i;
            }

            public void setI(int i) {
                this.i = i;
            }

            public double getT1() {
                return this.t1;
            }

            public double getF1() {
                return this.f1;
            }

            public double getT2() {
                return this.t2;
            }

            public double getF2() {
                return this.f2;
            }

            public double getT3() {
                return this.t3;
            }

            public double getF3() {
                return this.f3;
            }

            public double getT4() {
                return this.t4;
            }

            public double getF4() {
                return this.f4;
            }

            public double getT5() {
                return this.t5;
            }

            public double getF5() {
                return this.f5;
            }

            public double getT6() {
                return this.t6;
            }

            public double getF6() {
                return this.f6;
            }

            public double getT7() {
                return this.t7;
            }

            public double getF7() {
                return this.f7;
            }

            public double getT8() {
                return this.t8;
            }

            public double getF8() {
                return this.f8;
            }

            public double getT9() {
                return this.t9;
            }

            public double getF9() {
                return this.f9;
            }

            public double getT10() {
                return this.t10;
            }

            public double getF10() {
                return this.f10;
            }

            public double getT11() {
                return this.t11;
            }

            public double getF11() {
                return this.f11;
            }

            public void setTF(int point, double t, double f) {
                switch (point) {
                    case 1: {
                        this.t1 = t;
                        this.f1 = f;
                        break;
                    }
                    case 2: {
                        this.t2 = t;
                        this.f2 = f;
                        break;
                    }
                    case 3: {
                        this.t3 = t;
                        this.f3 = f;
                        break;
                    }
                    case 4: {
                        this.t4 = t;
                        this.f4 = f;
                        break;
                    }
                    case 5: {
                        this.t5 = t;
                        this.f5 = f;
                        break;
                    }
                    case 6: {
                        this.t6 = t;
                        this.f6 = f;
                        break;
                    }
                    case 7: {
                        this.t7 = t;
                        this.f7 = f;
                        break;
                    }
                    case 8: {
                        this.t8 = t;
                        this.f8 = f;
                        break;
                    }
                    case 9: {
                        this.t9 = t;
                        this.f9 = f;
                        break;
                    }
                    case 10: {
                        this.t10 = t;
                        this.f10 = f;
                        break;
                    }
                    case 11: {
                        this.t11 = t;
                        this.f11 = f;
                        break;
                    }
                    default: {
                        throw new PsseException("Unexpected point " + point);
                    }
                }
            }
        }
    }

    private static class IOLegacyText35
    extends RecordGroupIOLegacyText<PsseTransformerImpedanceCorrection> {
        private static final String[][] FIELD_NAMES = new String[][]{{"i", "t1", "ref1", "imf1", "t2", "ref2", "imf2", "t3", "ref3", "imf3", "t4", "ref4", "imf4", "t5", "ref5", "imf5", "t6", "ref6", "imf6"}, {"t1", "ref1", "imf1", "t2", "ref2", "imf2", "t3", "ref3", "imf3", "t4", "ref4", "imf4", "t5", "ref5", "imf5", "t6", "ref6", "imf6"}};
        private static final String[] QUOTED_FIELDS = new String[0];

        IOLegacyText35(AbstractRecordGroup<PsseTransformerImpedanceCorrection> recordGroup) {
            super(recordGroup);
        }

        @Override
        public List<PsseTransformerImpedanceCorrection> read(BufferedReader reader, Context context) throws IOException {
            List<String> records = this.readRecords(reader);
            ZCorr35FirstData record1Data = new ZCorr35FirstData();
            ZCorr35PointsData record2Data = new ZCorr35PointsData();
            ArrayList<PsseTransformerImpedanceCorrection> impedanceCorrectionList = new ArrayList<PsseTransformerImpedanceCorrection>();
            int i = 0;
            while (i < records.size()) {
                ZCorr35First r1 = (ZCorr35First)record1Data.parseSingleRecord(records.get(i++), FIELD_NAMES[0], context);
                PsseTransformerImpedanceCorrection impedanceCorrection = new PsseTransformerImpedanceCorrection(r1.getI());
                boolean endPoints = IOLegacyText35.addImpedanceCorrectionPoints(impedanceCorrection, r1.getPoints());
                while (i < records.size() && !endPoints) {
                    ZCorr35Points r2 = (ZCorr35Points)record2Data.parseSingleRecord(records.get(i++), FIELD_NAMES[1], context);
                    endPoints = IOLegacyText35.addImpedanceCorrectionPoints(impedanceCorrection, r2);
                }
                if (impedanceCorrection.getPoints().isEmpty()) continue;
                impedanceCorrectionList.add(impedanceCorrection);
            }
            return impedanceCorrectionList;
        }

        private static boolean addImpedanceCorrectionPoints(PsseTransformerImpedanceCorrection impedanceCorrection, ZCorr35Points record2) {
            Objects.requireNonNull(record2);
            List<Double> list = Arrays.asList(record2.getT1(), record2.getRef1(), record2.getImf1(), record2.getT2(), record2.getRef2(), record2.getImf2(), record2.getT3(), record2.getRef3(), record2.getImf3(), record2.getT4(), record2.getRef4(), record2.getImf4(), record2.getT5(), record2.getRef5(), record2.getImf5(), record2.getT6(), record2.getRef6(), record2.getImf6());
            for (int i = 0; i < list.size(); i += 3) {
                if (IOLegacyText35.endPoint(list.get(i), list.get(i + 1), list.get(i + 2))) {
                    return true;
                }
                impedanceCorrection.getPoints().add(new PsseTransformerImpedanceCorrectionPoint(list.get(i), list.get(i + 1), list.get(i + 2)));
            }
            return false;
        }

        private static boolean endPoint(double t, double ref, double imf) {
            return t == 0.0 && ref == 0.0 && imf == 0.0;
        }

        @Override
        public void write(List<PsseTransformerImpedanceCorrection> impedanceCorrectionList, Context context, OutputStream outputStream) {
            ZCorr35FirstData record1Data = new ZCorr35FirstData();
            ZCorr35PointsData record2Data = new ZCorr35PointsData();
            this.writeBegin(outputStream);
            impedanceCorrectionList.forEach(impedanceCorrection -> {
                int indexPoints = 0;
                ZCorr35First r1 = IOLegacyText35.convertToRecord1(impedanceCorrection, indexPoints);
                String[] writeHeaders = (String[])ArrayUtils.subarray((Object[])FIELD_NAMES[0], (int)0, (int)(1 + 3 * IOLegacyText35.pointsInsideRecord(indexPoints, impedanceCorrection.getPoints().size())));
                String record = record1Data.buildRecord(r1, writeHeaders, QUOTED_FIELDS, context);
                IOLegacyText35.write(String.format("%s%n", record), outputStream);
                indexPoints += 6;
                while (indexPoints <= impedanceCorrection.getPoints().size()) {
                    ZCorr35Points r2 = IOLegacyText35.convertToRecord2(impedanceCorrection, indexPoints);
                    String[] writeHeadersPoints = (String[])ArrayUtils.subarray((Object[])FIELD_NAMES[1], (int)0, (int)(3 * IOLegacyText35.pointsInsideRecord(indexPoints, impedanceCorrection.getPoints().size())));
                    String recordPoints = record2Data.buildRecord(r2, writeHeadersPoints, QUOTED_FIELDS, context);
                    IOLegacyText35.write(String.format("%s%n", recordPoints), outputStream);
                    indexPoints += 6;
                }
            });
            this.writeEnd(outputStream);
        }

        private static int pointsInsideRecord(int indexPoints, int numPoints) {
            int pendingPoints = numPoints - indexPoints;
            if (pendingPoints >= 6) {
                return 6;
            }
            return pendingPoints + 1;
        }

        private static ZCorr35First convertToRecord1(PsseTransformerImpedanceCorrection impedanceCorrection, int indexPoints) {
            ZCorr35First record1 = new ZCorr35First();
            record1.setI(impedanceCorrection.getI());
            record1.setPoints(IOLegacyText35.convertToRecord2(impedanceCorrection, indexPoints));
            return record1;
        }

        private static ZCorr35Points convertToRecord2(PsseTransformerImpedanceCorrection impedanceCorrection, int indexPoints) {
            ZCorr35Points record2 = new ZCorr35Points();
            int pointNumber = 0;
            for (int index = indexPoints; index < impedanceCorrection.getPoints().size() && pointNumber < 6; ++index) {
                PsseTransformerImpedanceCorrectionPoint point = impedanceCorrection.getPoints().get(index);
                record2.setTF(++pointNumber, point.getT(), point.getRef(), point.getImf());
            }
            if (pointNumber < 6) {
                record2.setTF(++pointNumber, 0.0, 0.0, 0.0);
            }
            return record2;
        }

        private static class ZCorr35FirstData
        extends AbstractRecordGroup<ZCorr35First> {
            ZCorr35FirstData() {
                super(PowerFlowRecordGroup.TRANSFORMER_IMPEDANCE_CORRECTION_TABLES, new String[0]);
            }

            @Override
            protected Class<ZCorr35First> psseTypeClass() {
                return ZCorr35First.class;
            }
        }

        private static class ZCorr35PointsData
        extends AbstractRecordGroup<ZCorr35Points> {
            ZCorr35PointsData() {
                super(PowerFlowRecordGroup.TRANSFORMER_IMPEDANCE_CORRECTION_TABLES, new String[0]);
            }

            @Override
            protected Class<ZCorr35Points> psseTypeClass() {
                return ZCorr35Points.class;
            }
        }

        public static class ZCorr35First {
            @Parsed
            private int i;
            @Nested
            private ZCorr35Points points;

            public int getI() {
                return this.i;
            }

            public void setI(int i) {
                this.i = i;
            }

            public ZCorr35Points getPoints() {
                return this.points;
            }

            public void setPoints(ZCorr35Points points) {
                this.points = points;
            }
        }

        public static class ZCorr35Points {
            @Parsed
            private double t1 = 0.0;
            @Parsed
            private double ref1 = 0.0;
            @Parsed
            private double imf1 = 0.0;
            @Parsed
            private double t2 = 0.0;
            @Parsed
            private double ref2 = 0.0;
            @Parsed
            private double imf2 = 0.0;
            @Parsed
            private double t3 = 0.0;
            @Parsed
            private double ref3 = 0.0;
            @Parsed
            private double imf3 = 0.0;
            @Parsed
            private double t4 = 0.0;
            @Parsed
            private double ref4 = 0.0;
            @Parsed
            private double imf4 = 0.0;
            @Parsed
            private double t5 = 0.0;
            @Parsed
            private double ref5 = 0.0;
            @Parsed
            private double imf5 = 0.0;
            @Parsed
            private double t6 = 0.0;
            @Parsed
            private double ref6 = 0.0;
            @Parsed
            private double imf6 = 0.0;

            public double getT1() {
                return this.t1;
            }

            public double getRef1() {
                return this.ref1;
            }

            public double getImf1() {
                return this.imf1;
            }

            public double getT2() {
                return this.t2;
            }

            public double getRef2() {
                return this.ref2;
            }

            public double getImf2() {
                return this.imf2;
            }

            public double getT3() {
                return this.t3;
            }

            public double getRef3() {
                return this.ref3;
            }

            public double getImf3() {
                return this.imf3;
            }

            public double getT4() {
                return this.t4;
            }

            public double getRef4() {
                return this.ref4;
            }

            public double getImf4() {
                return this.imf4;
            }

            public double getT5() {
                return this.t5;
            }

            public double getRef5() {
                return this.ref5;
            }

            public double getImf5() {
                return this.imf5;
            }

            public double getT6() {
                return this.t6;
            }

            public double getRef6() {
                return this.ref6;
            }

            public double getImf6() {
                return this.imf6;
            }

            public void setTF(int point, double t, double ref, double imf) {
                switch (point) {
                    case 1: {
                        this.t1 = t;
                        this.ref1 = ref;
                        this.imf1 = imf;
                        break;
                    }
                    case 2: {
                        this.t2 = t;
                        this.ref2 = ref;
                        this.imf2 = imf;
                        break;
                    }
                    case 3: {
                        this.t3 = t;
                        this.ref3 = ref;
                        this.imf3 = imf;
                        break;
                    }
                    case 4: {
                        this.t4 = t;
                        this.ref4 = ref;
                        this.imf4 = imf;
                        break;
                    }
                    case 5: {
                        this.t5 = t;
                        this.ref5 = ref;
                        this.imf5 = imf;
                        break;
                    }
                    case 6: {
                        this.t6 = t;
                        this.ref6 = ref;
                        this.imf6 = imf;
                        break;
                    }
                    default: {
                        throw new PsseException("Unexpected point " + point);
                    }
                }
            }
        }

        public static class ZCorr35X {
            @Parsed
            private int itable;
            @Parsed
            private double tap;
            @Parsed
            private double refact;
            @Parsed
            private double imfact;

            public ZCorr35X() {
            }

            public ZCorr35X(int itable, double tap, double refact, double imfact) {
                this.itable = itable;
                this.tap = tap;
                this.refact = refact;
                this.imfact = imfact;
            }

            public int getItable() {
                return this.itable;
            }

            public double getTap() {
                return this.tap;
            }

            public double getRefact() {
                return this.refact;
            }

            public double getImfact() {
                return this.imfact;
            }
        }
    }

    private static class IOJson
    extends RecordGroupIOJson<PsseTransformerImpedanceCorrection> {
        IOJson(AbstractRecordGroup<PsseTransformerImpedanceCorrection> recordGroup) {
            super(recordGroup);
        }

        @Override
        public List<PsseTransformerImpedanceCorrection> read(BufferedReader reader, Context context) throws IOException {
            if (reader != null) {
                throw new PsseException("Unexpected reader. Should be null");
            }
            List<IOLegacyText35.ZCorr35X> parserRecords = new PsseTransformerImpedanceCorrection35xParserRecordData().read(null, context);
            ArrayList<PsseTransformerImpedanceCorrection> records = new ArrayList<PsseTransformerImpedanceCorrection>();
            parserRecords.forEach(parserRecord -> IOJson.convertToImpedanceCorrection(records, parserRecord));
            return records;
        }

        private static void convertToImpedanceCorrection(List<PsseTransformerImpedanceCorrection> impedanceCorrectionList, IOLegacyText35.ZCorr35X parserRecord) {
            if (impedanceCorrectionList.isEmpty()) {
                PsseTransformerImpedanceCorrection impedanceCorrection = new PsseTransformerImpedanceCorrection(parserRecord.getItable());
                impedanceCorrection.getPoints().add(new PsseTransformerImpedanceCorrectionPoint(parserRecord.getTap(), parserRecord.getRefact(), parserRecord.getImfact()));
                impedanceCorrectionList.add(impedanceCorrection);
            } else {
                PsseTransformerImpedanceCorrection lastImpedanceCorrection = impedanceCorrectionList.get(impedanceCorrectionList.size() - 1);
                if (lastImpedanceCorrection.getI() == parserRecord.getItable()) {
                    lastImpedanceCorrection.getPoints().add(new PsseTransformerImpedanceCorrectionPoint(parserRecord.getTap(), parserRecord.getRefact(), parserRecord.getImfact()));
                } else {
                    PsseTransformerImpedanceCorrection impedanceCorrection = new PsseTransformerImpedanceCorrection(parserRecord.getItable());
                    impedanceCorrection.getPoints().add(new PsseTransformerImpedanceCorrectionPoint(parserRecord.getTap(), parserRecord.getRefact(), parserRecord.getImfact()));
                    impedanceCorrectionList.add(impedanceCorrection);
                }
            }
        }

        @Override
        public void write(List<PsseTransformerImpedanceCorrection> impedanceCorrectionList, Context context, OutputStream outputStream) {
            if (outputStream != null) {
                throw new PsseException("Unexpected outputStream. Should be null");
            }
            List<IOLegacyText35.ZCorr35X> parserList = IOJson.convertToParserList(impedanceCorrectionList);
            new PsseTransformerImpedanceCorrection35xParserRecordData().write(parserList, context, null);
        }

        private static List<IOLegacyText35.ZCorr35X> convertToParserList(List<PsseTransformerImpedanceCorrection> impedanceCorrectionList) {
            ArrayList<IOLegacyText35.ZCorr35X> parserList = new ArrayList<IOLegacyText35.ZCorr35X>();
            impedanceCorrectionList.forEach(impedanceCorrection -> impedanceCorrection.getPoints().forEach(point -> {
                IOLegacyText35.ZCorr35X parserRecord = new IOLegacyText35.ZCorr35X(impedanceCorrection.getI(), point.getT(), point.getRef(), point.getImf());
                parserList.add(parserRecord);
            }));
            return parserList;
        }

        private static class PsseTransformerImpedanceCorrection35xParserRecordData
        extends AbstractRecordGroup<IOLegacyText35.ZCorr35X> {
            PsseTransformerImpedanceCorrection35xParserRecordData() {
                super(PowerFlowRecordGroup.TRANSFORMER_IMPEDANCE_CORRECTION_TABLES, new String[0]);
                this.withQuotedFields(new String[0]);
            }

            @Override
            protected Class<IOLegacyText35.ZCorr35X> psseTypeClass() {
                return IOLegacyText35.ZCorr35X.class;
            }
        }
    }
}

