/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.pf.io;

import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.io.AbstractRecordGroup;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.io.FileFormat;
import com.powsybl.psse.model.io.RecordGroupIOLegacyText;
import com.powsybl.psse.model.pf.PsseVoltageSourceConverter;
import com.powsybl.psse.model.pf.PsseVoltageSourceConverterDcTransmissionLine;
import com.powsybl.psse.model.pf.io.PowerFlowRecordGroup;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class VoltageSourceConverterDcTransmissionLineData
extends AbstractRecordGroup<PsseVoltageSourceConverterDcTransmissionLine> {
    private static final String[] FIELD_NAMES_CONVERTER_32_33 = new String[]{"ibus", "type", "mode", "dcset", "acset", "aloss", "bloss", "minloss", "smax", "imax", "pwf", "maxq", "minq", "remot", "rmpct"};

    VoltageSourceConverterDcTransmissionLineData() {
        super(PowerFlowRecordGroup.VOLTAGE_SOURCE_CONVERTER_DC_TRANSMISSION_LINE, "name", "mdc", "rdc", "o1", "f1", "o2", "f2", "o3", "f3", "o4", "f4");
        this.withIO(FileFormat.LEGACY_TEXT, new IOLegacyText(this));
        this.withQuotedFields("name");
    }

    @Override
    protected Class<PsseVoltageSourceConverterDcTransmissionLine> psseTypeClass() {
        return PsseVoltageSourceConverterDcTransmissionLine.class;
    }

    private static class IOLegacyText
    extends RecordGroupIOLegacyText<PsseVoltageSourceConverterDcTransmissionLine> {
        IOLegacyText(AbstractRecordGroup<PsseVoltageSourceConverterDcTransmissionLine> recordGroup) {
            super(recordGroup);
        }

        @Override
        public List<PsseVoltageSourceConverterDcTransmissionLine> read(BufferedReader reader, Context context) throws IOException {
            ArrayList<String> mainRecords = new ArrayList<String>();
            ArrayList<String> converterRecords = new ArrayList<String>();
            if (!this.isQRecordFound()) {
                String line = IOLegacyText.readRecordLine(reader);
                while (!this.endOfBlock(line)) {
                    mainRecords.add(line);
                    converterRecords.add(IOLegacyText.readRecordLine(reader));
                    converterRecords.add(IOLegacyText.readRecordLine(reader));
                    line = IOLegacyText.readRecordLine(reader);
                }
            }
            List<PsseVoltageSourceConverterDcTransmissionLine> voltageSourceConverterDcList = this.recordGroup.readFromStrings(mainRecords, context);
            List convertersList = new PsseVoltageSourceConverterRecordData().readFromStrings(converterRecords, context);
            int index = 0;
            for (PsseVoltageSourceConverterDcTransmissionLine voltageSourceConverterDc : voltageSourceConverterDcList) {
                voltageSourceConverterDc.setConverter1((PsseVoltageSourceConverter)convertersList.get(index));
                voltageSourceConverterDc.setConverter2((PsseVoltageSourceConverter)convertersList.get(++index));
                ++index;
            }
            return voltageSourceConverterDcList;
        }

        @Override
        public void write(List<PsseVoltageSourceConverterDcTransmissionLine> voltageSourceConverterDcList, Context context, OutputStream outputStream) {
            PsseVoltageSourceConverterRecordData converterRecordData = new PsseVoltageSourceConverterRecordData();
            String[] mainHeaders = context.getFieldNames(PowerFlowRecordGroup.VOLTAGE_SOURCE_CONVERTER_DC_TRANSMISSION_LINE);
            String[] quotedFields = this.recordGroup.quotedFields();
            String[] converterHeaders = context.getFieldNames(PowerFlowRecordGroup.INTERNAL_VOLTAGE_SOURCE_CONVERTER_DC_TRANSMISSION_LINE_CONVERTER);
            ArrayList mainList = new ArrayList();
            ArrayList converterList = new ArrayList();
            voltageSourceConverterDcList.forEach(voltageSourceConverterDc -> {
                mainList.add(voltageSourceConverterDc);
                converterList.add(voltageSourceConverterDc.getConverter1());
                converterList.add(voltageSourceConverterDc.getConverter2());
            });
            List<String> mainStringList = this.recordGroup.buildRecords(mainList, mainHeaders, quotedFields, context);
            List<String> converterStringList = converterRecordData.buildRecords(converterList, converterHeaders, quotedFields, context);
            this.writeBegin(outputStream);
            int index = 0;
            for (String main : mainStringList) {
                String converter1 = converterStringList.get(index);
                String converter2 = converterStringList.get(++index);
                ++index;
                IOLegacyText.write(Arrays.asList(main, converter1, converter2), outputStream);
            }
            this.writeEnd(outputStream);
        }

        private static class PsseVoltageSourceConverterRecordData
        extends AbstractRecordGroup<PsseVoltageSourceConverter> {
            PsseVoltageSourceConverterRecordData() {
                super(PowerFlowRecordGroup.INTERNAL_VOLTAGE_SOURCE_CONVERTER_DC_TRANSMISSION_LINE_CONVERTER, new String[0]);
                this.withFieldNames(PsseVersion.Major.V32, FIELD_NAMES_CONVERTER_32_33);
                this.withFieldNames(PsseVersion.Major.V33, FIELD_NAMES_CONVERTER_32_33);
                this.withFieldNames(PsseVersion.Major.V35, "ibus", "type", "mode", "dcset", "acset", "aloss", "bloss", "minloss", "smax", "imax", "pwf", "maxq", "minq", "vsreg", "nreg", "rmpct");
                this.withQuotedFields(new String[0]);
            }

            @Override
            protected Class<PsseVoltageSourceConverter> psseTypeClass() {
                return PsseVoltageSourceConverter.class;
            }
        }
    }
}

