/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.pf.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.io.FileFormat;
import com.powsybl.psse.model.io.LegacyTextReader;
import com.powsybl.psse.model.pf.PsseCaseIdentification;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.io.CaseIdentificationData;
import com.powsybl.psse.model.pf.io.PowerFlowData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class PowerFlowRawxDataAllVersions
implements PowerFlowData {
    @Override
    public boolean isValidFile(ReadOnlyDataSource dataSource, String ext) throws IOException {
        try (BufferedReader bReader = new BufferedReader(new InputStreamReader(dataSource.newInputStream(null, ext)));){
            Context context = new Context();
            context.setFileFormat(FileFormat.JSON);
            LegacyTextReader reader = new LegacyTextReader(bReader);
            PsseCaseIdentification caseIdentification = (PsseCaseIdentification)new CaseIdentificationData().readHead(reader, context);
            caseIdentification.validate();
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public PsseVersion readVersion(ReadOnlyDataSource dataSource, String ext) throws IOException {
        try (BufferedReader bReader = new BufferedReader(new InputStreamReader(dataSource.newInputStream(null, ext)));){
            Context context = new Context();
            context.setFileFormat(FileFormat.JSON);
            LegacyTextReader reader = new LegacyTextReader(bReader);
            PsseCaseIdentification caseIdentification = (PsseCaseIdentification)new CaseIdentificationData().readHead(reader, context);
            PsseVersion psseVersion = PsseVersion.fromRevision(caseIdentification.getRev());
            return psseVersion;
        }
    }

    @Override
    public PssePowerFlowModel read(ReadOnlyDataSource dataSource, String ext, Context context) throws IOException {
        throw new PsseException("RawXDataCommon does not know how to read complete data file. Specific version instance is required");
    }

    @Override
    public void write(PssePowerFlowModel model, Context context, DataSource dataSource) throws IOException {
        throw new PsseException("RawXDataCommon does not know how to write complete data file. Specific version instance is required");
    }

    protected JsonNode networkNode(InputStream stream) throws IOException {
        return new ObjectMapper().readTree(stream).get("network");
    }
}

