/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.powsybl.commons.PowsyblException;
import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.io.AbstractRecordGroup;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.io.LegacyTextReader;
import com.powsybl.psse.model.io.RecordGroupIO;
import com.powsybl.psse.model.io.RecordGroupIdentification;
import com.powsybl.psse.model.io.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RecordGroupIOJson<T>
implements RecordGroupIO<T> {
    private final AbstractRecordGroup<T> recordGroup;

    protected RecordGroupIOJson(AbstractRecordGroup<T> recordGroup) {
        Objects.requireNonNull(recordGroup);
        this.recordGroup = recordGroup;
    }

    @Override
    public List<T> read(LegacyTextReader reader, Context context) throws IOException {
        if (reader == null) {
            return this.readJson(context.getNetworkNode(), context);
        }
        JsonFactory jsonFactory = new JsonFactory();
        try (JsonParser parser = jsonFactory.createParser((Reader)reader.getBufferedReader());){
            JsonNode node = this.readJsonNode(parser);
            String[] actualFieldNames = RecordGroupIOJson.readFieldNames(node);
            List<String> records = this.readRecords(node);
            context.setFieldNames(this.recordGroup.identification, actualFieldNames);
            List<T> list = this.recordGroup.parseRecords(records, actualFieldNames, context);
            return list;
        }
    }

    @Override
    public void write(List<T> psseObjects, Context context, OutputStream outputStream) {
        if (outputStream != null) {
            throw new PsseException("Should write to Json generator instead of outputStream");
        }
        String[] headers = context.getFieldNames(this.recordGroup.identification);
        String[] actualQuotedFields = Util.retainAll(this.recordGroup.quotedFields(), headers);
        List<String> records = this.recordGroup.buildRecords(psseObjects, headers, actualQuotedFields, context);
        this.write(headers, records, context.getJsonGenerator());
    }

    @Override
    public T readHead(LegacyTextReader reader, Context context) throws IOException {
        throw new PsseException("Generic record group can not be read as head record");
    }

    @Override
    public void writeHead(T psseObject, Context context, OutputStream outputStream) {
        throw new PsseException("Generic record group can not be written as head record");
    }

    private JsonNode readJsonNode(JsonParser parser) throws IOException {
        Objects.requireNonNull(parser);
        ObjectMapper mapper = new ObjectMapper();
        parser.setCodec((ObjectCodec)mapper);
        String nodeName = this.recordGroup.getIdentification().getJsonNodeName();
        while (!parser.isClosed()) {
            parser.nextToken();
            if (!nodeName.equals(parser.getCurrentName())) continue;
            return (JsonNode)mapper.convertValue((Object)parser.readValueAsTree().get("caseid"), JsonNode.class);
        }
        throw new PsseException("Json node not found: " + nodeName);
    }

    private List<T> readJson(JsonNode networkNode, Context context) {
        JsonNode jsonNode = networkNode.get(this.recordGroup.getIdentification().getJsonNodeName());
        if (jsonNode == null) {
            return new ArrayList();
        }
        String[] actualFieldNames = RecordGroupIOJson.readFieldNames(jsonNode);
        List<String> records = this.readRecords(jsonNode);
        context.setFieldNames(this.recordGroup.getIdentification(), actualFieldNames);
        return this.recordGroup.parseRecords(records, actualFieldNames, context);
    }

    private static String[] readFieldNames(JsonNode n) {
        JsonNode fieldsNode = n.get("fields");
        if (!fieldsNode.isArray()) {
            throw new PowsyblException("Expecting array reading fields");
        }
        ArrayList<String> fields = new ArrayList<String>();
        for (JsonNode f : fieldsNode) {
            fields.add(f.asText());
        }
        return fields.toArray(new String[0]);
    }

    private static String readArrayContent(JsonNode jrecord) {
        if (!jrecord.isArray()) {
            throw new PowsyblException("Expecting array reading data");
        }
        String srecord = jrecord.toString();
        return srecord.substring(1, srecord.length() - 1);
    }

    private List<String> readRecords(JsonNode n) {
        JsonNode dataNode = n.get("data");
        ArrayList<String> records = new ArrayList<String>();
        switch (this.recordGroup.getIdentification().getJsonObjectType()) {
            case PARAMETER_SET: {
                records.add(RecordGroupIOJson.readArrayContent(dataNode));
                break;
            }
            case DATA_TABLE: {
                for (JsonNode r : dataNode) {
                    records.add(RecordGroupIOJson.readArrayContent(r));
                }
                break;
            }
            default: {
                throw new PsseException("Unsupported Json object type " + this.recordGroup.getIdentification().getJsonObjectType());
            }
        }
        return records;
    }

    private void write(String[] fields, List<String> data, JsonGenerator g) {
        if (fields == null || data == null || fields.length == 0 || data.isEmpty()) {
            return;
        }
        String[] dpp = null;
        PrettyPrinter pp = g.getPrettyPrinter();
        if (pp instanceof DefaultPrettyPrinter) {
            String[] defaultPrettyPrinter = (String[])pp;
            dpp = defaultPrettyPrinter;
        }
        try {
            g.writeFieldName(this.recordGroup.identification.getJsonNodeName());
            g.writeStartObject();
            if (dpp != null) {
                dpp.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultPrettyPrinter.FixedSpaceIndenter.instance);
            }
            g.writeArrayFieldStart("fields");
            for (String field : fields) {
                g.writeString(field);
            }
            g.writeEndArray();
            if (dpp != null) {
                dpp.indentArraysWith((DefaultPrettyPrinter.Indenter)(this.recordGroup.identification.getJsonObjectType() == RecordGroupIdentification.JsonObjectType.PARAMETER_SET ? DefaultPrettyPrinter.FixedSpaceIndenter.instance : DefaultIndenter.SYSTEM_LINEFEED_INSTANCE));
            }
            g.writeArrayFieldStart("data");
            for (String s : data) {
                if (this.recordGroup.identification.getJsonObjectType() == RecordGroupIdentification.JsonObjectType.DATA_TABLE) {
                    g.writeStartArray();
                }
                g.writeRaw(" ");
                g.writeRaw(s);
                if (this.recordGroup.identification.getJsonObjectType() != RecordGroupIdentification.JsonObjectType.DATA_TABLE) continue;
                g.writeEndArray();
            }
            g.writeEndArray();
            g.writeEndObject();
            g.flush();
        }
        catch (IOException e) {
            throw new PsseException("Writing PSSE", e);
        }
    }
}

