/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.Revision;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import java.lang.reflect.Field;
import java.util.Objects;

@JsonFilter(value="PsseVersionFilter")
public class PsseVersioned {
    private PssePowerFlowModel model = null;

    public void setModel(PssePowerFlowModel model) {
        this.model = Objects.requireNonNull(model);
    }

    public void checkVersion(String fieldName) {
        if (this.model == null) {
            return;
        }
        Field field = null;
        try {
            field = this.getClass().getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new PsseException("Wrong field name " + fieldName, e);
        }
        this.checkVersionField(field, fieldName);
    }

    public static boolean isValidVersion(PsseVersion version, Revision revisionAnnotation) {
        PsseVersion since = PsseVersion.fromRevision(revisionAnnotation.since());
        PsseVersion until = PsseVersion.fromRevision(revisionAnnotation.until());
        return since.getNumber() <= version.getNumber() && version.getNumber() <= until.getNumber();
    }

    private void checkVersionField(Field field, String fieldName) {
        if (!field.isAnnotationPresent(Revision.class)) {
            throw new PsseException("Missing Revision annotation in field " + fieldName);
        }
        PsseVersion current = PsseVersion.fromRevision(this.model.getCaseIdentification().getRev());
        if (!PsseVersioned.isValidVersion(current, field.getAnnotation(Revision.class))) {
            PsseVersion since = PsseVersion.fromRevision(field.getAnnotation(Revision.class).since());
            PsseVersion until = PsseVersion.fromRevision(field.getAnnotation(Revision.class).until());
            String message = String.format("Wrong version of PSSE RAW model (%s). Field '%s' is valid since version %s%s", current, fieldName, since, until.getNumber() != PsseVersion.MAX_VERSION.getNumber() ? " until " + until : "");
            throw new PsseException(message);
        }
    }
}

