/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.pf;

import com.powsybl.psse.model.PsseVersioned;
import com.powsybl.psse.model.pf.PsseArea;
import com.powsybl.psse.model.pf.PsseBus;
import com.powsybl.psse.model.pf.PsseCaseIdentification;
import com.powsybl.psse.model.pf.PsseFacts;
import com.powsybl.psse.model.pf.PsseFixedShunt;
import com.powsybl.psse.model.pf.PsseGenerator;
import com.powsybl.psse.model.pf.PsseGneDevice;
import com.powsybl.psse.model.pf.PsseInductionMachine;
import com.powsybl.psse.model.pf.PsseInterareaTransfer;
import com.powsybl.psse.model.pf.PsseLineGrouping;
import com.powsybl.psse.model.pf.PsseLoad;
import com.powsybl.psse.model.pf.PsseMultiTerminalDcTransmissionLine;
import com.powsybl.psse.model.pf.PsseNonTransformerBranch;
import com.powsybl.psse.model.pf.PsseOwner;
import com.powsybl.psse.model.pf.PsseSwitchedShunt;
import com.powsybl.psse.model.pf.PsseTransformer;
import com.powsybl.psse.model.pf.PsseTransformerImpedanceCorrection;
import com.powsybl.psse.model.pf.PsseTwoTerminalDcTransmissionLine;
import com.powsybl.psse.model.pf.PsseVoltageSourceConverterDcTransmissionLine;
import com.powsybl.psse.model.pf.PsseZone;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PssePowerFlowModel {
    private final PsseCaseIdentification caseIdentification;
    private final List<PsseBus> buses = new ArrayList<PsseBus>();
    private final List<PsseLoad> loads = new ArrayList<PsseLoad>();
    private final List<PsseFixedShunt> fixedShunts = new ArrayList<PsseFixedShunt>();
    private final List<PsseGenerator> generators = new ArrayList<PsseGenerator>();
    private final List<PsseNonTransformerBranch> nonTransformerBranches = new ArrayList<PsseNonTransformerBranch>();
    private final List<PsseTransformer> transformers = new ArrayList<PsseTransformer>();
    private final List<PsseArea> areas = new ArrayList<PsseArea>();
    private final List<PsseTwoTerminalDcTransmissionLine> twoTerminalDcTransmissionLines = new ArrayList<PsseTwoTerminalDcTransmissionLine>();
    private final List<PsseVoltageSourceConverterDcTransmissionLine> voltageSourceConverterDcTransmissionLines = new ArrayList<PsseVoltageSourceConverterDcTransmissionLine>();
    private final List<PsseTransformerImpedanceCorrection> transformerImpedanceCorrections = new ArrayList<PsseTransformerImpedanceCorrection>();
    private final List<PsseMultiTerminalDcTransmissionLine> multiTerminalDcTransmissionLines = new ArrayList<PsseMultiTerminalDcTransmissionLine>();
    private final List<PsseLineGrouping> lineGrouping = new ArrayList<PsseLineGrouping>();
    private final List<PsseZone> zones = new ArrayList<PsseZone>();
    private final List<PsseInterareaTransfer> interareaTransfer = new ArrayList<PsseInterareaTransfer>();
    private final List<PsseOwner> owners = new ArrayList<PsseOwner>();
    private final List<PsseFacts> facts = new ArrayList<PsseFacts>();
    private final List<PsseSwitchedShunt> switchedShunts = new ArrayList<PsseSwitchedShunt>();
    private final List<PsseGneDevice> gneDevice = new ArrayList<PsseGneDevice>();
    private final List<PsseInductionMachine> inductionMachines = new ArrayList<PsseInductionMachine>();

    public PssePowerFlowModel(PsseCaseIdentification caseIdentification) {
        this.caseIdentification = Objects.requireNonNull(caseIdentification);
    }

    public PsseCaseIdentification getCaseIdentification() {
        return this.caseIdentification;
    }

    public void addBuses(List<PsseBus> buses) {
        this.buses.addAll(this.modelled(buses));
    }

    public List<PsseBus> getBuses() {
        return Collections.unmodifiableList(this.buses);
    }

    public void addLoads(List<PsseLoad> loads) {
        this.loads.addAll(this.modelled(loads));
    }

    public List<PsseLoad> getLoads() {
        return Collections.unmodifiableList(this.loads);
    }

    public void addFixedShunts(List<PsseFixedShunt> fixedShunts) {
        this.fixedShunts.addAll(fixedShunts);
    }

    public List<PsseFixedShunt> getFixedShunts() {
        return Collections.unmodifiableList(this.fixedShunts);
    }

    public void addGenerators(List<PsseGenerator> generators) {
        this.generators.addAll(this.modelled(generators));
    }

    public List<PsseGenerator> getGenerators() {
        return Collections.unmodifiableList(this.generators);
    }

    public void addNonTransformerBranches(List<PsseNonTransformerBranch> nonTransformerBranches) {
        this.nonTransformerBranches.addAll(this.modelled(nonTransformerBranches));
    }

    public List<PsseNonTransformerBranch> getNonTransformerBranches() {
        return Collections.unmodifiableList(this.nonTransformerBranches);
    }

    public void addTransformers(List<PsseTransformer> transformers) {
        this.transformers.addAll(this.modelled(transformers));
    }

    public List<PsseTransformer> getTransformers() {
        return Collections.unmodifiableList(this.transformers);
    }

    public void addAreas(List<PsseArea> areas) {
        this.areas.addAll(areas);
    }

    public List<PsseArea> getAreas() {
        return Collections.unmodifiableList(this.areas);
    }

    public void addTwoTerminalDcTransmissionLines(List<PsseTwoTerminalDcTransmissionLine> twoTerminalDcTransmissionLines) {
        this.twoTerminalDcTransmissionLines.addAll(this.modelled(twoTerminalDcTransmissionLines));
    }

    public List<PsseTwoTerminalDcTransmissionLine> getTwoTerminalDcTransmissionLines() {
        return Collections.unmodifiableList(this.twoTerminalDcTransmissionLines);
    }

    public void addVoltageSourceConverterDcTransmissionLines(List<PsseVoltageSourceConverterDcTransmissionLine> voltageSourceConverterDcTransmissionLines) {
        this.voltageSourceConverterDcTransmissionLines.addAll(this.modelled(voltageSourceConverterDcTransmissionLines));
    }

    public List<PsseVoltageSourceConverterDcTransmissionLine> getVoltageSourceConverterDcTransmissionLines() {
        return Collections.unmodifiableList(this.voltageSourceConverterDcTransmissionLines);
    }

    public void addTransformerImpedanceCorrections(List<PsseTransformerImpedanceCorrection> transformerImpedanceCorrections) {
        this.transformerImpedanceCorrections.addAll(transformerImpedanceCorrections);
    }

    public List<PsseTransformerImpedanceCorrection> getTransformerImpedanceCorrections() {
        return Collections.unmodifiableList(this.transformerImpedanceCorrections);
    }

    public void addMultiTerminalDcTransmissionLines(List<PsseMultiTerminalDcTransmissionLine> multiTerminalDcTransmissionLines) {
        this.multiTerminalDcTransmissionLines.addAll(multiTerminalDcTransmissionLines);
    }

    public List<PsseMultiTerminalDcTransmissionLine> getMultiTerminalDcTransmissionLines() {
        return Collections.unmodifiableList(this.multiTerminalDcTransmissionLines);
    }

    public void addLineGrouping(List<PsseLineGrouping> lineGrouping) {
        this.lineGrouping.addAll(lineGrouping);
    }

    public List<PsseLineGrouping> getLineGrouping() {
        return Collections.unmodifiableList(this.lineGrouping);
    }

    public void addZones(List<PsseZone> zones) {
        this.zones.addAll(zones);
    }

    public List<PsseZone> getZones() {
        return Collections.unmodifiableList(this.zones);
    }

    public void addInterareaTransfer(List<PsseInterareaTransfer> interareaTransfer) {
        this.interareaTransfer.addAll(interareaTransfer);
    }

    public List<PsseInterareaTransfer> getInterareaTransfer() {
        return Collections.unmodifiableList(this.interareaTransfer);
    }

    public void addOwners(List<PsseOwner> owners) {
        this.owners.addAll(owners);
    }

    public List<PsseOwner> getOwners() {
        return Collections.unmodifiableList(this.owners);
    }

    public void addFacts(List<PsseFacts> facts) {
        this.facts.addAll(this.modelled(facts));
    }

    public List<PsseFacts> getFacts() {
        return Collections.unmodifiableList(this.facts);
    }

    public void addSwitchedShunts(List<PsseSwitchedShunt> switchedShunts) {
        this.switchedShunts.addAll(this.modelled(switchedShunts));
    }

    public List<PsseSwitchedShunt> getSwitchedShunts() {
        return Collections.unmodifiableList(this.switchedShunts);
    }

    public void addGneDevice(List<PsseGneDevice> gneDevice) {
        this.gneDevice.addAll(gneDevice);
    }

    public List<PsseGneDevice> getGneDevice() {
        return Collections.unmodifiableList(this.gneDevice);
    }

    public void addInductionMachines(List<PsseInductionMachine> inductionMachines) {
        this.inductionMachines.addAll(inductionMachines);
    }

    public List<PsseInductionMachine> getInductionMachines() {
        return Collections.unmodifiableList(this.inductionMachines);
    }

    public PssePowerFlowModel referenceAndCopyPssePowerFlowModel() {
        PssePowerFlowModel newPsseModel = new PssePowerFlowModel(this.getCaseIdentification());
        PssePowerFlowModel.referencePermanentBlocks(this, newPsseModel);
        PssePowerFlowModel.copyModifiedBlocks(this, newPsseModel);
        return newPsseModel;
    }

    private static void referencePermanentBlocks(PssePowerFlowModel psseModel, PssePowerFlowModel newPsseModel) {
        newPsseModel.addAreas(psseModel.getAreas());
        newPsseModel.addTwoTerminalDcTransmissionLines(psseModel.getTwoTerminalDcTransmissionLines());
        newPsseModel.addVoltageSourceConverterDcTransmissionLines(psseModel.getVoltageSourceConverterDcTransmissionLines());
        newPsseModel.addTransformerImpedanceCorrections(psseModel.getTransformerImpedanceCorrections());
        newPsseModel.addMultiTerminalDcTransmissionLines(psseModel.getMultiTerminalDcTransmissionLines());
        newPsseModel.addLineGrouping(psseModel.getLineGrouping());
        newPsseModel.addZones(psseModel.getZones());
        newPsseModel.addInterareaTransfer(psseModel.getInterareaTransfer());
        newPsseModel.addOwners(psseModel.getOwners());
        newPsseModel.addFacts(psseModel.getFacts());
        newPsseModel.addGneDevice(psseModel.getGneDevice());
        newPsseModel.addInductionMachines(psseModel.getInductionMachines());
    }

    private static void copyModifiedBlocks(PssePowerFlowModel psseModel, PssePowerFlowModel newPsseModel) {
        psseModel.getBuses().forEach(psseBus -> newPsseModel.buses.add(psseBus.copy()));
        psseModel.getLoads().forEach(psseLoad -> newPsseModel.loads.add(psseLoad.copy()));
        psseModel.getFixedShunts().forEach(psseFixedShunt -> newPsseModel.fixedShunts.add(psseFixedShunt.copy()));
        psseModel.getGenerators().forEach(psseGenerator -> newPsseModel.generators.add(psseGenerator.copy()));
        psseModel.getNonTransformerBranches().forEach(nonTransformerBranch -> newPsseModel.nonTransformerBranches.add(nonTransformerBranch.copy()));
        psseModel.getTransformers().forEach(psseTransformer -> newPsseModel.transformers.add(psseTransformer.copy()));
        psseModel.getSwitchedShunts().forEach(psseSwitchedShunt -> newPsseModel.switchedShunts.add(psseSwitchedShunt.copy()));
    }

    private <T extends PsseVersioned> List<T> modelled(List<T> elements) {
        for (PsseVersioned v : elements) {
            v.setModel(this);
        }
        return elements;
    }
}

