/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.pf.io;

import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.io.AbstractRecordGroup;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.io.FileFormat;
import com.powsybl.psse.model.io.LegacyTextReader;
import com.powsybl.psse.model.io.RecordGroupIOJson;
import com.powsybl.psse.model.io.RecordGroupIOLegacyText;
import com.powsybl.psse.model.pf.PsseMultiTerminalDcTransmissionLine;
import com.powsybl.psse.model.pf.io.PowerFlowRecordGroup;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class MultiTerminalDcTransmissionLineData
extends AbstractRecordGroup<PsseMultiTerminalDcTransmissionLine> {
    private static final String[] QUOTED_FIELDS = new String[]{"name", "dcname", "dcckt"};

    MultiTerminalDcTransmissionLineData() {
        super(PowerFlowRecordGroup.MULTI_TERMINAL_DC_TRANSMISSION_LINE, new String[0]);
        this.withIO(FileFormat.LEGACY_TEXT, new IOLegacyText(this));
        this.withIO(FileFormat.JSON, new IOJson(this));
    }

    @Override
    protected Class<PsseMultiTerminalDcTransmissionLine> psseTypeClass() {
        return PsseMultiTerminalDcTransmissionLine.class;
    }

    private static class IOLegacyText
    extends RecordGroupIOLegacyText<PsseMultiTerminalDcTransmissionLine> {
        IOLegacyText(AbstractRecordGroup<PsseMultiTerminalDcTransmissionLine> recordGroup) {
            super(recordGroup);
        }

        @Override
        public List<PsseMultiTerminalDcTransmissionLine> read(LegacyTextReader reader, Context context) throws IOException {
            MultiTerminalDcMainData mainData = new MultiTerminalDcMainData();
            ArrayList<PsseMultiTerminalDcTransmissionLine> multiTerminalList = new ArrayList<PsseMultiTerminalDcTransmissionLine>();
            ArrayList<String> converterRecords = new ArrayList<String>();
            ArrayList<String> busRecords = new ArrayList<String>();
            ArrayList<String> linkRecords = new ArrayList<String>();
            if (!reader.isQRecordFound()) {
                String line = reader.readRecordLine();
                while (!reader.endOfBlock(line)) {
                    PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcMain main = (PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcMain)mainData.readFromStrings(Collections.singletonList(line), context).get(0);
                    IOLegacyText.addNextNrecords(reader, converterRecords, main.getNconv());
                    IOLegacyText.addNextNrecords(reader, busRecords, main.getNdcbs());
                    IOLegacyText.addNextNrecords(reader, linkRecords, main.getNdcln());
                    line = reader.readRecordLine();
                    PsseMultiTerminalDcTransmissionLine multiTerminal = new PsseMultiTerminalDcTransmissionLine(main);
                    multiTerminalList.add(multiTerminal);
                }
            }
            List converterList = new MultiTerminalDcConverterData().readFromStrings(converterRecords, context);
            List busList = new MultiTerminalDcBusData().readFromStrings(busRecords, context);
            List linkList = new MultiTerminalDcLinkData().readFromStrings(linkRecords, context);
            int indexConverter = 0;
            int indexBus = 0;
            int indexLink = 0;
            for (PsseMultiTerminalDcTransmissionLine multiTerminal : multiTerminalList) {
                indexConverter = IOLegacyText.addNextN(multiTerminal.getDcConverters(), converterList, multiTerminal.getNconv(), indexConverter);
                indexBus = IOLegacyText.addNextN(multiTerminal.getDcBuses(), busList, multiTerminal.getNdcbs(), indexBus);
                indexLink = IOLegacyText.addNextN(multiTerminal.getDcLinks(), linkList, multiTerminal.getNdcln(), indexLink);
            }
            return multiTerminalList;
        }

        private static void addNextNrecords(LegacyTextReader reader, List<String> records, int nRecords) throws IOException {
            for (int n = 0; n < nRecords; ++n) {
                records.add(reader.readRecordLine());
            }
        }

        private static <T> int addNextN(List<T> multiTerminalItems, List<T> items, int nItems, int initialIndex) {
            int index = initialIndex;
            for (int n = 0; n < nItems; ++n) {
                multiTerminalItems.add(items.get(index));
                ++index;
            }
            return index;
        }

        @Override
        public void write(List<PsseMultiTerminalDcTransmissionLine> multiTerminalList, Context context, OutputStream outputStream) {
            ArrayList mainList = new ArrayList();
            ArrayList converterList = new ArrayList();
            ArrayList busList = new ArrayList();
            ArrayList linkList = new ArrayList();
            multiTerminalList.forEach(multiTerminal -> {
                mainList.add(multiTerminal.getMain());
                converterList.addAll(multiTerminal.getDcConverters());
                busList.addAll(multiTerminal.getDcBuses());
                linkList.addAll(multiTerminal.getDcLinks());
            });
            MultiTerminalDcMainData mainData = new MultiTerminalDcMainData();
            List<String> mainStrings = mainData.buildRecords(mainList, context.getFieldNames(PowerFlowRecordGroup.MULTI_TERMINAL_DC_TRANSMISSION_LINE), mainData.quotedFields(), context);
            MultiTerminalDcConverterData converterData = new MultiTerminalDcConverterData();
            List<String> converterStrings = converterData.buildRecords(converterList, context.getFieldNames(PowerFlowRecordGroup.INTERNAL_MULTI_TERMINAL_DC_CONVERTER), converterData.quotedFields(), context);
            MultiTerminalDcBusData busData = new MultiTerminalDcBusData();
            List<String> busStrings = busData.buildRecords(busList, context.getFieldNames(PowerFlowRecordGroup.INTERNAL_MULTI_TERMINAL_DC_BUS), busData.quotedFields(), context);
            MultiTerminalDcLinkData linkData = new MultiTerminalDcLinkData();
            List<String> linkStrings = linkData.buildRecords(linkList, context.getFieldNames(PowerFlowRecordGroup.INTERNAL_MULTI_TERMINAL_DC_LINK), linkData.quotedFields(), context);
            int indexMain = 0;
            int indexConverter = 0;
            int indexBus = 0;
            int indexLink = 0;
            this.writeBegin(outputStream);
            for (PsseMultiTerminalDcTransmissionLine multiTerminal2 : multiTerminalList) {
                ArrayList<String> strings = new ArrayList<String>();
                indexMain = IOLegacyText.addNextNstrings(mainStrings, strings, 1, indexMain);
                indexConverter = IOLegacyText.addNextNstrings(converterStrings, strings, multiTerminal2.getNconv(), indexConverter);
                indexBus = IOLegacyText.addNextNstrings(busStrings, strings, multiTerminal2.getNdcbs(), indexBus);
                indexLink = IOLegacyText.addNextNstrings(linkStrings, strings, multiTerminal2.getNdcln(), indexLink);
                IOLegacyText.write(strings, outputStream);
            }
            this.writeEnd(outputStream);
        }

        private static int addNextNstrings(List<String> sourceStrings, List<String> strings, int nStrings, int initialIndex) {
            int index = initialIndex;
            for (int n = 0; n < nStrings; ++n) {
                strings.add(sourceStrings.get(index));
                ++index;
            }
            return index;
        }

        private static class MultiTerminalDcConverterData
        extends AbstractRecordGroup<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcConverter> {
            MultiTerminalDcConverterData() {
                super(PowerFlowRecordGroup.INTERNAL_MULTI_TERMINAL_DC_CONVERTER, "ib", "n", "angmx", "angmn", "rc", "xc", "ebas", "tr", "tap", "tpmx", "tpmn", "tstp", "setvl", "dcpf", "marg", "cnvcod");
                this.withQuotedFields(QUOTED_FIELDS);
            }

            @Override
            public Class<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcConverter> psseTypeClass() {
                return PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcConverter.class;
            }
        }

        private static class MultiTerminalDcBusData
        extends AbstractRecordGroup<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcBus> {
            MultiTerminalDcBusData() {
                super(PowerFlowRecordGroup.INTERNAL_MULTI_TERMINAL_DC_BUS, "idc", "ib", "area", "zone", "dcname", "idc2", "rgrnd", "owner");
                this.withQuotedFields(QUOTED_FIELDS);
            }

            @Override
            public Class<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcBus> psseTypeClass() {
                return PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcBus.class;
            }
        }

        private static class MultiTerminalDcLinkData
        extends AbstractRecordGroup<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcLink> {
            MultiTerminalDcLinkData() {
                super(PowerFlowRecordGroup.INTERNAL_MULTI_TERMINAL_DC_LINK, "idc", "jdc", "dcckt", "met", "rdc", "ldc");
                this.withQuotedFields(QUOTED_FIELDS);
            }

            @Override
            public Class<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcLink> psseTypeClass() {
                return PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcLink.class;
            }
        }
    }

    private static class IOJson
    extends RecordGroupIOJson<PsseMultiTerminalDcTransmissionLine> {
        IOJson(AbstractRecordGroup<PsseMultiTerminalDcTransmissionLine> recordGroup) {
            super(recordGroup);
        }

        @Override
        public List<PsseMultiTerminalDcTransmissionLine> read(LegacyTextReader reader, Context context) throws IOException {
            if (reader != null) {
                throw new PsseException("Unexpected reader. Should be null");
            }
            List<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcMain> mainList = new MultiTerminalDcMainData().read(null, context);
            List<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcConverterx> converterxList = new MultiTerminalDcConverterxData().read(null, context);
            List<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcBusx> busxList = new MultiTerminalDcBusxData().read(null, context);
            List<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcLinkx> linkxList = new MultiTerminalDcLinkxData().read(null, context);
            return IOJson.convertToMultiTerminalList(mainList, converterxList, busxList, linkxList);
        }

        @Override
        public void write(List<PsseMultiTerminalDcTransmissionLine> multiTerminalList, Context context, OutputStream outputStream) {
            if (outputStream != null) {
                throw new PsseException("Unexpected outputStream. Should be null");
            }
            List mainList = multiTerminalList.stream().map(PsseMultiTerminalDcTransmissionLine::getMain).collect(Collectors.toList());
            new MultiTerminalDcMainData().write(mainList, context, null);
            ArrayList converterxList = new ArrayList();
            multiTerminalList.forEach(multiTerminalDcTransmissionLine -> multiTerminalDcTransmissionLine.getDcConverters().forEach(converter -> converterxList.add(new PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcConverterx(multiTerminalDcTransmissionLine.getMain().getName(), (PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcConverter)converter))));
            new MultiTerminalDcConverterxData().write(converterxList, context, null);
            ArrayList busxList = new ArrayList();
            multiTerminalList.forEach(multiTerminalDcTransmissionLine -> multiTerminalDcTransmissionLine.getDcBuses().forEach(bus -> busxList.add(new PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcBusx(multiTerminalDcTransmissionLine.getMain().getName(), (PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcBus)bus))));
            new MultiTerminalDcBusxData().write(busxList, context, null);
            ArrayList linkxList = new ArrayList();
            multiTerminalList.forEach(multiTerminalDcTransmissionLine -> multiTerminalDcTransmissionLine.getDcLinks().forEach(link -> linkxList.add(new PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcLinkx(multiTerminalDcTransmissionLine.getMain().getName(), (PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcLink)link))));
            new MultiTerminalDcLinkxData().write(linkxList, context, null);
        }

        private static List<PsseMultiTerminalDcTransmissionLine> convertToMultiTerminalList(List<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcMain> mainList, List<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcConverterx> converterxList, List<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcBusx> busxList, List<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcLinkx> linkxList) {
            ArrayList<PsseMultiTerminalDcTransmissionLine> multiTerminalDcTransmissionLineList = new ArrayList<PsseMultiTerminalDcTransmissionLine>();
            for (PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcMain main : mainList) {
                List<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcConverter> converterList = converterxList.stream().filter(c -> c.getName().equals(main.getName())).map(PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcConverterx::getConverter).collect(Collectors.toList());
                List<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcBus> busList = busxList.stream().filter(c -> c.getName().equals(main.getName())).map(PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcBusx::getBus).collect(Collectors.toList());
                List<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcLink> linkList = linkxList.stream().filter(c -> c.getName().equals(main.getName())).map(PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcLinkx::getLink).collect(Collectors.toList());
                multiTerminalDcTransmissionLineList.add(new PsseMultiTerminalDcTransmissionLine(main, converterList, busList, linkList));
            }
            return multiTerminalDcTransmissionLineList;
        }

        private static class MultiTerminalDcConverterxData
        extends AbstractRecordGroup<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcConverterx> {
            MultiTerminalDcConverterxData() {
                super(PowerFlowRecordGroup.INTERNAL_MULTI_TERMINAL_DC_CONVERTER, new String[0]);
                this.withQuotedFields(QUOTED_FIELDS);
            }

            @Override
            public Class<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcConverterx> psseTypeClass() {
                return PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcConverterx.class;
            }
        }

        private static class MultiTerminalDcBusxData
        extends AbstractRecordGroup<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcBusx> {
            MultiTerminalDcBusxData() {
                super(PowerFlowRecordGroup.INTERNAL_MULTI_TERMINAL_DC_BUS, new String[0]);
                this.withQuotedFields(QUOTED_FIELDS);
            }

            @Override
            public Class<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcBusx> psseTypeClass() {
                return PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcBusx.class;
            }
        }

        private static class MultiTerminalDcLinkxData
        extends AbstractRecordGroup<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcLinkx> {
            MultiTerminalDcLinkxData() {
                super(PowerFlowRecordGroup.INTERNAL_MULTI_TERMINAL_DC_LINK, new String[0]);
                this.withQuotedFields(QUOTED_FIELDS);
            }

            @Override
            public Class<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcLinkx> psseTypeClass() {
                return PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcLinkx.class;
            }
        }
    }

    private static class MultiTerminalDcMainData
    extends AbstractRecordGroup<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcMain> {
        MultiTerminalDcMainData() {
            super(PowerFlowRecordGroup.MULTI_TERMINAL_DC_TRANSMISSION_LINE, "name", "nconv", "ndcbs", "ndcln", "mdc", "vconv", "vcmod", "vconvn");
            this.withQuotedFields(QUOTED_FIELDS);
        }

        @Override
        public Class<PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcMain> psseTypeClass() {
            return PsseMultiTerminalDcTransmissionLine.PsseMultiTerminalDcMain.class;
        }
    }
}

