/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.io;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.io.FileFormat;
import com.powsybl.psse.model.io.RecordGroupIdentification;
import com.univocity.parsers.common.DataProcessingException;
import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.ProcessorErrorHandler;
import com.univocity.parsers.common.RetryableErrorHandler;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context {
    private static final Logger LOGGER = LoggerFactory.getLogger(Context.class);
    private final Map<String, String[]> fieldNames = new HashMap<String, String[]>();
    private final CsvParserSettings csvParserSettings;
    private FileFormat fileFormat = FileFormat.LEGACY_TEXT;
    private char delimiter = FileFormat.LEGACY_TEXT.getDefaultDelimiter();
    private PsseVersion version;
    private int currentRecordGroupMaxNumFields;
    private JsonGenerator jsonGenerator;
    private JsonNode networkNode;

    public Context() {
        this.csvParserSettings = new CsvParserSettings();
        this.csvParserSettings.setHeaderExtractionEnabled(false);
        this.csvParserSettings.setQuoteDetectionEnabled(true);
        this.csvParserSettings.setProcessorErrorHandler((ProcessorErrorHandler)new RetryableErrorHandler<ParsingContext>(){

            public void handleError(DataProcessingException error, Object[] inputRow, ParsingContext context) {
                LOGGER.error("Parsing context {}", (Object)context, (Object)error);
            }
        });
    }

    public PsseVersion getVersion() {
        return this.version;
    }

    public Context setVersion(PsseVersion version) {
        this.version = version;
        return this;
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public Context setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    private Context setDelimiter(char delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public void detectDelimiter(String record) {
        this.csvParserSettings.setDelimiterDetectionEnabled(true, ", ".toCharArray());
        CsvParser parser = new CsvParser(this.csvParserSettings);
        parser.parseLine(record);
        this.setDelimiter(parser.getDetectedFormat().getDelimiterString().charAt(0));
        ((CsvFormat)this.csvParserSettings.getFormat()).setDelimiter(this.getDelimiter());
        ((CsvFormat)this.csvParserSettings.getFormat()).setQuote(this.getFileFormat().getQuote());
        this.csvParserSettings.setDelimiterDetectionEnabled(false);
        this.csvParserSettings.setQuoteDetectionEnabled(false);
    }

    public Context setFieldNames(RecordGroupIdentification recordGroup, String[] fieldNames) {
        this.fieldNames.put(recordGroup.getUniqueName(), fieldNames);
        return this;
    }

    public String[] getFieldNames(RecordGroupIdentification recordGroup) {
        return this.fieldNames.get(recordGroup.getUniqueName());
    }

    CsvParserSettings getCsvParserSettings() {
        return this.csvParserSettings;
    }

    void resetCurrentRecordGroup() {
        this.currentRecordGroupMaxNumFields = 0;
    }

    public int getCurrentRecordGroupMaxNumFields() {
        return this.currentRecordGroupMaxNumFields;
    }

    Context setCurrentRecordNumFields(int numFields) {
        this.currentRecordGroupMaxNumFields = Math.max(this.currentRecordGroupMaxNumFields, numFields);
        return this;
    }

    JsonGenerator getJsonGenerator() {
        return this.jsonGenerator;
    }

    public Context setJsonGenerator(JsonGenerator jsonGenerator) {
        this.jsonGenerator = jsonGenerator;
        return this;
    }

    JsonNode getNetworkNode() {
        return this.networkNode;
    }

    public Context setNetworkNode(JsonNode networkNode) {
        this.networkNode = networkNode;
        return this;
    }
}

