/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.pf.io;

import com.powsybl.psse.model.io.AbstractRecordGroup;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.io.FileFormat;
import com.powsybl.psse.model.io.RecordGroupIOLegacyText;
import com.powsybl.psse.model.pf.PsseLineGrouping;
import com.powsybl.psse.model.pf.io.PowerFlowRecordGroup;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

class MultiSectionLineGroupingData
extends AbstractRecordGroup<PsseLineGrouping> {
    MultiSectionLineGroupingData() {
        super(PowerFlowRecordGroup.MULTI_SECTION_LINE_GROUPING, "i", "j", "id", "met", "dum1", "dum2", "dum3", "dum4", "dum5", "dum6", "dum7", "dum8", "dum9");
        this.withQuotedFields("id", "mslid");
        this.withIO(FileFormat.LEGACY_TEXT, new IOLegacyText(this));
    }

    @Override
    protected Class<PsseLineGrouping> psseTypeClass() {
        return PsseLineGrouping.class;
    }

    private static class IOLegacyText
    extends RecordGroupIOLegacyText<PsseLineGrouping> {
        IOLegacyText(AbstractRecordGroup<PsseLineGrouping> recordGroup) {
            super(recordGroup);
        }

        @Override
        public void write(List<PsseLineGrouping> lineGroupingList, Context context, OutputStream outputStream) {
            this.writeBegin(outputStream);
            String[] headers = this.recordGroup.fieldNames(context.getVersion());
            String[] quotedFields = this.recordGroup.quotedFields();
            lineGroupingList.forEach(lineGrouping -> {
                String[] writeHeaders = (String[])ArrayUtils.subarray((Object[])headers, (int)0, (int)IOLegacyText.validRecordFields(lineGrouping));
                String record = this.recordGroup.buildRecord(lineGrouping, writeHeaders, quotedFields, context);
                IOLegacyText.write(String.format("%s%n", record), outputStream);
            });
            this.writeEnd(outputStream);
        }

        private static int validRecordFields(PsseLineGrouping record) {
            int valid = 4;
            List<Integer> list = Arrays.asList(record.getDum1(), record.getDum2(), record.getDum3(), record.getDum4(), record.getDum5(), record.getDum6(), record.getDum7(), record.getDum8(), record.getDum9());
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) == null) {
                    return valid;
                }
                ++valid;
            }
            return valid;
        }
    }
}

