/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.pf;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.PsseVersion;
import com.univocity.parsers.annotations.Format;
import com.univocity.parsers.annotations.Parsed;
import java.io.IOException;

public class PsseCaseIdentification {
    @Parsed
    private int ic = 0;
    @Parsed
    private double sbase = 100.0;
    @Parsed
    @Format(formats={"0.##"})
    @JsonSerialize(using=RevisionSerializer.class)
    private float rev = 33.0f;
    @Parsed
    @Format(formats={"0"})
    private double xfrrat = Double.NaN;
    @Parsed
    @Format(formats={"0"})
    private double nxfrat = Double.NaN;
    @Parsed
    private double basfrq = Double.NaN;
    @Parsed(defaultNullRead="")
    private String title1;
    @Parsed(defaultNullRead="")
    private String title2;

    public int getIc() {
        return this.ic;
    }

    public void setIc(int ic) {
        this.ic = ic;
    }

    public double getSbase() {
        return this.sbase;
    }

    public void setSbase(double sbase) {
        this.sbase = sbase;
    }

    public float getRev() {
        return this.rev;
    }

    public void setRev(float rev) {
        this.rev = rev;
    }

    public double getXfrrat() {
        return this.xfrrat;
    }

    public void setXfrrat(double xfrrat) {
        this.xfrrat = xfrrat;
    }

    public double getNxfrat() {
        return this.nxfrat;
    }

    public void setNxfrat(double nxfrat) {
        this.nxfrat = nxfrat;
    }

    public double getBasfrq() {
        return this.basfrq;
    }

    public void setBasfrq(double basfrq) {
        this.basfrq = basfrq;
    }

    public String getTitle1() {
        return this.title1;
    }

    public void setTitle1(String title1) {
        this.title1 = title1;
    }

    public String getTitle2() {
        return this.title2;
    }

    public void setTitle2(String title2) {
        this.title2 = title2;
    }

    public void validate() {
        if (this.ic == 1) {
            throw new PsseException("Incremental load of data option (IC = 1) is not supported");
        }
        PsseVersion v = PsseVersion.fromRevision(this.rev);
        if (!v.isSupported()) {
            throw new PsseException(String.format("Version %s not supported. Supported versions are: %s", v, PsseVersion.supportedVersions()));
        }
    }

    private static class RevisionSerializer
    extends JsonSerializer<Float> {
        private RevisionSerializer() {
        }

        public void serialize(Float value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            String rev = PsseVersion.fromRevision(value.floatValue()).toString();
            generator.writeRawValue(rev);
        }
    }
}

