/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.pf;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.powsybl.psse.model.PsseVersioned;
import com.powsybl.psse.model.Revision;
import com.powsybl.psse.model.pf.PsseOwnership;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.PsseRates;
import com.powsybl.psse.model.pf.PsseTransformerWinding;
import com.powsybl.psse.model.pf.io.WindingHeaderTransformer;
import com.powsybl.psse.model.pf.io.WindingRatesHeaderTransformer;
import com.univocity.parsers.annotations.Nested;
import com.univocity.parsers.annotations.NullString;
import com.univocity.parsers.annotations.Parsed;

@JsonPropertyOrder(alphabetic=true)
@JsonIgnoreProperties(value={"impedances"})
public class PsseTransformer
extends PsseVersioned {
    @Parsed(field={"i", "ibus"})
    private int i;
    @Parsed(field={"j", "jbus"})
    private int j;
    @Parsed(field={"k", "kbus"})
    private int k = 0;
    @Parsed(defaultNullRead="1")
    private String ckt;
    @Parsed
    private int cw = 1;
    @Parsed
    private int cz = 1;
    @Parsed
    private int cm = 1;
    @Parsed
    private double mag1 = 0.0;
    @Parsed
    private double mag2 = 0.0;
    @Parsed(field={"nmetr", "nmet"})
    private int nmetr = 2;
    @Parsed(defaultNullRead="            ")
    private String name;
    @Parsed
    private int stat = 1;
    @Nested
    private PsseOwnership ownership;
    @Parsed(defaultNullRead="            ")
    @Revision(since=33.0f)
    private String vecgrp = "            ";
    @NullString(nulls={"null"})
    @Parsed
    @Revision(since=35.0f)
    private int zcod = 0;
    @Nested
    TransformerImpedances impedances;
    @Nested(headerTransformer=WindingHeaderTransformer.class, args={"1"})
    private PsseTransformerWinding winding1;
    @Nested(headerTransformer=WindingRatesHeaderTransformer.class, args={"1"})
    private PsseRates winding1Rates;
    @Nested(headerTransformer=WindingHeaderTransformer.class, args={"2"})
    private PsseTransformerWinding winding2;
    @Nested(headerTransformer=WindingRatesHeaderTransformer.class, args={"2"})
    private PsseRates winding2Rates;
    @Nested(headerTransformer=WindingHeaderTransformer.class, args={"3"})
    private PsseTransformerWinding winding3;
    @Nested(headerTransformer=WindingRatesHeaderTransformer.class, args={"3"})
    private PsseRates winding3Rates;

    @Override
    public void setModel(PssePowerFlowModel model) {
        super.setModel(model);
        this.ownership.setModel(model);
        this.winding1.setModel(model);
        this.winding2.setModel(model);
        this.winding3.setModel(model);
        this.winding1Rates.setModel(model);
        this.winding2Rates.setModel(model);
        this.winding3Rates.setModel(model);
    }

    public int getI() {
        return this.i;
    }

    public void setI(int i) {
        this.i = i;
    }

    public int getJ() {
        return this.j;
    }

    public void setJ(int j) {
        this.j = j;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public String getCkt() {
        return this.ckt;
    }

    public void setCkt(String ckt) {
        this.ckt = ckt;
    }

    public int getCw() {
        return this.cw;
    }

    public void setCw(int cw) {
        this.cw = cw;
    }

    public int getCz() {
        return this.cz;
    }

    public void setCz(int cz) {
        this.cz = cz;
    }

    public int getCm() {
        return this.cm;
    }

    public void setCm(int cm) {
        this.cm = cm;
    }

    public double getMag1() {
        return this.mag1;
    }

    public void setMag1(double mag1) {
        this.mag1 = mag1;
    }

    public double getMag2() {
        return this.mag2;
    }

    public void setMag2(double mag2) {
        this.mag2 = mag2;
    }

    public int getNmetr() {
        return this.nmetr;
    }

    public void setNmetr(int nmetr) {
        this.nmetr = nmetr;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getStat() {
        return this.stat;
    }

    public void setStat(int stat) {
        this.stat = stat;
    }

    public String getVecgrp() {
        this.checkVersion("vecgrp");
        return this.vecgrp;
    }

    public void setVecgrp(String vecgrp) {
        this.checkVersion("vecgrp");
        this.vecgrp = vecgrp;
    }

    public int getZcod() {
        this.checkVersion("zcod");
        return this.zcod;
    }

    public void setZcod(int zcod) {
        this.zcod = zcod;
    }

    public double getR12() {
        return this.impedances.r12;
    }

    public void setR12(double r12) {
        this.impedances.r12 = r12;
    }

    public double getX12() {
        return this.impedances.x12;
    }

    public void setX12(double x12) {
        this.impedances.x12 = x12;
    }

    public double getSbase12() {
        return this.impedances.sbase12;
    }

    public void setSbase12(double sbase12) {
        this.impedances.sbase12 = sbase12;
    }

    public double getR23() {
        return this.impedances.r23;
    }

    public void setR23(double r23) {
        this.impedances.r23 = r23;
    }

    public double getX23() {
        return this.impedances.x23;
    }

    public void setX23(double x23) {
        this.impedances.x23 = x23;
    }

    public double getSbase23() {
        return this.impedances.sbase23;
    }

    public void setSbase23(double sbase23) {
        this.impedances.sbase23 = sbase23;
    }

    public double getR31() {
        return this.impedances.r31;
    }

    public void setR31(double r31) {
        this.impedances.r31 = r31;
    }

    public double getX31() {
        return this.impedances.x31;
    }

    public void setX31(double x31) {
        this.impedances.x31 = x31;
    }

    public double getSbase31() {
        return this.impedances.sbase31;
    }

    public void setSbase31(double sbase31) {
        this.impedances.sbase31 = sbase31;
    }

    public double getVmstar() {
        return this.impedances.vmstar;
    }

    public void setVmstar(double vmstar) {
        this.impedances.vmstar = vmstar;
    }

    public double getAnstar() {
        return this.impedances.anstar;
    }

    public void setAnstar(double anstar) {
        this.impedances.anstar = anstar;
    }

    public PsseTransformerWinding getWinding1() {
        return this.winding1;
    }

    public PsseTransformerWinding getWinding2() {
        return this.winding2;
    }

    public PsseTransformerWinding getWinding3() {
        return this.winding3;
    }

    public PsseRates getWinding1Rates() {
        return this.winding1Rates;
    }

    public PsseRates getWinding2Rates() {
        return this.winding2Rates;
    }

    public PsseRates getWinding3Rates() {
        return this.winding3Rates;
    }

    public PsseOwnership getOwnership() {
        return this.ownership;
    }

    public void setWinding1(PsseTransformerWinding winding1, PsseRates winding1Rates) {
        this.winding1 = winding1;
        this.winding1Rates = winding1Rates;
    }

    public void setWinding2(PsseTransformerWinding winding2, PsseRates winding2Rates) {
        this.winding2 = winding2;
        this.winding2Rates = winding2Rates;
    }

    public void setWinding3(PsseTransformerWinding winding3, PsseRates winding3Rates) {
        this.winding3 = winding3;
        this.winding3Rates = winding3Rates;
    }

    public void setOwnership(PsseOwnership ownership) {
        this.ownership = ownership;
    }

    public TransformerImpedances getImpedances() {
        return this.impedances;
    }

    public void setImpedances(TransformerImpedances impedances) {
        this.impedances = impedances;
    }

    public PsseTransformer copy() {
        PsseTransformer copy = new PsseTransformer();
        copy.i = this.i;
        copy.j = this.j;
        copy.k = this.k;
        copy.ckt = this.ckt;
        copy.cw = this.cw;
        copy.cz = this.cz;
        copy.cm = this.cm;
        copy.mag1 = this.mag1;
        copy.mag2 = this.mag2;
        copy.nmetr = this.nmetr;
        copy.name = this.name;
        copy.stat = this.stat;
        copy.ownership = this.ownership.copy();
        copy.vecgrp = this.vecgrp;
        copy.zcod = this.zcod;
        copy.impedances = this.impedances.copy();
        copy.winding1 = this.winding1.copy();
        copy.winding1Rates = this.winding1Rates.copy();
        copy.winding2 = this.winding2.copy();
        copy.winding2Rates = this.winding2Rates.copy();
        copy.winding3 = this.winding3.copy();
        copy.winding3Rates = this.winding3Rates.copy();
        return copy;
    }

    public static class TransformerImpedances {
        @Parsed(field={"r12", "r1_2"})
        private double r12 = 0.0;
        @Parsed(field={"x12", "x1_2"})
        private double x12;
        @Parsed(field={"sbase12", "sbase1_2"})
        private double sbase12 = Double.NaN;
        @NullString(nulls={"null"})
        @Parsed(field={"r23", "r2_3"})
        private double r23 = 0.0;
        @NullString(nulls={"null"})
        @Parsed(field={"x23", "x2_3"})
        private double x23 = Double.NaN;
        @NullString(nulls={"null"})
        @Parsed(field={"sbase23", "sbase2_3"})
        private double sbase23 = Double.NaN;
        @NullString(nulls={"null"})
        @Parsed(field={"r31", "r3_1"})
        private double r31 = 0.0;
        @NullString(nulls={"null"})
        @Parsed(field={"x31", "x3_1"})
        private double x31 = Double.NaN;
        @NullString(nulls={"null"})
        @Parsed(field={"sbase31", "sbase3_1"})
        private double sbase31 = Double.NaN;
        @NullString(nulls={"null"})
        @Parsed
        private double vmstar = 1.0;
        @NullString(nulls={"null"})
        @Parsed
        private double anstar = 0.0;

        public TransformerImpedances copy() {
            TransformerImpedances copy = new TransformerImpedances();
            copy.r12 = this.r12;
            copy.x12 = this.x12;
            copy.sbase12 = this.sbase12;
            copy.r23 = this.r23;
            copy.x23 = this.x23;
            copy.sbase23 = this.sbase23;
            copy.r31 = this.r31;
            copy.x31 = this.x31;
            copy.sbase31 = this.sbase31;
            copy.vmstar = this.vmstar;
            copy.anstar = this.anstar;
            return copy;
        }
    }
}

