/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.pf.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.io.FileFormat;
import com.powsybl.psse.model.pf.PsseCaseIdentification;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.io.AreaInterchangeData;
import com.powsybl.psse.model.pf.io.BusData;
import com.powsybl.psse.model.pf.io.CaseIdentificationData;
import com.powsybl.psse.model.pf.io.FactsDeviceData;
import com.powsybl.psse.model.pf.io.FixedBusShuntData;
import com.powsybl.psse.model.pf.io.GeneratorData;
import com.powsybl.psse.model.pf.io.GneDeviceData;
import com.powsybl.psse.model.pf.io.InductionMachineData;
import com.powsybl.psse.model.pf.io.InterareaTransferData;
import com.powsybl.psse.model.pf.io.LoadData;
import com.powsybl.psse.model.pf.io.MultiSectionLineGroupingData;
import com.powsybl.psse.model.pf.io.MultiTerminalDcTransmissionLineData;
import com.powsybl.psse.model.pf.io.NonTransformerBranchData;
import com.powsybl.psse.model.pf.io.OwnerData;
import com.powsybl.psse.model.pf.io.PowerFlowRawxDataAllVersions;
import com.powsybl.psse.model.pf.io.SubstationData;
import com.powsybl.psse.model.pf.io.SwitchedShuntData;
import com.powsybl.psse.model.pf.io.TransformerData;
import com.powsybl.psse.model.pf.io.TransformerImpedanceCorrectionTablesData;
import com.powsybl.psse.model.pf.io.TwoTerminalDcTransmissionLineData;
import com.powsybl.psse.model.pf.io.VoltageSourceConverterDcTransmissionLineData;
import com.powsybl.psse.model.pf.io.ZoneData;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class PowerFlowRawxData35
extends PowerFlowRawxDataAllVersions {
    @Override
    public PssePowerFlowModel read(ReadOnlyDataSource dataSource, String ext, Context context) throws IOException {
        context.setFileFormat(FileFormat.JSON);
        try (InputStream is = dataSource.newInputStream(null, ext);){
            PssePowerFlowModel pssePowerFlowModel = this.read(is, context);
            return pssePowerFlowModel;
        }
    }

    private PssePowerFlowModel read(InputStream stream, Context context) throws IOException {
        JsonNode networkNode = this.networkNode(stream);
        context.setNetworkNode(networkNode);
        PsseCaseIdentification caseIdentification = (PsseCaseIdentification)new CaseIdentificationData().readHead(null, context);
        caseIdentification.validate();
        PssePowerFlowModel model = new PssePowerFlowModel(caseIdentification);
        model.addBuses(new BusData().read(null, context));
        model.addLoads(new LoadData().read(null, context));
        model.addFixedShunts(new FixedBusShuntData().read(null, context));
        model.addGenerators(new GeneratorData().read(null, context));
        model.addNonTransformerBranches(new NonTransformerBranchData().read(null, context));
        model.addTransformers(new TransformerData().read(null, context));
        model.addAreas(new AreaInterchangeData().read(null, context));
        model.addTwoTerminalDcTransmissionLines(new TwoTerminalDcTransmissionLineData().read(null, context));
        model.addVoltageSourceConverterDcTransmissionLines(new VoltageSourceConverterDcTransmissionLineData().read(null, context));
        model.addTransformerImpedanceCorrections(new TransformerImpedanceCorrectionTablesData().read(null, context));
        model.addMultiTerminalDcTransmissionLines(new MultiTerminalDcTransmissionLineData().read(null, context));
        model.addLineGrouping(new MultiSectionLineGroupingData().read(null, context));
        model.addZones(new ZoneData().read(null, context));
        model.addInterareaTransfer(new InterareaTransferData().read(null, context));
        model.addOwners(new OwnerData().read(null, context));
        model.addFacts(new FactsDeviceData().read(null, context));
        model.addSwitchedShunts(new SwitchedShuntData().read(null, context));
        model.addGneDevice(new GneDeviceData().read(null, context));
        model.addInductionMachines(new InductionMachineData().read(null, context));
        model.addSubstations(new SubstationData().read(null, context));
        return model;
    }

    @Override
    public void write(PssePowerFlowModel model, Context context, DataSource dataSource) throws IOException {
        Objects.requireNonNull(model);
        Objects.requireNonNull(context);
        Objects.requireNonNull(dataSource);
        if (context.getVersion().major() != PsseVersion.Major.V35) {
            throw new PsseException("Unexpected version " + context.getVersion().getMajorNumber());
        }
        try (BufferedOutputStream outputStream = new BufferedOutputStream(dataSource.newOutputStream(null, "rawx", false));){
            this.write(model, context, outputStream);
        }
    }

    private void write(PssePowerFlowModel model, Context context, BufferedOutputStream outputStream) throws IOException {
        try (JsonGenerator generator = new JsonFactory().createGenerator((OutputStream)outputStream).setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());){
            context.setJsonGenerator(generator);
            generator.writeStartObject();
            generator.writeFieldName("network");
            generator.writeStartObject();
            generator.flush();
            new CaseIdentificationData().writeHead(model.getCaseIdentification(), context, null);
            new BusData().write(model.getBuses(), context, null);
            new LoadData().write(model.getLoads(), context, null);
            new FixedBusShuntData().write(model.getFixedShunts(), context, null);
            new GeneratorData().write(model.getGenerators(), context, null);
            new NonTransformerBranchData().write(model.getNonTransformerBranches(), context, null);
            new TransformerData().write(model.getTransformers(), context, null);
            new AreaInterchangeData().write(model.getAreas(), context, null);
            new TwoTerminalDcTransmissionLineData().write(model.getTwoTerminalDcTransmissionLines(), context, null);
            new VoltageSourceConverterDcTransmissionLineData().write(model.getVoltageSourceConverterDcTransmissionLines(), context, null);
            new TransformerImpedanceCorrectionTablesData().write(model.getTransformerImpedanceCorrections(), context, null);
            new MultiTerminalDcTransmissionLineData().write(model.getMultiTerminalDcTransmissionLines(), context, null);
            new MultiSectionLineGroupingData().write(model.getLineGrouping(), context, null);
            new ZoneData().write(model.getZones(), context, null);
            new InterareaTransferData().write(model.getInterareaTransfer(), context, null);
            new OwnerData().write(model.getOwners(), context, null);
            new FactsDeviceData().write(model.getFacts(), context, null);
            new SwitchedShuntData().write(model.getSwitchedShunts(), context, null);
            new GneDeviceData().write(model.getGneDevice(), context, null);
            new InductionMachineData().write(model.getInductionMachines(), context, null);
            new SubstationData().write(model.getSubstations(), context, null);
            generator.writeEndObject();
            generator.writeEndObject();
            generator.flush();
        }
    }
}

