/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.pf.io;

import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.io.AbstractRecordGroup;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.io.FileFormat;
import com.powsybl.psse.model.io.LegacyTextReader;
import com.powsybl.psse.model.io.RecordGroupIOJson;
import com.powsybl.psse.model.io.RecordGroupIOLegacyText;
import com.powsybl.psse.model.pf.PsseSubstation;
import com.powsybl.psse.model.pf.io.PowerFlowRecordGroup;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class SubstationData
extends AbstractRecordGroup<PsseSubstation> {
    private static final String[] QUOTED_FIELDS = new String[]{"name", "type", "id", "ckt", "eqid"};
    private static final String[] QUOTED_FIELDS_SWITCHING_DEVICES = new String[]{"name", "ckt"};

    SubstationData() {
        super(PowerFlowRecordGroup.SUBSTATION, new String[0]);
        this.withIO(FileFormat.LEGACY_TEXT, new IOLegacyText(this));
        this.withIO(FileFormat.JSON, new IOJson(this));
    }

    @Override
    protected Class<PsseSubstation> psseTypeClass() {
        return PsseSubstation.class;
    }

    private static class IOLegacyText
    extends RecordGroupIOLegacyText<PsseSubstation> {
        IOLegacyText(AbstractRecordGroup<PsseSubstation> recordGroup) {
            super(recordGroup);
        }

        @Override
        public List<PsseSubstation> read(LegacyTextReader reader, Context context) throws IOException {
            SubstationRecordData recordData = new SubstationRecordData();
            ArrayList<PsseSubstation> substationList = new ArrayList<PsseSubstation>();
            if (!reader.isQRecordFound()) {
                String line = reader.readUntilFindingARecordLineNotEmpty();
                while (!reader.endOfBlock(line)) {
                    PsseSubstation.PsseSubstationRecord substationRecord = (PsseSubstation.PsseSubstationRecord)recordData.readFromStrings(Collections.singletonList(line), context).get(0);
                    List<PsseSubstation.PsseSubstationNode> nodeList = new SubstationNodeData().read(reader, context);
                    List<PsseSubstation.PsseSubstationSwitchingDevice> switchingDeviceList = new SubstationSwitchingDeviceData().read(reader, context);
                    List<PsseSubstation.PsseSubstationEquipmentTerminal> equipmentTerminalList = this.readEquipmentTerminalData(reader, context);
                    PsseSubstation substation = new PsseSubstation(substationRecord, nodeList, switchingDeviceList, equipmentTerminalList);
                    substationList.add(substation);
                    line = reader.readUntilFindingARecordLineNotEmpty();
                }
            }
            return substationList;
        }

        private List<PsseSubstation.PsseSubstationEquipmentTerminal> readEquipmentTerminalData(LegacyTextReader reader, Context context) throws IOException {
            SubstationEquipmentTerminalDataCommonStart commonStartData = new SubstationEquipmentTerminalDataCommonStart();
            ArrayList<String> equipmentTerminalOneBusRecords = new ArrayList<String>();
            ArrayList<String> equipmentTerminalTwoBusesRecords = new ArrayList<String>();
            ArrayList<String> equipmentTerminalThreeBusesRecords = new ArrayList<String>();
            String line = reader.readUntilFindingARecordLineNotEmpty();
            while (!reader.endOfBlock(line)) {
                PsseSubstation.PsseSubstationEquipmentTerminalCommonStart commonStart = (PsseSubstation.PsseSubstationEquipmentTerminalCommonStart)commonStartData.readFromStrings(Collections.singletonList(line), context).get(0);
                if (PsseSubstation.isOneBus(commonStart.getType())) {
                    equipmentTerminalOneBusRecords.add(line);
                } else if (PsseSubstation.isTwoBuses(commonStart.getType())) {
                    equipmentTerminalTwoBusesRecords.add(line);
                } else if (PsseSubstation.isThreeBuses(commonStart.getType())) {
                    equipmentTerminalThreeBusesRecords.add(line);
                } else {
                    throw new PsseException("Unexpected equipment terminal type: " + commonStart.getType());
                }
                line = reader.readUntilFindingARecordLineNotEmpty();
            }
            List<PsseSubstation.PsseSubstationEquipmentTerminal> equipmentTerminalList = new SubstationEquipmentTerminalDataOneBus().readFromStrings(equipmentTerminalOneBusRecords, context);
            equipmentTerminalList.addAll(new SubstationEquipmentTerminalDataTwoBuses().readFromStrings(equipmentTerminalTwoBusesRecords, context));
            equipmentTerminalList.addAll(new SubstationEquipmentTerminalDataThreeBuses().readFromStrings(equipmentTerminalThreeBusesRecords, context));
            return equipmentTerminalList;
        }

        @Override
        public void write(List<PsseSubstation> substationList, Context context, OutputStream outputStream) {
            this.writeBegin(outputStream);
            substationList.forEach(substation -> {
                SubstationRecordData recordData = new SubstationRecordData();
                IOLegacyText.write(recordData.buildRecords(Collections.singletonList(substation.getRecord()), context.getFieldNames(PowerFlowRecordGroup.SUBSTATION), recordData.quotedFields(), context), outputStream);
                SubstationNodeData nodeData = new SubstationNodeData();
                IOLegacyText.write(nodeData.buildRecords(substation.getNodes(), context.getFieldNames(PowerFlowRecordGroup.INTERNAL_SUBSTATION_NODE), nodeData.quotedFields(), context), outputStream);
                IOLegacyText.writeEndComment(" END OF SUBSTATION NODE DATA, BEGIN SUBSTATION SWITCHING DEVICE DATA", outputStream);
                SubstationSwitchingDeviceData switchingDeviceData = new SubstationSwitchingDeviceData();
                IOLegacyText.write(switchingDeviceData.buildRecords(substation.getSwitchingDevices(), context.getFieldNames(PowerFlowRecordGroup.INTERNAL_SUBSTATION_SWITCHING_DEVICE), switchingDeviceData.quotedFields(), context), outputStream);
                IOLegacyText.writeEndComment(" END OF SUBSTATION SWITCHING DEVICE DATA, BEGIN SUBSTATION EQUIPMENT TERMINAL DATA", outputStream);
                IOLegacyText.write(this.writeEquipmentTerminalData(substation.getEquipmentTerminals(), context), outputStream);
                IOLegacyText.writeEndComment(" END OF SUBSTATION EQUIPMENT TERMINAL DATA", outputStream);
            });
            this.writeEnd(outputStream);
        }

        private List<String> writeEquipmentTerminalData(List<PsseSubstation.PsseSubstationEquipmentTerminal> equipmentTerminalList, Context context) {
            List<PsseSubstation.PsseSubstationEquipmentTerminal> eqOneBus = equipmentTerminalList.stream().filter(eq -> PsseSubstation.isOneBus(eq.getType())).toList();
            List<PsseSubstation.PsseSubstationEquipmentTerminal> eqTwoBuses = equipmentTerminalList.stream().filter(eq -> PsseSubstation.isTwoBuses(eq.getType())).toList();
            List<PsseSubstation.PsseSubstationEquipmentTerminal> eqThreeBuses = equipmentTerminalList.stream().filter(eq -> PsseSubstation.isThreeBuses(eq.getType())).toList();
            SubstationEquipmentTerminalDataOneBus oneBusData = new SubstationEquipmentTerminalDataOneBus();
            List<String> strings = oneBusData.buildRecords(eqOneBus, context.getFieldNames(PowerFlowRecordGroup.INTERNAL_SUBSTATION_EQUIPMENT_TERMINAL_ONE_BUS), oneBusData.quotedFields(), context);
            SubstationEquipmentTerminalDataTwoBuses twoBusesData = new SubstationEquipmentTerminalDataTwoBuses();
            strings.addAll(twoBusesData.buildRecords(eqTwoBuses, context.getFieldNames(PowerFlowRecordGroup.INTERNAL_SUBSTATION_EQUIPMENT_TERMINAL_TWO_BUSES), twoBusesData.quotedFields(), context));
            SubstationEquipmentTerminalDataThreeBuses threeBusesData = new SubstationEquipmentTerminalDataThreeBuses();
            strings.addAll(threeBusesData.buildRecords(eqThreeBuses, context.getFieldNames(PowerFlowRecordGroup.INTERNAL_SUBSTATION_EQUIPMENT_TERMINAL_THREE_BUSES), threeBusesData.quotedFields(), context));
            return strings;
        }

        private static class SubstationNodeData
        extends AbstractRecordGroup<PsseSubstation.PsseSubstationNode> {
            SubstationNodeData() {
                super(PowerFlowRecordGroup.INTERNAL_SUBSTATION_NODE, "ni", "name", "i", "status", "vm", "va");
                this.withQuotedFields(QUOTED_FIELDS);
            }

            @Override
            public Class<PsseSubstation.PsseSubstationNode> psseTypeClass() {
                return PsseSubstation.PsseSubstationNode.class;
            }
        }

        private static class SubstationSwitchingDeviceData
        extends AbstractRecordGroup<PsseSubstation.PsseSubstationSwitchingDevice> {
            SubstationSwitchingDeviceData() {
                super(PowerFlowRecordGroup.INTERNAL_SUBSTATION_SWITCHING_DEVICE, "ni", "nj", "ckt", "name", "type", "status", "nstat", "x", "rate1", "rate2", "rate3");
                this.withQuotedFields(QUOTED_FIELDS_SWITCHING_DEVICES);
            }

            @Override
            public Class<PsseSubstation.PsseSubstationSwitchingDevice> psseTypeClass() {
                return PsseSubstation.PsseSubstationSwitchingDevice.class;
            }
        }

        private static class SubstationEquipmentTerminalDataCommonStart
        extends AbstractRecordGroup<PsseSubstation.PsseSubstationEquipmentTerminalCommonStart> {
            SubstationEquipmentTerminalDataCommonStart() {
                super(PowerFlowRecordGroup.INTERNAL_SUBSTATION_EQUIPMENT_TERMINAL_COMMON_START, "i", "ni", "type");
                this.withQuotedFields(QUOTED_FIELDS);
            }

            @Override
            public Class<PsseSubstation.PsseSubstationEquipmentTerminalCommonStart> psseTypeClass() {
                return PsseSubstation.PsseSubstationEquipmentTerminalCommonStart.class;
            }
        }

        private static class SubstationEquipmentTerminalDataOneBus
        extends AbstractRecordGroup<PsseSubstation.PsseSubstationEquipmentTerminal> {
            SubstationEquipmentTerminalDataOneBus() {
                super(PowerFlowRecordGroup.INTERNAL_SUBSTATION_EQUIPMENT_TERMINAL_ONE_BUS, "i", "ni", "type", "id");
                this.withQuotedFields(QUOTED_FIELDS);
            }

            @Override
            public Class<PsseSubstation.PsseSubstationEquipmentTerminal> psseTypeClass() {
                return PsseSubstation.PsseSubstationEquipmentTerminal.class;
            }
        }

        private static class SubstationEquipmentTerminalDataTwoBuses
        extends AbstractRecordGroup<PsseSubstation.PsseSubstationEquipmentTerminal> {
            SubstationEquipmentTerminalDataTwoBuses() {
                super(PowerFlowRecordGroup.INTERNAL_SUBSTATION_EQUIPMENT_TERMINAL_TWO_BUSES, "i", "ni", "type", "j", "id");
                this.withQuotedFields(QUOTED_FIELDS);
            }

            @Override
            public Class<PsseSubstation.PsseSubstationEquipmentTerminal> psseTypeClass() {
                return PsseSubstation.PsseSubstationEquipmentTerminal.class;
            }
        }

        private static class SubstationEquipmentTerminalDataThreeBuses
        extends AbstractRecordGroup<PsseSubstation.PsseSubstationEquipmentTerminal> {
            SubstationEquipmentTerminalDataThreeBuses() {
                super(PowerFlowRecordGroup.INTERNAL_SUBSTATION_EQUIPMENT_TERMINAL_THREE_BUSES, "i", "ni", "type", "j", "k", "id");
                this.withQuotedFields(QUOTED_FIELDS);
            }

            @Override
            public Class<PsseSubstation.PsseSubstationEquipmentTerminal> psseTypeClass() {
                return PsseSubstation.PsseSubstationEquipmentTerminal.class;
            }
        }
    }

    private static class IOJson
    extends RecordGroupIOJson<PsseSubstation> {
        IOJson(AbstractRecordGroup<PsseSubstation> recordGroup) {
            super(recordGroup);
        }

        @Override
        public List<PsseSubstation> read(LegacyTextReader reader, Context context) throws IOException {
            if (reader != null) {
                throw new PsseException("Unexpected reader. Should be null");
            }
            List<PsseSubstation.PsseSubstationRecord> recordList = new SubstationRecordData().read(null, context);
            List<PsseSubstation.PsseSubstationNodex> nodexList = new SubstationNodexData().read(null, context);
            List<PsseSubstation.PsseSubstationSwitchingDevicex> switchingDevicexList = new SubstationSwitchingDevicexData().read(null, context);
            List<PsseSubstation.PsseSubstationEquipmentTerminalx> equipmentTerminalxList = new SubstationEquipmentTerminalxData().read(null, context);
            return IOJson.convertToSubstationList(recordList, nodexList, switchingDevicexList, equipmentTerminalxList);
        }

        @Override
        public void write(List<PsseSubstation> substationList, Context context, OutputStream outputStream) {
            if (outputStream != null) {
                throw new PsseException("Unexpected outputStream. Should be null");
            }
            List<PsseSubstation.PsseSubstationRecord> recordList = substationList.stream().map(PsseSubstation::getRecord).toList();
            new SubstationRecordData().write(recordList, context, null);
            ArrayList nodexList = new ArrayList();
            substationList.forEach(substation -> substation.getNodes().forEach(node -> nodexList.add(new PsseSubstation.PsseSubstationNodex(substation.getRecord().getIs(), (PsseSubstation.PsseSubstationNode)node))));
            new SubstationNodexData().write(nodexList, context, null);
            ArrayList switchingDevicexList = new ArrayList();
            substationList.forEach(substation -> substation.getSwitchingDevices().forEach(switchingDevice -> switchingDevicexList.add(new PsseSubstation.PsseSubstationSwitchingDevicex(substation.getRecord().getIs(), (PsseSubstation.PsseSubstationSwitchingDevice)switchingDevice))));
            new SubstationSwitchingDevicexData().write(switchingDevicexList, context, null);
            ArrayList equipmentTerminalxList = new ArrayList();
            substationList.forEach(substation -> substation.getEquipmentTerminals().forEach(equipmentTerminal -> equipmentTerminalxList.add(new PsseSubstation.PsseSubstationEquipmentTerminalx(substation.getRecord().getIs(), (PsseSubstation.PsseSubstationEquipmentTerminal)equipmentTerminal))));
            new SubstationEquipmentTerminalxData().write(equipmentTerminalxList, context, null);
        }

        private static List<PsseSubstation> convertToSubstationList(List<PsseSubstation.PsseSubstationRecord> recordList, List<PsseSubstation.PsseSubstationNodex> nodexList, List<PsseSubstation.PsseSubstationSwitchingDevicex> switchingDevicexList, List<PsseSubstation.PsseSubstationEquipmentTerminalx> equipmentTerminalxList) {
            ArrayList<PsseSubstation> substationList = new ArrayList<PsseSubstation>();
            for (PsseSubstation.PsseSubstationRecord substationRecord : recordList) {
                List<PsseSubstation.PsseSubstationNode> nodeList = nodexList.stream().filter(n -> n.getIsub() == substationRecord.getIs()).map(PsseSubstation.PsseSubstationNodex::getNode).toList();
                List<PsseSubstation.PsseSubstationSwitchingDevice> switchingDeviceList = switchingDevicexList.stream().filter(sd -> sd.getIsub() == substationRecord.getIs()).map(PsseSubstation.PsseSubstationSwitchingDevicex::getSwitchingDevice).toList();
                List<PsseSubstation.PsseSubstationEquipmentTerminal> equipmentTerminalList = equipmentTerminalxList.stream().filter(eq -> eq.getIsub() == substationRecord.getIs()).map(PsseSubstation.PsseSubstationEquipmentTerminalx::getEquipmentTerminal).toList();
                substationList.add(new PsseSubstation(substationRecord, nodeList, switchingDeviceList, equipmentTerminalList));
            }
            return substationList;
        }

        private static class SubstationNodexData
        extends AbstractRecordGroup<PsseSubstation.PsseSubstationNodex> {
            SubstationNodexData() {
                super(PowerFlowRecordGroup.INTERNAL_SUBSTATION_NODE, new String[0]);
                this.withQuotedFields(QUOTED_FIELDS);
            }

            @Override
            public Class<PsseSubstation.PsseSubstationNodex> psseTypeClass() {
                return PsseSubstation.PsseSubstationNodex.class;
            }
        }

        private static class SubstationSwitchingDevicexData
        extends AbstractRecordGroup<PsseSubstation.PsseSubstationSwitchingDevicex> {
            SubstationSwitchingDevicexData() {
                super(PowerFlowRecordGroup.INTERNAL_SUBSTATION_SWITCHING_DEVICE, new String[0]);
                this.withQuotedFields(QUOTED_FIELDS_SWITCHING_DEVICES);
            }

            @Override
            public Class<PsseSubstation.PsseSubstationSwitchingDevicex> psseTypeClass() {
                return PsseSubstation.PsseSubstationSwitchingDevicex.class;
            }
        }

        private static class SubstationEquipmentTerminalxData
        extends AbstractRecordGroup<PsseSubstation.PsseSubstationEquipmentTerminalx> {
            SubstationEquipmentTerminalxData() {
                super(PowerFlowRecordGroup.INTERNAL_SUBSTATION_EQUIPMENT_TERMINAL, new String[0]);
                this.withQuotedFields(QUOTED_FIELDS);
            }

            @Override
            public Class<PsseSubstation.PsseSubstationEquipmentTerminalx> psseTypeClass() {
                return PsseSubstation.PsseSubstationEquipmentTerminalx.class;
            }
        }
    }

    private static class SubstationRecordData
    extends AbstractRecordGroup<PsseSubstation.PsseSubstationRecord> {
        SubstationRecordData() {
            super(PowerFlowRecordGroup.SUBSTATION, "is", "name", "lati", "long", "srg");
            this.withQuotedFields(QUOTED_FIELDS);
        }

        @Override
        public Class<PsseSubstation.PsseSubstationRecord> psseTypeClass() {
            return PsseSubstation.PsseSubstationRecord.class;
        }
    }
}

