/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.io;

import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.io.AbstractRecordGroup;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.io.LegacyTextReader;
import com.powsybl.psse.model.io.RecordGroupIO;
import com.powsybl.psse.model.io.RecordGroupIdentification;
import com.powsybl.psse.model.io.Util;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;

public class RecordGroupIOLegacyText<T>
implements RecordGroupIO<T> {
    protected final AbstractRecordGroup<T> recordGroup;

    protected RecordGroupIOLegacyText(AbstractRecordGroup<T> recordGroup) {
        Objects.requireNonNull(recordGroup);
        this.recordGroup = recordGroup;
    }

    @Override
    public List<T> read(LegacyTextReader reader, Context context) throws IOException {
        List<String> records = reader.readRecords();
        return this.recordGroup.readFromStrings(records, context);
    }

    @Override
    public void write(List<T> psseObjects, Context context, OutputStream outputStream) {
        String[] headers = context.getFieldNames(this.recordGroup.identification);
        String[] actualQuotedFields = Util.retainAll(this.recordGroup.quotedFields(), headers);
        this.writeBegin(outputStream);
        this.write(psseObjects, headers, actualQuotedFields, context, outputStream);
        this.writeEnd(outputStream);
    }

    @Override
    public T readHead(LegacyTextReader reader, Context context) throws IOException {
        throw new PsseException("Generic record group can not be read as head record");
    }

    @Override
    public void writeHead(T psseObject, Context context, OutputStream outputStream) {
        throw new PsseException("Generic record group can not be written as head record");
    }

    protected void write(List<T> objects, String[] headers, String[] quotedFields, Context context, OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        CsvWriterSettings settings = this.recordGroup.settingsForCsvWriter(headers, quotedFields, context);
        CsvWriter writer = new CsvWriter((Writer)outputStreamWriter, settings);
        writer.processRecords(objects);
        writer.flush();
    }

    public static void writeEmpty(RecordGroupIdentification recordGroup, OutputStream outputStream) {
        RecordGroupIOLegacyText.write(", ", outputStream);
        RecordGroupIOLegacyText.writeBegin(recordGroup.getLegacyTextName(), outputStream);
        RecordGroupIOLegacyText.writeEnd(recordGroup.getLegacyTextName(), outputStream);
    }

    protected void writeBegin(OutputStream outputStream) {
        RecordGroupIOLegacyText.write(", ", outputStream);
        RecordGroupIOLegacyText.writeBegin(this.recordGroup.getIdentification().getLegacyTextName(), outputStream);
    }

    protected void writeEnd(OutputStream outputStream) {
        RecordGroupIOLegacyText.writeEnd(this.recordGroup.getIdentification().getLegacyTextName(), outputStream);
    }

    public static void writeBegin(String legacyTextName, OutputStream outputStream) {
        RecordGroupIOLegacyText.write(String.format("BEGIN %s DATA%n", legacyTextName), outputStream);
    }

    public static void writeEnd(String legacyTextName, OutputStream outputStream) {
        RecordGroupIOLegacyText.write(String.format("0 / END OF %s DATA", legacyTextName), outputStream);
    }

    public static void writeComment(String comment, OutputStream outputStream) {
        RecordGroupIOLegacyText.write(String.format("  / %s%n", comment), outputStream);
    }

    public static void writeEndComment(String comment, OutputStream outputStream) {
        RecordGroupIOLegacyText.write(String.format("0 / %s%n", comment), outputStream);
    }

    public static void writeQ(OutputStream outputStream) {
        RecordGroupIOLegacyText.write(String.format("%nQ%n", new Object[0]), outputStream);
    }

    public static void write(List<String> ss, OutputStream outputStream) {
        ss.forEach(s -> RecordGroupIOLegacyText.write(String.format("%s%n", s), outputStream));
    }

    public static void write(String s, OutputStream outputStream) {
        try {
            outputStream.write(s.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

