/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.io;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.io.FileFormat;
import com.powsybl.psse.model.io.RecordGroupIdentification;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyTextReader {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyTextReader.class);
    private final BufferedReader reader;
    private boolean qRecordFound;

    public LegacyTextReader(BufferedReader reader) {
        this.reader = reader;
    }

    public BufferedReader getBufferedReader() {
        return this.reader;
    }

    public boolean isQRecordFound() {
        return this.qRecordFound;
    }

    public void skip(RecordGroupIdentification recordGroup) throws IOException {
        String line;
        LOG.debug("read and ignore record group {}", (Object)recordGroup);
        int number = -1;
        do {
            if ((line = this.reader.readLine()) == null) continue;
            try (Scanner scanner = new Scanner(line);){
                if (!scanner.hasNextInt()) continue;
                number = scanner.nextInt();
            }
        } while (line != null && number != 0);
    }

    public List<String> readRecords() throws IOException {
        ArrayList<String> records = new ArrayList<String>();
        if (!this.isQRecordFound()) {
            String line = this.readRecordLine();
            while (!this.endOfBlock(line)) {
                if (!this.emptyLine(line)) {
                    records.add(line);
                }
                line = this.readRecordLine();
            }
        }
        return records;
    }

    public boolean endOfBlock(String line) {
        if (line.trim().equals("Q")) {
            this.qRecordFound = true;
            return true;
        }
        return line.trim().equals("0");
    }

    private boolean emptyLine(String line) {
        return line.trim().isEmpty();
    }

    public String readLine() throws IOException {
        return this.reader.readLine();
    }

    public String readUntilFindingARecordLineNotEmpty() throws IOException {
        String line = this.readRecordLine();
        while (this.emptyLine(line) || LegacyTextReader.isRecordLineDefiningTheAttributeFields(line)) {
            line = this.readRecordLine();
        }
        return line;
    }

    public String readRecordLine() throws IOException {
        String line = this.reader.readLine();
        if (line == null) {
            if (this.qRecordFound) {
                throw new PsseException("PSSE. Unexpected end of file");
            }
            return "Q";
        }
        if (LegacyTextReader.isRecordLineDefiningTheAttributeFields(line)) {
            return "";
        }
        StringBuilder newLine = new StringBuilder();
        Matcher m = FileFormat.LEGACY_TEXT_QUOTED_OR_WHITESPACE.matcher((CharSequence)LegacyTextReader.processText(LegacyTextReader.removeComment(line)));
        while (m.find()) {
            if (m.group().indexOf(FileFormat.LEGACY_TEXT.getQuote()) >= 0) {
                m.appendReplacement(newLine, LegacyTextReader.replaceSpecialCharacters(m.group()));
                continue;
            }
            m.appendReplacement(newLine, " ");
        }
        m.appendTail(newLine);
        return newLine.toString().trim();
    }

    private static String removeComment(String line) {
        return line.replaceAll("('[^']*')|([^/']+)|(/.*)", "$1$2");
    }

    protected static String processText(String line) {
        if (line == null || line.isEmpty()) {
            return line;
        }
        StringBuilder result = new StringBuilder();
        Pattern pattern = FileFormat.LEGACY_QUOTED_OR_NON_QUOTED_TEXT;
        Matcher matcher = pattern.matcher((CharSequence)line.trim());
        while (matcher.find()) {
            String part = matcher.group();
            if (part.startsWith("'") && part.endsWith("'")) {
                result.append(part);
                continue;
            }
            result.append(part.replaceAll("(?<=\\S|^)\\s+,", ",").replaceAll(",\\s+", ",").replaceAll("\\s+", ","));
        }
        return result.toString();
    }

    private static boolean isRecordLineDefiningTheAttributeFields(String line) {
        return line.startsWith("@!");
    }

    private static String replaceSpecialCharacters(String line) {
        return line.replace("\\", "\\\\").replace("$", "\\$");
    }
}

