/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.pf;

import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.pf.PsseFacts;
import com.powsybl.psse.model.pf.PsseFixedShunt;
import com.powsybl.psse.model.pf.PsseGenerator;
import com.powsybl.psse.model.pf.PsseLoad;
import com.powsybl.psse.model.pf.PsseNonTransformerBranch;
import com.powsybl.psse.model.pf.PssePowerFlowModel;
import com.powsybl.psse.model.pf.PsseSwitchedShunt;
import com.powsybl.psse.model.pf.PsseTransformer;
import com.powsybl.psse.model.pf.PsseTransformerWinding;
import com.powsybl.psse.model.pf.PsseTwoTerminalDcTransmissionLine;
import com.powsybl.psse.model.pf.PsseValidation;
import com.powsybl.psse.model.pf.PsseVoltageSourceConverter;
import com.powsybl.psse.model.pf.PsseVoltageSourceConverterDcTransmissionLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PsseFixes {
    private static final String WINDING_1 = "Winding1";
    private static final Logger LOGGER = LoggerFactory.getLogger(PsseFixes.class);
    private final PssePowerFlowModel model;
    private final PsseVersion version;
    private static final double NON_TRANSFORMER_BRANCH_X = 1.0E-4;

    public PsseFixes(PssePowerFlowModel model, PsseVersion version) {
        this.model = Objects.requireNonNull(model);
        this.version = Objects.requireNonNull(version);
    }

    public void fix() {
        this.fixDuplicatedIds();
        this.fixControlledBuses();
        this.fixTransformersWindingCod();
        this.fixNonTransformersBranchX();
    }

    private void fixDuplicatedIds() {
        this.fixDuplicatedIds(this.model.getLoads(), l -> l.getI() + "-" + l.getId(), this::loadFixer);
        this.fixDuplicatedIds(this.model.getGenerators(), g -> g.getI() + "-" + g.getId(), this::generatorFixer);
        this.fixDuplicatedIds(this.model.getFixedShunts(), sh -> sh.getI() + "-" + sh.getId(), this::fixedShuntFixer);
        this.fixDuplicatedIds(this.model.getNonTransformerBranches(), b -> this.sortedBuses(b.getI(), b.getJ()) + b.getCkt(), this::nonTransformerBranchFixer);
        this.fixDuplicatedIds(this.model.getTransformers(), b -> this.sortedBuses(b.getI(), b.getJ(), b.getK()) + b.getCkt(), this::transformerFixer);
        if (this.version.getMajorNumber() >= 35) {
            this.fixDuplicatedIds(this.model.getSwitchedShunts(), sh -> sh.getI() + "-" + sh.getId(), this::switchedShuntFixer);
        }
        this.fixDuplicatedIds(this.model.getTwoTerminalDcTransmissionLines(), PsseTwoTerminalDcTransmissionLine::getName, this::twoTerminalDcTransmissionLineFixer);
        this.fixDuplicatedIds(this.model.getVoltageSourceConverterDcTransmissionLines(), PsseVoltageSourceConverterDcTransmissionLine::getName, this::vscDcTransmissionLineFixer);
        this.fixDuplicatedIds(this.model.getFacts(), PsseFacts::getName, this::factsDeviceFixer);
    }

    private void fixTransformersWindingCod() {
        this.model.getTransformers().forEach(psseTransformer -> {
            if (psseTransformer.getK() == 0) {
                this.fixTransformerWindingCod((PsseTransformer)psseTransformer, psseTransformer.getWinding1(), WINDING_1);
            } else {
                this.fixTransformerWindingCod((PsseTransformer)psseTransformer, psseTransformer.getWinding1(), WINDING_1);
                this.fixTransformerWindingCod((PsseTransformer)psseTransformer, psseTransformer.getWinding2(), "Winding2");
                this.fixTransformerWindingCod((PsseTransformer)psseTransformer, psseTransformer.getWinding3(), "Winding3");
            }
        });
    }

    private void fixControlledBuses() {
        HashSet<Integer> buses = new HashSet<Integer>();
        this.model.getBuses().forEach(psseBus -> buses.add(psseBus.getI()));
        this.fixGeneratorsControlledBus(buses);
        this.fixTransformersControlledBus(buses);
        this.fixVscDcTransmissionLineControlledBus(buses);
        this.fixFactsDeviceControlledBus(buses);
        this.fixSwitchedShuntControlledBus(buses);
    }

    private String sortedBuses(int ... buses) {
        Arrays.sort(buses);
        return Arrays.toString(buses);
    }

    private <T> void fixDuplicatedIds(List<T> psseObjects, Function<T, String> idBuilder, IdFixer<T> idFixer) {
        HashSet foundIds = new HashSet();
        HashMap<String, List> duplicated = new HashMap<String, List>();
        psseObjects.forEach(psseObject -> {
            String id = (String)idBuilder.apply(psseObject);
            if (foundIds.contains(id)) {
                duplicated.computeIfAbsent(id, key -> new ArrayList()).add(psseObject);
            }
            foundIds.add(id);
        });
        duplicated.forEach((id, duplicatedIdObjects) -> {
            HashSet<String> usedIds = new HashSet<String>();
            usedIds.add((String)id);
            duplicatedIdObjects.forEach(psseObject -> {
                String fixedId = idFixer.fix(psseObject, usedIds);
                usedIds.add(fixedId);
            });
        });
    }

    private String buildFixedId2(String id, Set<String> usedIds) {
        String first = id.isEmpty() ? "1" : id.substring(0, 1);
        return this.buildCandidate(id, first, usedIds);
    }

    private String buildFixedName(String name, Set<String> usedNames) {
        String first = name.length() == 12 ? name.substring(0, 11) : name;
        return this.buildCandidate(name, first, usedNames);
    }

    private String buildCandidate(String id, String first, Set<String> usedIds) {
        String candidate;
        char second;
        for (second = '0'; second <= '9'; second = (char)(second + '\u0001')) {
            candidate = first + second;
            if (usedIds.contains(candidate)) continue;
            return candidate;
        }
        for (second = 'A'; second <= 'Z'; second = (char)(second + '\u0001')) {
            candidate = first + second;
            if (usedIds.contains(candidate)) continue;
            return candidate;
        }
        return id;
    }

    private String loadFixer(PsseLoad load, Set<String> usedIds) {
        String id = load.getId();
        String fixedId = this.buildFixedId2(id, usedIds);
        load.setId(fixedId);
        this.warn("Load", load.getI(), id, fixedId);
        return fixedId;
    }

    private String generatorFixer(PsseGenerator generator, Set<String> usedIds) {
        String id = generator.getId();
        String fixedId = this.buildFixedId2(id, usedIds);
        generator.setId(fixedId);
        this.warn("Generator", generator.getI(), id, fixedId);
        return fixedId;
    }

    private String fixedShuntFixer(PsseFixedShunt fixedShunt, Set<String> usedIds) {
        String id = fixedShunt.getId();
        String fixedId = this.buildFixedId2(id, usedIds);
        fixedShunt.setId(fixedId);
        this.warn("FixedShunt", fixedShunt.getI(), id, fixedId);
        return fixedId;
    }

    private String switchedShuntFixer(PsseSwitchedShunt switchedShunt, Set<String> usedIds) {
        String id = switchedShunt.getId();
        String fixedId = this.buildFixedId2(id, usedIds);
        switchedShunt.setId(fixedId);
        this.warn("SwitchedShunt", switchedShunt.getI(), id, fixedId);
        return fixedId;
    }

    private String nonTransformerBranchFixer(PsseNonTransformerBranch branch, Set<String> usedIds) {
        String id = branch.getCkt();
        String fixedId = this.buildFixedId2(id, usedIds);
        branch.setCkt(fixedId);
        this.warn(branch, id, fixedId);
        return fixedId;
    }

    private String transformerFixer(PsseTransformer transformer, Set<String> usedIds) {
        String id = transformer.getCkt();
        String fixedId = this.buildFixedId2(id, usedIds);
        transformer.setCkt(fixedId);
        this.warn(transformer, id, fixedId);
        return fixedId;
    }

    private void fixTransformerWindingCod(PsseTransformer transformer, PsseTransformerWinding winding, String windingTag) {
        if (Math.abs(winding.getCod()) == 1 && winding.getCont() == 0) {
            this.warn(transformer, windingTag, winding.getCod(), 0);
            winding.setCod(0);
        }
    }

    private String twoTerminalDcTransmissionLineFixer(PsseTwoTerminalDcTransmissionLine twoTerminalDcTransmissionLine, Set<String> usedIds) {
        String name = twoTerminalDcTransmissionLine.getName();
        String fixedName = this.buildFixedName(name, usedIds);
        twoTerminalDcTransmissionLine.setName(fixedName);
        this.warn("TwoTerminalDcTransmissionLine", name, fixedName);
        return fixedName;
    }

    private String vscDcTransmissionLineFixer(PsseVoltageSourceConverterDcTransmissionLine vscDcTransmissionLine, Set<String> usedIds) {
        String name = vscDcTransmissionLine.getName();
        String fixedName = this.buildFixedName(name, usedIds);
        vscDcTransmissionLine.setName(fixedName);
        this.warn("VoltageSourceConverterDcTransmissionLine", name, fixedName);
        return fixedName;
    }

    private String factsDeviceFixer(PsseFacts factsDevice, Set<String> usedIds) {
        String name = factsDevice.getName();
        String fixedName = this.buildFixedName(name, usedIds);
        factsDevice.setName(fixedName);
        this.warn("FactsDevice", name, fixedName);
        return fixedName;
    }

    private void fixGeneratorsControlledBus(Set<Integer> buses) {
        this.model.getGenerators().forEach(psseGenerator -> {
            if (psseGenerator.getIreg() != 0 && !buses.contains(psseGenerator.getIreg())) {
                this.warn("Generator", String.format("%d, %s, ...", psseGenerator.getI(), psseGenerator.getId()), psseGenerator.getIreg());
                psseGenerator.setIreg(0);
            }
        });
    }

    private void fixTransformersControlledBus(Set<Integer> buses) {
        this.model.getTransformers().forEach(psseTransformer -> {
            if (psseTransformer.getK() == 0) {
                this.fixTransformerWindingControlledBus(buses, (PsseTransformer)psseTransformer, psseTransformer.getWinding1(), WINDING_1);
            } else {
                this.fixTransformerWindingControlledBus(buses, (PsseTransformer)psseTransformer, psseTransformer.getWinding1(), WINDING_1);
                this.fixTransformerWindingControlledBus(buses, (PsseTransformer)psseTransformer, psseTransformer.getWinding2(), "Winding2");
                this.fixTransformerWindingControlledBus(buses, (PsseTransformer)psseTransformer, psseTransformer.getWinding3(), "Winding3");
            }
        });
    }

    private void fixTransformerWindingControlledBus(Set<Integer> buses, PsseTransformer psseTransformer, PsseTransformerWinding winding, String windingTag) {
        if (winding.getCont() != 0 && !buses.contains(winding.getCont())) {
            this.warn("Transformer", String.format("%d, %d, %d, %s, ... %s ", psseTransformer.getI(), psseTransformer.getJ(), psseTransformer.getK(), psseTransformer.getCkt(), windingTag), winding.getCont());
            winding.setCont(0);
        }
    }

    private void fixVscDcTransmissionLineControlledBus(Set<Integer> buses) {
        this.model.getVoltageSourceConverterDcTransmissionLines().forEach(psseVscDcTransmissionLine -> {
            this.fixVscDcTransmissionLineConverterControlledBus(buses, (PsseVoltageSourceConverterDcTransmissionLine)psseVscDcTransmissionLine, psseVscDcTransmissionLine.getConverter1(), "Converter1");
            this.fixVscDcTransmissionLineConverterControlledBus(buses, (PsseVoltageSourceConverterDcTransmissionLine)psseVscDcTransmissionLine, psseVscDcTransmissionLine.getConverter2(), "Converter2");
        });
    }

    private void fixVscDcTransmissionLineConverterControlledBus(Set<Integer> buses, PsseVoltageSourceConverterDcTransmissionLine psseVscDcTransmissionLine, PsseVoltageSourceConverter psseVscDcConverter, String converterTag) {
        if (PsseValidation.vscDcTransmissionLineRegulatingBus(psseVscDcConverter, this.version) != 0 && !buses.contains(PsseValidation.vscDcTransmissionLineRegulatingBus(psseVscDcConverter, this.version))) {
            this.warn("VoltageSourceConverterDcTransmissionLine", String.format("%s, ... %s", psseVscDcTransmissionLine.getName(), converterTag), PsseValidation.vscDcTransmissionLineRegulatingBus(psseVscDcConverter, this.version));
            psseVscDcConverter.setVsreg(0);
            psseVscDcConverter.setRemot(0);
        }
    }

    private void fixFactsDeviceControlledBus(Set<Integer> buses) {
        this.model.getFacts().forEach(psseFactsDevice -> {
            if (PsseValidation.factsDeviceRegulatingBus(psseFactsDevice, this.version) != 0 && !buses.contains(PsseValidation.factsDeviceRegulatingBus(psseFactsDevice, this.version))) {
                this.warn("FactsDevice", String.format("%s, ...", psseFactsDevice.getName()), PsseValidation.factsDeviceRegulatingBus(psseFactsDevice, this.version));
                psseFactsDevice.setFcreg(0);
                psseFactsDevice.setRemot(0);
            }
        });
    }

    private void fixSwitchedShuntControlledBus(Set<Integer> buses) {
        this.model.getSwitchedShunts().forEach(psseSwitchedShunt -> {
            if (PsseValidation.switchedShuntRegulatingBus(psseSwitchedShunt, this.version) != 0 && !buses.contains(PsseValidation.switchedShuntRegulatingBus(psseSwitchedShunt, this.version))) {
                this.warn("SwitchedShunt", String.format("%s, ...", PsseValidation.switchedShuntId(psseSwitchedShunt, this.version)), PsseValidation.switchedShuntRegulatingBus(psseSwitchedShunt, this.version));
                psseSwitchedShunt.setSwreg(0);
                psseSwitchedShunt.setSwrem(0);
            }
        });
    }

    private void warn(String type, int i, String id, String fixedId) {
        if (LOGGER.isWarnEnabled()) {
            if (id.equals(fixedId)) {
                LOGGER.warn("Unable to fix {} Id: I {} ID '{}'", new Object[]{type, i, id});
            } else {
                LOGGER.warn("{} Id fixed: I {} ID '{}'. Fixed ID '{}'", new Object[]{type, i, id, fixedId});
            }
        }
    }

    private void warn(String type, String name, String fixedName) {
        if (LOGGER.isWarnEnabled()) {
            if (name.equals(fixedName)) {
                LOGGER.warn("Unable to fix {} Name: {}", (Object)type, (Object)name);
            } else {
                LOGGER.warn("{} name fixed: Name '{}'. Fixed Name '{}'", new Object[]{type, name, fixedName});
            }
        }
    }

    private void warn(PsseNonTransformerBranch branch, String id, String fixedId) {
        if (LOGGER.isWarnEnabled()) {
            if (id.equals(fixedId)) {
                LOGGER.warn("Unable to fix NonTransformerBranch Id: I {} J {} CKT '{}'", new Object[]{branch.getI(), branch.getJ(), id});
            } else {
                LOGGER.warn("NonTransformerBranch Id fixed: I {} J {} CKT '{}'. Fixed CKT '{}'", new Object[]{branch.getI(), branch.getJ(), id, fixedId});
            }
        }
    }

    private void warn(PsseTransformer transformer, String id, String fixedId) {
        if (LOGGER.isWarnEnabled()) {
            if (id.equals(fixedId)) {
                LOGGER.warn("Unable to fix Transformer Id: I {} J {} K {} CKT '{}'", new Object[]{transformer.getI(), transformer.getJ(), transformer.getK(), id});
            } else {
                LOGGER.warn("Transformer Id fixed: I {} J {} K {} CKT '{}'. Fixed CKT '{}'", new Object[]{transformer.getI(), transformer.getJ(), transformer.getK(), id, fixedId});
            }
        }
    }

    private void warn(PsseTransformer transformer, String windingTag, int cod, int fixedCod) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Transformer {} Cod fixed: I {} J {} K {} CKT {}. Cod '{}' Fixed Cod '{}'. Controlled bus is not defined (cont == 0).", new Object[]{windingTag, transformer.getI(), transformer.getJ(), transformer.getK(), transformer.getCkt(), cod, fixedCod});
        }
    }

    private void warn(String type, String recordId, int controlledBus) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("{} {} controlled bus {} not found; fixed to 0", new Object[]{type, recordId, controlledBus});
        }
    }

    private void fixNonTransformersBranchX() {
        this.model.getNonTransformerBranches().forEach(branch -> {
            if (branch.getX() == 0.0) {
                branch.setX(1.0E-4);
                LOGGER.warn("NonTransformerBranch X fixed: I {} J {} CKT '{}'. Fixed X '{}'", new Object[]{branch.getI(), branch.getJ(), branch.getCkt(), branch.getX()});
            }
        });
    }

    @FunctionalInterface
    public static interface IdFixer<T> {
        public String fix(T var1, Set<String> var2);
    }
}

