/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.pf.io;

import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.io.FileFormat;
import com.powsybl.psse.model.pf.io.BusData;
import com.powsybl.psse.model.pf.io.CaseIdentificationData;
import com.powsybl.psse.model.pf.io.FactsDeviceData;
import com.powsybl.psse.model.pf.io.FixedBusShuntData;
import com.powsybl.psse.model.pf.io.GeneratorData;
import com.powsybl.psse.model.pf.io.LoadData;
import com.powsybl.psse.model.pf.io.NonTransformerBranchData;
import com.powsybl.psse.model.pf.io.PowerFlowData;
import com.powsybl.psse.model.pf.io.PowerFlowRawData32;
import com.powsybl.psse.model.pf.io.PowerFlowRawData33;
import com.powsybl.psse.model.pf.io.PowerFlowRawData35;
import com.powsybl.psse.model.pf.io.PowerFlowRawDataAllVersions;
import com.powsybl.psse.model.pf.io.PowerFlowRawxData35;
import com.powsybl.psse.model.pf.io.PowerFlowRawxDataAllVersions;
import com.powsybl.psse.model.pf.io.PowerFlowRecordGroup;
import com.powsybl.psse.model.pf.io.SubstationData;
import com.powsybl.psse.model.pf.io.SwitchedShuntData;
import com.powsybl.psse.model.pf.io.TransformerData;
import com.powsybl.psse.model.pf.io.TwoTerminalDcTransmissionLineData;
import com.powsybl.psse.model.pf.io.VoltageSourceConverterDcTransmissionLineData;

public final class PowerFlowDataFactory {
    private PowerFlowDataFactory() {
    }

    public static PowerFlowData create(String extension) {
        if (extension.equalsIgnoreCase("rawx")) {
            return new PowerFlowRawxDataAllVersions();
        }
        return new PowerFlowRawDataAllVersions();
    }

    public static PowerFlowData create(String extension, PsseVersion version) {
        if (extension.equalsIgnoreCase("rawx")) {
            switch (version.major()) {
                case V35: {
                    return new PowerFlowRawxData35();
                }
            }
            throw new PsseException("Unsupported version " + version);
        }
        return switch (version.major()) {
            default -> throw new IncompatibleClassChangeError();
            case PsseVersion.Major.V35 -> new PowerFlowRawData35();
            case PsseVersion.Major.V33 -> new PowerFlowRawData33();
            case PsseVersion.Major.V32 -> new PowerFlowRawData32();
        };
    }

    public static Context createPsseContext(boolean rawFormat) {
        Context context = new Context();
        context.setVersion(PsseVersion.fromRevision(35.0f));
        FileFormat fileFormat = rawFormat ? FileFormat.LEGACY_TEXT : FileFormat.JSON;
        context.setFileFormat(fileFormat);
        context.setFieldNames(PowerFlowRecordGroup.CASE_IDENTIFICATION, CaseIdentificationData.FIELD_NAMES_CASE_IDENTIFICATION);
        if (fileFormat == FileFormat.LEGACY_TEXT) {
            context.setFieldNames(PowerFlowRecordGroup.SUBSTATION, SubstationData.FIELD_NAMES_SUBSTATION);
            context.setFieldNames(PowerFlowRecordGroup.INTERNAL_SUBSTATION_NODE, SubstationData.FIELD_NAMES_SUBSTATION_NODE);
            context.setFieldNames(PowerFlowRecordGroup.INTERNAL_SUBSTATION_SWITCHING_DEVICE, SubstationData.FIELD_NAMES_SUBSTATION_SWITCHING_DEVICES);
            context.setFieldNames(PowerFlowRecordGroup.INTERNAL_SUBSTATION_EQUIPMENT_TERMINAL_ONE_BUS, SubstationData.FIELD_NAMES_SUBSTATION_EQUIPMENT_TERMINALS_ONE_BUS);
            context.setFieldNames(PowerFlowRecordGroup.INTERNAL_SUBSTATION_EQUIPMENT_TERMINAL_TWO_BUSES, SubstationData.FIELD_NAMES_SUBSTATION_EQUIPMENT_TERMINALS_TWO_BUSES);
            context.setFieldNames(PowerFlowRecordGroup.INTERNAL_SUBSTATION_EQUIPMENT_TERMINAL_THREE_BUSES, SubstationData.FIELD_NAMES_SUBSTATION_EQUIPMENT_TERMINALS_THREE_BUSES);
        } else {
            context.setFieldNames(PowerFlowRecordGroup.SUBSTATION, SubstationData.FIELD_NAMES_SUBSTATION_RAWX);
            context.setFieldNames(PowerFlowRecordGroup.INTERNAL_SUBSTATION_NODE, SubstationData.FIELD_NAMES_SUBSTATION_NODE_RAWX);
            context.setFieldNames(PowerFlowRecordGroup.INTERNAL_SUBSTATION_SWITCHING_DEVICE, SubstationData.FIELD_NAMES_SUBSTATION_SWITCHING_DEVICES_RAWX);
            context.setFieldNames(PowerFlowRecordGroup.INTERNAL_SUBSTATION_EQUIPMENT_TERMINAL, SubstationData.FIELD_NAMES_SUBSTATION_EQUIPMENT_TERMINALS_RAWX);
        }
        context.setFieldNames(PowerFlowRecordGroup.BUS, BusData.FIELD_NAMES_BUS_35);
        context.setFieldNames(PowerFlowRecordGroup.LOAD, LoadData.FIELD_NAMES_LOAD_35);
        context.setFieldNames(PowerFlowRecordGroup.FIXED_BUS_SHUNT, FixedBusShuntData.FIELD_NAMES_35);
        context.setFieldNames(PowerFlowRecordGroup.GENERATOR, GeneratorData.FIELD_NAMES_35);
        context.setFieldNames(PowerFlowRecordGroup.NON_TRANSFORMER_BRANCH, NonTransformerBranchData.FIELD_NAMES_35);
        if (fileFormat == FileFormat.LEGACY_TEXT) {
            context.setFieldNames(PowerFlowRecordGroup.TRANSFORMER, TransformerData.FIELD_NAMES_35);
            context.setFieldNames(PowerFlowRecordGroup.INTERNAL_TRANSFORMER_IMPEDANCES, TransformerData.FIELD_NAMES_IMPEDANCES_35);
            context.setFieldNames(PowerFlowRecordGroup.INTERNAL_TRANSFORMER_WINDING, TransformerData.FIELD_NAMES_WINDING_35);
        } else {
            context.setFieldNames(PowerFlowRecordGroup.TRANSFORMER, TransformerData.FIELD_NAMES_35_RAWX);
        }
        context.setFieldNames(PowerFlowRecordGroup.FACTS_CONTROL_DEVICE, FactsDeviceData.FIELD_NAMES_35);
        if (fileFormat == FileFormat.LEGACY_TEXT) {
            context.setFieldNames(PowerFlowRecordGroup.TWO_TERMINAL_DC_TRANSMISSION_LINE, TwoTerminalDcTransmissionLineData.FIELD_NAMES_35);
            context.setFieldNames(PowerFlowRecordGroup.INTERNAL_TWO_TERMINAL_DC_TRANSMISSION_LINE_CONVERTER, TwoTerminalDcTransmissionLineData.FIELD_NAMES_CONVERTER_35);
        } else {
            context.setFieldNames(PowerFlowRecordGroup.TWO_TERMINAL_DC_TRANSMISSION_LINE, TwoTerminalDcTransmissionLineData.FIELD_NAMES_35_RAWX);
        }
        if (fileFormat == FileFormat.LEGACY_TEXT) {
            context.setFieldNames(PowerFlowRecordGroup.VOLTAGE_SOURCE_CONVERTER_DC_TRANSMISSION_LINE, VoltageSourceConverterDcTransmissionLineData.FIELD_NAMES_35);
            context.setFieldNames(PowerFlowRecordGroup.INTERNAL_VOLTAGE_SOURCE_CONVERTER_DC_TRANSMISSION_LINE_CONVERTER, VoltageSourceConverterDcTransmissionLineData.FIELD_NAMES_CONVERTER_35);
        } else {
            context.setFieldNames(PowerFlowRecordGroup.VOLTAGE_SOURCE_CONVERTER_DC_TRANSMISSION_LINE, VoltageSourceConverterDcTransmissionLineData.FIELD_NAMES_35_RAWX);
        }
        if (fileFormat == FileFormat.LEGACY_TEXT) {
            context.setFieldNames(PowerFlowRecordGroup.SWITCHED_SHUNT, SwitchedShuntData.FIELD_NAMES_35);
        } else {
            context.setFieldNames(PowerFlowRecordGroup.SWITCHED_SHUNT, SwitchedShuntData.FIELD_NAMES_35_RAWX);
        }
        return context;
    }
}

