/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.io;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.powsybl.psse.model.PsseException;
import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.io.FileFormat;
import com.powsybl.psse.model.io.LegacyTextReader;
import com.powsybl.psse.model.io.RecordGroupIO;
import com.powsybl.psse.model.io.RecordGroupIOJson;
import com.powsybl.psse.model.io.RecordGroupIOLegacyText;
import com.powsybl.psse.model.io.RecordGroupIdentification;
import com.univocity.parsers.common.processor.BeanListProcessor;
import com.univocity.parsers.common.processor.BeanWriterProcessor;
import com.univocity.parsers.common.processor.RowWriterProcessor;
import com.univocity.parsers.common.processor.core.Processor;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractRecordGroup<T> {
    protected final RecordGroupIdentification identification;
    private final String[] fieldNames;
    private final Map<PsseVersion.Major, String[]> fieldNamesByVersionMajor = new EnumMap<PsseVersion.Major, String[]>(PsseVersion.Major.class);
    private String[] quotedFields;
    private final Table<FileFormat, PsseVersion.Major, RecordGroupIO<T>> ioFormatVersion = HashBasedTable.create();
    private final Map<FileFormat, RecordGroupIO<T>> ioFormat = new EnumMap<FileFormat, RecordGroupIO<T>>(FileFormat.class);

    protected AbstractRecordGroup(RecordGroupIdentification identification, String ... fieldNames) {
        this.identification = identification;
        this.fieldNames = fieldNames.length > 0 ? fieldNames : null;
        this.ioFormat.put(FileFormat.LEGACY_TEXT, new RecordGroupIOLegacyText(this));
        this.ioFormat.put(FileFormat.JSON, new RecordGroupIOJson(this));
    }

    protected void withFieldNames(PsseVersion.Major version, String ... fieldNames) {
        this.fieldNamesByVersionMajor.put(version, fieldNames);
    }

    protected void withIO(FileFormat fileFormat, RecordGroupIO<T> rw) {
        Objects.requireNonNull(fileFormat);
        Objects.requireNonNull(rw);
        this.ioFormat.put(fileFormat, rw);
    }

    protected void withIO(FileFormat fileFormat, PsseVersion.Major version, RecordGroupIO<T> io) {
        Objects.requireNonNull(fileFormat);
        Objects.requireNonNull(io);
        this.ioFormatVersion.put((Object)fileFormat, (Object)version, io);
    }

    protected void withQuotedFields(String ... quotedFields) {
        this.quotedFields = quotedFields;
    }

    public RecordGroupIdentification getIdentification() {
        return this.identification;
    }

    RecordGroupIdentification getIdentificationFor(T object) {
        return this.identification;
    }

    public String[] fieldNames(PsseVersion version) {
        if (this.fieldNames != null) {
            return this.fieldNames;
        }
        String[] fieldNamesVersion = this.fieldNamesByVersionMajor.get((Object)version.major());
        if (fieldNamesVersion == null) {
            throw new PsseException("Missing fieldNames for version " + version.getMajorNumber() + " in record group " + this.identification);
        }
        return fieldNamesVersion;
    }

    String[][] getFieldNamesByLine(PsseVersion version, String line0) {
        throw new PsseException("Multiline records no supported at this level");
    }

    public String[] quotedFields() {
        return this.quotedFields;
    }

    protected abstract Class<T> psseTypeClass();

    RecordGroupIO<T> ioFor(FileFormat fileFormat, PsseVersion.Major version) {
        if (this.ioFormatVersion.contains((Object)fileFormat, (Object)version)) {
            return (RecordGroupIO)this.ioFormatVersion.get((Object)fileFormat, (Object)version);
        }
        return this.ioFor(fileFormat);
    }

    RecordGroupIO<T> ioFor(FileFormat fileFormat) {
        RecordGroupIO<T> r = this.ioFormat.get((Object)fileFormat);
        if (r == null) {
            throw new PsseException("No reader/writer for file format " + fileFormat);
        }
        return r;
    }

    RecordGroupIO<T> ioFor(Context context) {
        if (context.getVersion() == null) {
            return this.ioFor(context.getFileFormat());
        }
        return this.ioFor(context.getFileFormat(), context.getVersion().major());
    }

    public List<T> read(LegacyTextReader reader, Context context) throws IOException {
        return this.ioFor(context).read(reader, context);
    }

    public void write(List<T> psseObjects, Context context, OutputStream outputStream) {
        this.ioFor(context).write(psseObjects, context, outputStream);
    }

    public T readHead(LegacyTextReader reader, Context context) throws IOException {
        return this.ioFor(context).readHead(reader, context);
    }

    public void writeHead(T psseObject, Context context, OutputStream outputStream) {
        this.ioFor(context).writeHead(psseObject, context, outputStream);
    }

    public List<T> readFromStrings(List<String> records, Context context) {
        if (records.isEmpty()) {
            return new ArrayList();
        }
        Object[] allFieldNames = this.fieldNames(context.getVersion());
        List<T> psseObjects = this.parseRecords(records, (String[])allFieldNames, context);
        String[] actualFieldNames = (String[])ArrayUtils.subarray((Object[])allFieldNames, (int)0, (int)context.getCurrentRecordGroupMaxNumFields());
        context.setFieldNames(this.identification, actualFieldNames);
        return psseObjects;
    }

    public T parseSingleRecord(String record, String[] headers, Context context) {
        return this.parseRecords(Collections.singletonList(record), headers, context).get(0);
    }

    List<T> parseRecords(List<String> records, String[] headers, Context context) {
        int expectedCount = records.size();
        BeanListProcessor processor = new BeanListProcessor(this.psseTypeClass(), expectedCount);
        CsvParserSettings settings = context.getCsvParserSettings();
        settings.setHeaders(headers);
        settings.setProcessor((Processor)processor);
        CsvParser parser = new CsvParser(settings);
        context.resetCurrentRecordGroup();
        for (String record : records) {
            String[] fields = parser.parseLine(record);
            if (fields == null) {
                throw new PsseException("Parsing error");
            }
            context.setCurrentRecordNumFields(fields.length);
        }
        List beans = processor.getBeans();
        if (beans.size() != expectedCount) {
            throw new PsseException("Parsing error");
        }
        return beans;
    }

    public String buildRecord(T object, String[] headers, String[] quoteFields, Context context) {
        return AbstractRecordGroup.unquoteNullString(new CsvWriter(this.settingsForCsvWriter(headers, quoteFields, context)).processRecordToString(object));
    }

    public List<String> buildRecords(List<T> objects, String[] headers, String[] quoteFields, Context context) {
        return AbstractRecordGroup.unquoteNullStrings(new CsvWriter(this.settingsForCsvWriter(headers, quoteFields, context)).processRecordsToString(objects));
    }

    private static List<String> unquoteNullStrings(List<String> stringList) {
        return stringList.stream().map(AbstractRecordGroup::unquoteNullString).collect(Collectors.toList());
    }

    private static String unquoteNullString(String string) {
        return string.replace("\"null\"", "null");
    }

    CsvWriterSettings settingsForCsvWriter(String[] headers, String[] quotedFields, Context context) {
        BeanWriterProcessor processor = new BeanWriterProcessor(this.psseTypeClass());
        CsvWriterSettings settings = new CsvWriterSettings();
        settings.quoteFields(quotedFields);
        settings.setHeaders(headers);
        ((CsvFormat)settings.getFormat()).setQuote(context.getFileFormat().getQuote());
        ((CsvFormat)settings.getFormat()).setDelimiter(context.getDelimiter());
        settings.setIgnoreLeadingWhitespaces(false);
        settings.setIgnoreTrailingWhitespaces(false);
        settings.setRowWriterProcessor((RowWriterProcessor)processor);
        return settings;
    }
}

