/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.pf.io;

import com.powsybl.psse.model.io.AbstractRecordGroup;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.io.FileFormat;
import com.powsybl.psse.model.io.LegacyTextReader;
import com.powsybl.psse.model.io.RecordGroupIOLegacyText;
import com.powsybl.psse.model.pf.PsseGneDevice;
import com.powsybl.psse.model.pf.io.PowerFlowRecordGroup;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

class GneDeviceData
extends AbstractRecordGroup<PsseGneDevice> {
    private static final String[] QUOTED_FIELDS = new String[]{"name", "model", "char1", "char2", "char3", "char4", "char5", "char6", "char7", "char8", "char9", "char10"};

    GneDeviceData() {
        super(PowerFlowRecordGroup.GNE_DEVICE, new String[0]);
        this.withQuotedFields(QUOTED_FIELDS);
        this.withIO(FileFormat.LEGACY_TEXT, new IOLegacyText(this));
    }

    @Override
    protected Class<PsseGneDevice> psseTypeClass() {
        return PsseGneDevice.class;
    }

    private static class IOLegacyText
    extends RecordGroupIOLegacyText<PsseGneDevice> {
        private static final String[][] FIELD_NAMES = new String[][]{{"name", "model", "nterm", "bus1", "bus2", "nreal", "nintg", "nchar", "status", "owner", "nmet"}, {"real1", "real2", "real3", "real4", "real5", "real6", "real7", "real8", "real9", "real10"}, {"intg1", "intg2", "intg3", "intg4", "intg5", "intg6", "intg7", "intg8", "intg9", "intg10"}, {"char1", "char2", "char3", "char4", "char5", "char6", "char7", "char8", "char9", "char10"}};

        IOLegacyText(AbstractRecordGroup<PsseGneDevice> recordGroup) {
            super(recordGroup);
        }

        @Override
        public List<PsseGneDevice> read(LegacyTextReader reader, Context context) throws IOException {
            List<String> records = reader.readRecords();
            ArrayList<PsseGneDevice> gneDeviceList = new ArrayList<PsseGneDevice>();
            int maxNumMainHeaders = 0;
            int i = 0;
            while (i < records.size()) {
                String record = records.get(i++);
                int nreal = IOLegacyText.getNreal(record, Character.toString(context.getDelimiter()));
                int nintg = IOLegacyText.getNintg(record, Character.toString(context.getDelimiter()));
                int nchar = IOLegacyText.getNchar(record, Character.toString(context.getDelimiter()));
                Object[] headers = FIELD_NAMES[0];
                if (nreal > 0) {
                    record = String.join((CharSequence)Character.toString(context.getDelimiter()), record, records.get(i++));
                    headers = (String[])ArrayUtils.addAll((Object[])headers, (Object[])((String[])ArrayUtils.subarray((Object[])FIELD_NAMES[1], (int)0, (int)nreal)));
                }
                if (nintg > 0) {
                    record = String.join((CharSequence)Character.toString(context.getDelimiter()), record, records.get(i++));
                    headers = (String[])ArrayUtils.addAll((Object[])headers, (Object[])((String[])ArrayUtils.subarray((Object[])FIELD_NAMES[2], (int)0, (int)nintg)));
                }
                if (nchar > 0) {
                    record = String.join((CharSequence)Character.toString(context.getDelimiter()), record, records.get(i++));
                    headers = (String[])ArrayUtils.addAll((Object[])headers, (Object[])((String[])ArrayUtils.subarray((Object[])FIELD_NAMES[3], (int)0, (int)nchar)));
                }
                gneDeviceList.add((PsseGneDevice)this.recordGroup.parseSingleRecord(record, (String[])headers, context));
                maxNumMainHeaders = IOLegacyText.setMaxNumMainHeaders(maxNumMainHeaders, context.getCurrentRecordGroupMaxNumFields() - nreal - nintg - nchar);
            }
            String[] actualFieldNames = (String[])ArrayUtils.subarray((Object[])FIELD_NAMES[0], (int)0, (int)maxNumMainHeaders);
            context.setFieldNames(this.recordGroup.getIdentification(), actualFieldNames);
            return gneDeviceList;
        }

        @Override
        public void write(List<PsseGneDevice> gneDeviceList, Context context, OutputStream outputStream) {
            this.writeBegin(outputStream);
            gneDeviceList.forEach(gneDevice -> {
                String[] headers;
                ArrayList<String> records = new ArrayList<String>();
                String[] mainHeaders = context.getFieldNames(PowerFlowRecordGroup.GNE_DEVICE);
                records.add(this.recordGroup.buildRecord((PsseGneDevice)gneDevice, mainHeaders, this.recordGroup.quotedFields(), context));
                if (gneDevice.getNreal() > 0) {
                    headers = (String[])ArrayUtils.subarray((Object[])FIELD_NAMES[1], (int)0, (int)gneDevice.getNreal());
                    records.add(this.recordGroup.buildRecord((PsseGneDevice)gneDevice, headers, this.recordGroup.quotedFields(), context));
                }
                if (gneDevice.getNintg() > 0) {
                    headers = (String[])ArrayUtils.subarray((Object[])FIELD_NAMES[2], (int)0, (int)gneDevice.getNintg());
                    records.add(this.recordGroup.buildRecord((PsseGneDevice)gneDevice, headers, this.recordGroup.quotedFields(), context));
                }
                if (gneDevice.getNchar() > 0) {
                    headers = (String[])ArrayUtils.subarray((Object[])FIELD_NAMES[3], (int)0, (int)gneDevice.getNchar());
                    records.add(this.recordGroup.buildRecord((PsseGneDevice)gneDevice, headers, this.recordGroup.quotedFields(), context));
                }
                IOLegacyText.write(records, outputStream);
            });
            this.writeEnd(outputStream);
        }

        private static int getNreal(String record, String delimiter) {
            return IOLegacyText.getN(record, delimiter, 6);
        }

        private static int getNintg(String record, String delimiter) {
            return IOLegacyText.getN(record, delimiter, 7);
        }

        private static int getNchar(String record, String delimiter) {
            return IOLegacyText.getN(record, delimiter, 8);
        }

        private static int getN(String record, String delimiter, int length) {
            String[] tokens = record.split(delimiter);
            if (tokens.length < length) {
                return 0;
            }
            return Integer.parseInt(tokens[length - 1].trim());
        }

        private static int setMaxNumMainHeaders(int maxNumMainHeaders, int numMainHeaders) {
            if (numMainHeaders > maxNumMainHeaders) {
                return numMainHeaders;
            }
            return maxNumMainHeaders;
        }
    }
}

