/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.psse.model.pf.io;

import com.powsybl.psse.model.PsseVersion;
import com.powsybl.psse.model.io.AbstractRecordGroup;
import com.powsybl.psse.model.io.Context;
import com.powsybl.psse.model.io.FileFormat;
import com.powsybl.psse.model.io.LegacyTextReader;
import com.powsybl.psse.model.io.RecordGroupIOLegacyText;
import com.powsybl.psse.model.pf.PsseRates;
import com.powsybl.psse.model.pf.PsseTransformer;
import com.powsybl.psse.model.pf.PsseTransformerWinding;
import com.powsybl.psse.model.pf.io.PowerFlowRecordGroup;
import com.univocity.parsers.annotations.Nested;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Stream;

class TransformerData
extends AbstractRecordGroup<PsseTransformer> {
    private static final String[] FIELD_NAMES_T2W_IMPEDANCES_RECORD = new String[]{"r12", "x12", "sbase12"};
    private static final String[] FIELD_NAMES_T2W_WINDING_RECORD = new String[]{"windv", "nomv"};
    private static final String[] FIELD_NAMES_WINDING_32_33 = new String[]{"windv", "nomv", "ang", "rata", "ratb", "ratc", "cod", "cont", "rma", "rmi", "vma", "vmi", "ntp", "tab", "cr", "cx", "cnxa"};
    static final String[] FIELD_NAMES_35 = new String[]{"ibus", "jbus", "kbus", "ckt", "cw", "cz", "cm", "mag1", "mag2", "nmet", "name", "stat", "o1", "f1", "o2", "f2", "o3", "f3", "o4", "f4", "vecgrp", "zcod"};
    static final String[] FIELD_NAMES_IMPEDANCES_35 = new String[]{"r12", "x12", "sbase12", "r23", "x23", "sbase23", "r31", "x31", "sbase31", "vmstar", "anstar"};
    static final String[] FIELD_NAMES_WINDING_35 = new String[]{"windv", "nomv", "ang", "wdgrate1", "wdgrate2", "wdgrate3", "wdgrate4", "wdgrate5", "wdgrate6", "wdgrate7", "wdgrate8", "wdgrate9", "wdgrate10", "wdgrate11", "wdgrate12", "cod", "cont", "node", "rma", "rmi", "vma", "vmi", "ntp", "tab", "cr", "cx", "cnxa"};
    static final String[] FIELD_NAMES_IMPEDANCES_AND_WINDINGS_35_RAWX = new String[]{"r1_2", "x1_2", "sbase1_2", "r2_3", "x2_3", "sbase2_3", "r3_1", "x3_1", "sbase3_1", "vmstar", "anstar", "windv1", "nomv1", "ang1", "wdg1rate1", "wdg1rate2", "wdg1rate3", "wdg1rate4", "wdg1rate5", "wdg1rate6", "wdg1rate7", "wdg1rate8", "wdg1rate9", "wdg1rate10", "wdg1rate11", "wdg1rate12", "cod1", "cont1", "node1", "rma1", "rmi1", "vma1", "vmi1", "ntp1", "tab1", "cr1", "cx1", "cnxa1", "windv2", "nomv2", "ang2", "wdg2rate1", "wdg2rate2", "wdg2rate3", "wdg2rate4", "wdg2rate5", "wdg2rate6", "wdg2rate7", "wdg2rate8", "wdg2rate9", "wdg2rate10", "wdg2rate11", "wdg2rate12", "cod2", "cont2", "node2", "rma2", "rmi2", "vma2", "vmi2", "ntp2", "tab2", "cr2", "cx2", "cnxa2", "windv3", "nomv3", "ang3", "wdg3rate1", "wdg3rate2", "wdg3rate3", "wdg3rate4", "wdg3rate5", "wdg3rate6", "wdg3rate7", "wdg3rate8", "wdg3rate9", "wdg3rate10", "wdg3rate11", "wdg3rate12", "cod3", "cont3", "node3", "rma3", "rmi3", "vma3", "vmi3", "ntp3", "tab3", "cr3", "cx3", "cnxa3"};
    static final String[] FIELD_NAMES_35_RAWX = (String[])Stream.concat(Arrays.stream(FIELD_NAMES_35), Arrays.stream(FIELD_NAMES_IMPEDANCES_AND_WINDINGS_35_RAWX)).toArray(String[]::new);

    TransformerData() {
        super(PowerFlowRecordGroup.TRANSFORMER, new String[0]);
        this.withFieldNames(PsseVersion.Major.V32, "i", "j", "k", "ckt", "cw", "cz", "cm", "mag1", "mag2", "nmetr", "name", "stat", "o1", "f1", "o2", "f2", "o3", "f3", "o4", "f4");
        this.withFieldNames(PsseVersion.Major.V33, "i", "j", "k", "ckt", "cw", "cz", "cm", "mag1", "mag2", "nmetr", "name", "stat", "o1", "f1", "o2", "f2", "o3", "f3", "o4", "f4", "vecgrp");
        this.withFieldNames(PsseVersion.Major.V35, FIELD_NAMES_35);
        this.withQuotedFields("ckt", "name", "vecgrp");
        this.withIO(FileFormat.LEGACY_TEXT, new IOLegacyText(this));
    }

    @Override
    protected Class<PsseTransformer> psseTypeClass() {
        return PsseTransformer.class;
    }

    private static class IOLegacyText
    extends RecordGroupIOLegacyText<PsseTransformer> {
        IOLegacyText(AbstractRecordGroup<PsseTransformer> recordGroup) {
            super(recordGroup);
        }

        @Override
        public List<PsseTransformer> read(LegacyTextReader reader, Context context) throws IOException {
            ArrayList<String> mainRecords = new ArrayList<String>();
            ArrayList<String> impedanceRecords = new ArrayList<String>();
            ArrayList<String> windingRecords = new ArrayList<String>();
            if (!reader.isQRecordFound()) {
                String line = reader.readUntilFindingARecordLineNotEmpty();
                while (!reader.endOfBlock(line)) {
                    mainRecords.add(line);
                    impedanceRecords.add(reader.readRecordLine());
                    windingRecords.add(reader.readRecordLine());
                    windingRecords.add(reader.readRecordLine());
                    if (IOLegacyText.is3Winding(line)) {
                        windingRecords.add(reader.readRecordLine());
                    }
                    line = reader.readUntilFindingARecordLineNotEmpty();
                }
            }
            List<PsseTransformer> transformerList = this.recordGroup.readFromStrings(mainRecords, context);
            List impedanceList = new PsseTransformerImpedancesRecordData().readFromStrings(impedanceRecords, context);
            List windingList = new PsseTransformerWindingRecordData().readFromStrings(windingRecords, context);
            int indexImpedance = 0;
            int indexWinding = 0;
            for (PsseTransformer transformer : transformerList) {
                transformer.setImpedances((PsseTransformer.TransformerImpedances)impedanceList.get(indexImpedance));
                ++indexImpedance;
                transformer.setWinding1(((TransformerWindingRecord)windingList.get((int)indexWinding)).winding, ((TransformerWindingRecord)windingList.get((int)indexWinding)).windingRates);
                transformer.setWinding2(((TransformerWindingRecord)windingList.get((int)(++indexWinding))).winding, ((TransformerWindingRecord)windingList.get((int)indexWinding)).windingRates);
                ++indexWinding;
                if (transformer.getK() == 0) continue;
                transformer.setWinding3(((TransformerWindingRecord)windingList.get((int)indexWinding)).winding, ((TransformerWindingRecord)windingList.get((int)indexWinding)).windingRates);
                ++indexWinding;
            }
            return transformerList;
        }

        @Override
        public void write(List<PsseTransformer> transformerList, Context context, OutputStream outputStream) {
            ArrayList impedanceList = new ArrayList();
            ArrayList impedanceT2wList = new ArrayList();
            ArrayList windingList = new ArrayList();
            ArrayList windingT2wList = new ArrayList();
            transformerList.forEach(transformer -> {
                if (transformer.getK() == 0) {
                    impedanceT2wList.add(transformer.getImpedances());
                    windingList.add(this.getWindingRecord(transformer.getWinding1(), transformer.getWinding1Rates()));
                    windingT2wList.add(this.getWindingRecord(transformer.getWinding2(), transformer.getWinding2Rates()));
                } else {
                    impedanceList.add(transformer.getImpedances());
                    windingList.add(this.getWindingRecord(transformer.getWinding1(), transformer.getWinding1Rates()));
                    windingList.add(this.getWindingRecord(transformer.getWinding2(), transformer.getWinding2Rates()));
                    windingList.add(this.getWindingRecord(transformer.getWinding3(), transformer.getWinding3Rates()));
                }
            });
            String[] mainHeaders = context.getFieldNames(PowerFlowRecordGroup.TRANSFORMER);
            String[] quotedFields = this.recordGroup.quotedFields();
            List<String> firstRecordList = this.recordGroup.buildRecords(transformerList, mainHeaders, quotedFields, context);
            PsseTransformerImpedancesRecordData impedanceRecordData = new PsseTransformerImpedancesRecordData();
            String[] impedanceHeaders = context.getFieldNames(PowerFlowRecordGroup.INTERNAL_TRANSFORMER_IMPEDANCES);
            List<String> impedanceRecordList = impedanceRecordData.buildRecords(impedanceList, impedanceHeaders, quotedFields, context);
            List<String> impedanceRecordT2wList = impedanceRecordData.buildRecords(impedanceT2wList, FIELD_NAMES_T2W_IMPEDANCES_RECORD, quotedFields, context);
            PsseTransformerWindingRecordData windingRecordData = new PsseTransformerWindingRecordData();
            String[] windingHeaders = context.getFieldNames(PowerFlowRecordGroup.INTERNAL_TRANSFORMER_WINDING);
            List<String> windingRecordList = windingRecordData.buildRecords(windingList, windingHeaders, quotedFields, context);
            List<String> windingRecordT2wList = windingRecordData.buildRecords(windingT2wList, FIELD_NAMES_T2W_WINDING_RECORD, quotedFields, context);
            this.writeBegin(outputStream);
            int indexFirst = 0;
            int indexImpedance = 0;
            int indexImpedanceT2w = 0;
            int indexWinding = 0;
            int indexWindingT2w = 0;
            for (PsseTransformer transformer2 : transformerList) {
                String winding2;
                String winding1;
                String impedance;
                String first = firstRecordList.get(indexFirst);
                ++indexFirst;
                if (transformer2.getK() == 0) {
                    impedance = impedanceRecordT2wList.get(indexImpedanceT2w);
                    ++indexImpedanceT2w;
                    winding1 = windingRecordList.get(indexWinding);
                    ++indexWinding;
                    winding2 = windingRecordT2wList.get(indexWindingT2w);
                    ++indexWindingT2w;
                    IOLegacyText.write(Arrays.asList(first, impedance, winding1, winding2), outputStream);
                    continue;
                }
                impedance = impedanceRecordList.get(indexImpedance);
                ++indexImpedance;
                winding1 = windingRecordList.get(indexWinding);
                winding2 = windingRecordList.get(++indexWinding);
                String winding3 = windingRecordList.get(++indexWinding);
                ++indexWinding;
                IOLegacyText.write(Arrays.asList(first, impedance, winding1, winding2, winding3), outputStream);
            }
            this.writeEnd(outputStream);
        }

        private TransformerWindingRecord getWindingRecord(PsseTransformerWinding winding, PsseRates windingRates) {
            TransformerWindingRecord windingRecord = new TransformerWindingRecord();
            windingRecord.winding = winding;
            windingRecord.windingRates = windingRates;
            return windingRecord;
        }

        private static boolean is3Winding(String recordStr) {
            try (Scanner scanner = new Scanner(recordStr);){
                scanner.useDelimiter("\\s*[, ]\\s*");
                int i = scanner.hasNextInt() ? scanner.nextInt() : 0;
                int j = scanner.hasNextInt() ? scanner.nextInt() : 0;
                int k = scanner.hasNextInt() ? scanner.nextInt() : 0;
                boolean bl = i != 0 && j != 0 && k != 0;
                return bl;
            }
        }

        private static class PsseTransformerImpedancesRecordData
        extends AbstractRecordGroup<PsseTransformer.TransformerImpedances> {
            PsseTransformerImpedancesRecordData() {
                super(PowerFlowRecordGroup.INTERNAL_TRANSFORMER_IMPEDANCES, FIELD_NAMES_IMPEDANCES_35);
            }

            @Override
            public Class<PsseTransformer.TransformerImpedances> psseTypeClass() {
                return PsseTransformer.TransformerImpedances.class;
            }
        }

        private static class PsseTransformerWindingRecordData
        extends AbstractRecordGroup<TransformerWindingRecord> {
            PsseTransformerWindingRecordData() {
                super(PowerFlowRecordGroup.INTERNAL_TRANSFORMER_WINDING, new String[0]);
                this.withFieldNames(PsseVersion.Major.V32, FIELD_NAMES_WINDING_32_33);
                this.withFieldNames(PsseVersion.Major.V33, FIELD_NAMES_WINDING_32_33);
                this.withFieldNames(PsseVersion.Major.V35, FIELD_NAMES_WINDING_35);
            }

            @Override
            public Class<TransformerWindingRecord> psseTypeClass() {
                return TransformerWindingRecord.class;
            }
        }
    }

    public static class TransformerWindingRecord {
        @Nested
        private PsseTransformerWinding winding;
        @Nested
        private PsseRates windingRates;
    }
}

