/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.VoltageAngleLimit;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationType;
import java.util.Objects;
import java.util.Optional;

public final class LimitViolationHelper {
    private LimitViolationHelper() {
    }

    private static VoltageLevel getVoltageLevel(LimitViolation limitViolation, Network network) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(limitViolation);
        Identifiable identifiable = network.getIdentifiable(limitViolation.getSubjectId());
        if (limitViolation.getLimitType() == LimitViolationType.LOW_VOLTAGE_ANGLE || limitViolation.getLimitType() == LimitViolationType.HIGH_VOLTAGE_ANGLE) {
            VoltageAngleLimit limit = network.getVoltageAngleLimit(limitViolation.getSubjectId());
            if (limit != null) {
                return limit.getTerminalFrom().getVoltageLevel();
            }
            throw new PowsyblException("Limit from limit violation is not in the network.");
        }
        if (identifiable instanceof Branch) {
            Branch branch = (Branch)identifiable;
            return branch.getTerminal(limitViolation.getSide()).getVoltageLevel();
        }
        if (identifiable instanceof Injection) {
            Injection injection = (Injection)identifiable;
            return injection.getTerminal().getVoltageLevel();
        }
        if (identifiable instanceof VoltageLevel) {
            VoltageLevel voltageLevel = (VoltageLevel)identifiable;
            return voltageLevel;
        }
        if (identifiable instanceof Bus) {
            Bus bus = (Bus)identifiable;
            return bus.getVoltageLevel();
        }
        throw new IllegalStateException("Unexpected identifiable type: " + identifiable.getClass());
    }

    public static Optional<Country> getCountry(LimitViolation limitViolation, Network network) {
        VoltageLevel voltageLevel = LimitViolationHelper.getVoltageLevel(limitViolation, network);
        return voltageLevel.getSubstation().flatMap(Substation::getCountry);
    }

    public static String getVoltageLevelId(LimitViolation limitViolation, Network network) {
        return LimitViolationHelper.getVoltageLevelId(limitViolation, network, false);
    }

    public static String getVoltageLevelId(LimitViolation limitViolation, Network network, boolean name) {
        VoltageLevel voltageLevel = LimitViolationHelper.getVoltageLevel(limitViolation, network);
        return name ? voltageLevel.getNameOrId() : voltageLevel.getId();
    }

    public static double getNominalVoltage(LimitViolation limitViolation, Network network) {
        VoltageLevel voltageLevel = LimitViolationHelper.getVoltageLevel(limitViolation, network);
        return voltageLevel.getNominalV();
    }
}

