/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.powsybl.contingency.ContingenciesProvider;
import com.powsybl.contingency.ContingenciesProviders;
import com.powsybl.iidm.network.Network;
import com.powsybl.security.LimitViolationDetector;
import com.powsybl.security.LimitViolationFilter;
import com.powsybl.security.SecurityAnalysisParameters;
import com.powsybl.security.detectors.DefaultLimitViolationDetector;
import com.powsybl.security.execution.NetworkVariant;
import com.powsybl.security.interceptors.SecurityAnalysisInterceptor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class SecurityAnalysisInput {
    private final NetworkVariant networkVariant;
    private Set<SecurityAnalysisInterceptor> interceptors;
    private LimitViolationFilter filter;
    private LimitViolationDetector detector;
    private ContingenciesProvider contingencies;
    private SecurityAnalysisParameters parameters;

    public SecurityAnalysisInput(Network network, String variantId) {
        this(new NetworkVariant(network, variantId));
    }

    public SecurityAnalysisInput(NetworkVariant networkVariant) {
        this.networkVariant = Objects.requireNonNull(networkVariant);
        this.interceptors = new HashSet<SecurityAnalysisInterceptor>();
        this.filter = new LimitViolationFilter();
        this.detector = new DefaultLimitViolationDetector();
        this.contingencies = ContingenciesProviders.emptyProvider();
        this.parameters = new SecurityAnalysisParameters();
    }

    public SecurityAnalysisParameters getParameters() {
        return this.parameters;
    }

    public ContingenciesProvider getContingenciesProvider() {
        return this.contingencies;
    }

    public LimitViolationDetector getLimitViolationDetector() {
        return this.detector;
    }

    public LimitViolationFilter getFilter() {
        return this.filter;
    }

    public Set<SecurityAnalysisInterceptor> getInterceptors() {
        return Collections.unmodifiableSet(this.interceptors);
    }

    public SecurityAnalysisInput setDetector(LimitViolationDetector detector) {
        Objects.requireNonNull(detector);
        this.detector = detector;
        return this;
    }

    public SecurityAnalysisInput setContingencies(ContingenciesProvider contingencies) {
        Objects.requireNonNull(contingencies);
        this.contingencies = contingencies;
        return this;
    }

    public SecurityAnalysisInput setParameters(SecurityAnalysisParameters parameters) {
        Objects.requireNonNull(parameters);
        this.parameters = parameters;
        return this;
    }

    public SecurityAnalysisInput addInterceptor(SecurityAnalysisInterceptor interceptor) {
        this.interceptors.add(Objects.requireNonNull(interceptor));
        return this;
    }

    public SecurityAnalysisInput setFilter(LimitViolationFilter filter) {
        this.filter = Objects.requireNonNull(filter);
        return this;
    }

    public NetworkVariant getNetworkVariant() {
        return this.networkVariant;
    }
}

