/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.action;

import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.security.action.AbstractTapChangerRegulationAction;
import java.util.Optional;
import java.util.OptionalDouble;

public class PhaseTapChangerRegulationAction
extends AbstractTapChangerRegulationAction {
    public static final String NAME = "PHASE_TAP_CHANGER_REGULATION";
    private final PhaseTapChanger.RegulationMode regulationMode;
    private final Double regulationValue;

    public PhaseTapChangerRegulationAction(String id, String transformerId, ThreeWindingsTransformer.Side side, boolean regulating, PhaseTapChanger.RegulationMode regulationMode, Double regulationValue) {
        super(id, transformerId, side, regulating);
        this.regulationMode = regulationMode;
        this.regulationValue = regulationValue;
        if (!regulating && this.regulationMode != null) {
            throw new IllegalArgumentException("PhaseTapChangerRegulationAction can not have a regulation mode if it is not regulating");
        }
    }

    @Override
    public String getType() {
        return NAME;
    }

    public Optional<PhaseTapChanger.RegulationMode> getRegulationMode() {
        return Optional.ofNullable(this.regulationMode);
    }

    public OptionalDouble getRegulationValue() {
        return this.regulationValue == null ? OptionalDouble.empty() : OptionalDouble.of(this.regulationValue);
    }

    public static PhaseTapChangerRegulationAction activateRegulation(String id, String transformerId) {
        return new PhaseTapChangerRegulationAction(id, transformerId, null, true, null, null);
    }

    public static PhaseTapChangerRegulationAction activateRegulation(String id, String transformerId, ThreeWindingsTransformer.Side side) {
        return new PhaseTapChangerRegulationAction(id, transformerId, side, true, null, null);
    }

    public static PhaseTapChangerRegulationAction activateAndChangeRegulationMode(String id, String transformerId, PhaseTapChanger.RegulationMode regulationMode, Double regulationValue) {
        return new PhaseTapChangerRegulationAction(id, transformerId, null, true, regulationMode, regulationValue);
    }

    public static PhaseTapChangerRegulationAction activateAndChangeRegulationMode(String id, String transformerId, ThreeWindingsTransformer.Side side, PhaseTapChanger.RegulationMode regulationMode, Double regulationValue) {
        return new PhaseTapChangerRegulationAction(id, transformerId, side, true, regulationMode, regulationValue);
    }

    public static PhaseTapChangerRegulationAction deactivateRegulation(String id, String transformerId) {
        return new PhaseTapChangerRegulationAction(id, transformerId, null, false, null, null);
    }

    public static PhaseTapChangerRegulationAction deactivateRegulation(String id, String transformerId, ThreeWindingsTransformer.Side side) {
        return new PhaseTapChangerRegulationAction(id, transformerId, side, false, null, null);
    }
}

