/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.comparator;

import com.powsybl.commons.io.table.Column;
import com.powsybl.commons.io.table.CsvTableFormatterFactory;
import com.powsybl.commons.io.table.TableFormatter;
import com.powsybl.commons.io.table.TableFormatterConfig;
import com.powsybl.iidm.network.Branch;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationType;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityAnalysisResultComparisonWriter
implements AutoCloseable {
    private static final String RESULT = "Result";
    private static final String EQUIVALENT = "equivalent";
    private static final String DIFFERENT = "different";
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityAnalysisResultComparisonWriter.class);
    private TableFormatter formatter;
    private String contingency;

    public SecurityAnalysisResultComparisonWriter(Writer writer) {
        Objects.requireNonNull(writer);
        this.formatter = new CsvTableFormatterFactory().create(writer, "Security Analysis Results Comparison", TableFormatterConfig.load(), this.getColumns());
    }

    private Column[] getColumns() {
        return new Column[]{new Column("Contingency"), new Column("StatusResult1"), new Column("StatusResult2"), new Column("Equipment"), new Column("End"), new Column("ViolationType"), new Column("ViolationNameResult1"), new Column("ValueResult1"), new Column("LimitResult1"), new Column("ViolationNameResult2"), new Column("ValueResult2"), new Column("LimitResult2"), new Column("ActionsResult1"), new Column("ActionsResult2"), new Column("Comparison")};
    }

    public void setContingency(String contingency) {
        this.contingency = contingency;
    }

    private <T> void checkInput(T value1, T value2) {
        if (value1 == null && value2 == null) {
            throw new IllegalArgumentException("At least one of the input values must be not null");
        }
    }

    public SecurityAnalysisResultComparisonWriter write(Boolean computationOk1, Boolean computationOk2, boolean equivalent) {
        this.checkInput(computationOk1, computationOk2);
        try {
            this.formatter = this.contingency == null ? this.formatter.writeEmptyCell() : this.formatter.writeCell(this.contingency);
            this.formatter = computationOk1 == null ? this.formatter.writeEmptyCells(1) : this.formatter.writeCell(this.getStatus(computationOk1));
            this.formatter = computationOk2 == null ? this.formatter.writeEmptyCells(1) : this.formatter.writeCell(this.getStatus(computationOk2));
            this.formatter.writeEmptyCells(11);
            this.formatter.writeCell(this.getComparison(equivalent));
        }
        catch (IOException e) {
            LOGGER.error("Error writing security analysis results computation status comparison: {}", (Object)e.getMessage());
        }
        return this;
    }

    private String getStatus(boolean computationOk) {
        return computationOk ? "converge" : "diverge";
    }

    public SecurityAnalysisResultComparisonWriter write(LimitViolation violation1, LimitViolation violation2, boolean equivalent) {
        this.checkInput(violation1, violation2);
        try {
            this.formatter = this.contingency == null ? this.formatter.writeEmptyCell() : this.formatter.writeCell(this.contingency);
            this.formatter.writeEmptyCells(2);
            this.formatter.writeCell(this.getEquipment(violation1, violation2));
            this.formatter = this.getEnd(violation1, violation2) == null ? this.formatter.writeEmptyCell() : this.formatter.writeCell(this.getEnd(violation1, violation2).name());
            this.formatter.writeCell(this.getViolationType(violation1, violation2).name());
            this.writeViolation(violation1);
            this.writeViolation(violation2);
            this.formatter.writeEmptyCells(2);
            this.formatter.writeCell(this.getComparison(equivalent));
        }
        catch (IOException e) {
            LOGGER.error("Error writing security analysis results violations comparison: {}", (Object)e.getMessage());
        }
        return this;
    }

    private String getEquipment(LimitViolation violation1, LimitViolation violation2) {
        return violation1 == null ? violation2.getSubjectId() : violation1.getSubjectId();
    }

    private Branch.Side getEnd(LimitViolation violation1, LimitViolation violation2) {
        return violation1 == null ? violation2.getSide() : violation1.getSide();
    }

    private LimitViolationType getViolationType(LimitViolation violation1, LimitViolation violation2) {
        return violation1 == null ? violation2.getLimitType() : violation1.getLimitType();
    }

    private void writeViolation(LimitViolation violation) throws IOException {
        if (violation == null) {
            this.formatter.writeEmptyCells(3);
        } else {
            this.formatter = violation.getLimitName() == null ? this.formatter.writeEmptyCell() : this.formatter.writeCell(violation.getLimitName());
            this.formatter.writeCell(violation.getValue()).writeCell(this.getViolationLimit(violation));
        }
    }

    private double getViolationLimit(LimitViolation violation) {
        return violation.getLimit() * (double)violation.getLimitReduction();
    }

    public SecurityAnalysisResultComparisonWriter write(List<String> actions1, List<String> actions2, boolean equivalent) {
        this.checkInput(actions1, actions2);
        if (this.noActions(actions1, actions2)) {
            return this;
        }
        try {
            this.formatter = this.contingency == null ? this.formatter.writeEmptyCell() : this.formatter.writeCell(this.contingency);
            this.formatter.writeEmptyCells(11);
            this.formatter = actions1 == null ? this.formatter.writeEmptyCell() : this.formatter.writeCell(actions1.toString());
            this.formatter = actions2 == null ? this.formatter.writeEmptyCell() : this.formatter.writeCell(actions2.toString());
            this.formatter.writeCell(this.getComparison(equivalent));
        }
        catch (IOException e) {
            LOGGER.error("Error writing security analysis results actions comparison: {}", (Object)e.getMessage());
        }
        return this;
    }

    private boolean noActions(List<String> actions1, List<String> actions2) {
        return !(actions1 != null && !actions1.isEmpty() || actions2 != null && !actions2.isEmpty());
    }

    private String getComparison(boolean equivalent) {
        return equivalent ? EQUIVALENT : DIFFERENT;
    }

    @Override
    public void close() throws IOException {
        this.formatter.close();
    }
}

