/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.detectors;

import com.powsybl.contingency.Contingency;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageAngleLimit;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.detectors.AbstractContingencyBlindDetector;
import java.util.function.Consumer;

public abstract class AbstractLimitViolationDetector
extends AbstractContingencyBlindDetector {
    @Override
    public void checkCurrent(Branch branch, Branch.Side side, double currentValue, Consumer<LimitViolation> consumer) {
        this.checkCurrent(null, branch, side, currentValue, consumer);
    }

    @Override
    public void checkVoltage(Bus bus, double voltageValue, Consumer<LimitViolation> consumer) {
        this.checkVoltage(null, bus, voltageValue, consumer);
    }

    @Override
    public void checkVoltageAngle(VoltageAngleLimit voltageAngleLimit, double voltageAngleDifference, Consumer<LimitViolation> consumer) {
        this.checkVoltageAngle(null, voltageAngleLimit, voltageAngleDifference, consumer);
    }

    @Override
    public void checkCurrent(Contingency contingency, Branch branch, Branch.Side side, Consumer<LimitViolation> consumer) {
        this.checkCurrent(contingency, branch, side, branch.getTerminal(side).getI(), consumer);
    }

    @Override
    public void checkVoltage(Contingency contingency, Bus bus, Consumer<LimitViolation> consumer) {
        this.checkVoltage(contingency, bus, bus.getV(), consumer);
    }

    @Override
    public void checkVoltageAngle(Contingency contingency, VoltageAngleLimit voltageAngleLimit, Consumer<LimitViolation> consumer) {
        Bus referenceBus = voltageAngleLimit.getTerminalFrom().getBusView().getBus();
        Bus otherBus = voltageAngleLimit.getTerminalTo().getBusView().getBus();
        if (referenceBus != null && otherBus != null && referenceBus.getConnectedComponent().getNum() == otherBus.getConnectedComponent().getNum() && referenceBus.getSynchronousComponent().getNum() == otherBus.getSynchronousComponent().getNum()) {
            double voltageAngleDifference = otherBus.getAngle() - referenceBus.getAngle();
            this.checkVoltageAngle(contingency, voltageAngleLimit, voltageAngleDifference, consumer);
        }
    }

    @Override
    public void checkVoltage(Contingency contingency, VoltageLevel voltageLevel, Consumer<LimitViolation> consumer) {
        voltageLevel.getBusView().getBusStream().forEach(b -> this.checkVoltage(contingency, (Bus)b, consumer));
    }

    @Override
    public void checkCurrent(Contingency contingency, Branch branch, Consumer<LimitViolation> consumer) {
        this.checkCurrent(contingency, branch, Branch.Side.ONE, consumer);
        this.checkCurrent(contingency, branch, Branch.Side.TWO, consumer);
    }

    @Override
    public void checkAll(Contingency contingency, Network network, Consumer<LimitViolation> consumer) {
        network.getBranchStream().forEach(b -> this.checkCurrent(contingency, (Branch)b, consumer));
        network.getVoltageLevelStream().flatMap(v -> v.getBusView().getBusStream()).forEach(b -> this.checkVoltage(contingency, (Bus)b, consumer));
        network.getVoltageAngleLimitsStream().forEach(valOk -> this.checkVoltageAngle(contingency, (VoltageAngleLimit)valOk, consumer));
    }
}

