/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.distributed;

import com.google.common.base.Preconditions;
import com.powsybl.commons.compress.ZipPackager;
import com.powsybl.computation.ComputationException;
import com.powsybl.computation.ComputationExceptionBuilder;
import com.powsybl.computation.ExecutionHandler;
import com.powsybl.computation.Partition;
import com.powsybl.security.SecurityAnalysisReport;
import com.powsybl.security.SecurityAnalysisResult;
import com.powsybl.security.SecurityAnalysisResultMerger;
import com.powsybl.security.distributed.SecurityAnalysisCommandOptions;
import com.powsybl.security.distributed.SecurityAnalysisExecutionHandler;
import com.powsybl.security.execution.SecurityAnalysisExecutionInput;
import com.powsybl.security.json.SecurityAnalysisResultDeserializer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class SecurityAnalysisExecutionHandlers {
    private static final String OUTPUT_FILE_FMT = "task_%d_result.json";
    private static final String OUTPUT_FILE = "result.json";
    private static final String SA_TASK_CMD_ID = "security-analysis-task";
    private static final String SA_CMD_ID = "security-analysis";
    private static final String TASK_COUNT_ERROR_MESSAGE = "Number of subtasks must be 1 or greather, was %s.";

    private SecurityAnalysisExecutionHandlers() {
    }

    public static ExecutionHandler<SecurityAnalysisReport> forwarded(SecurityAnalysisExecutionInput input) {
        return SecurityAnalysisExecutionHandlers.forwarded(input, null);
    }

    public static ExecutionHandler<SecurityAnalysisReport> forwarded(SecurityAnalysisExecutionInput input, Integer forwardedTaskCount) {
        Preconditions.checkArgument((forwardedTaskCount == null || forwardedTaskCount >= 1 ? 1 : 0) != 0, (String)TASK_COUNT_ERROR_MESSAGE, (Object)forwardedTaskCount);
        return new SecurityAnalysisExecutionHandler<SecurityAnalysisReport>(workingDir -> SecurityAnalysisExecutionHandlers.readSingleResult(workingDir, input.isWithLogs()), (workingDir, options) -> SecurityAnalysisExecutionHandlers.forwardedOptions(workingDir, options, forwardedTaskCount, input.isWithLogs()), SecurityAnalysisExecutionHandlers::generateExceptionWithLogs, 1, input);
    }

    public static ExecutionHandler<SecurityAnalysisReport> distributed(SecurityAnalysisExecutionInput input, int subtaskCount) {
        Preconditions.checkArgument((subtaskCount >= 1 ? 1 : 0) != 0, (String)TASK_COUNT_ERROR_MESSAGE, (int)subtaskCount);
        return new SecurityAnalysisExecutionHandler<SecurityAnalysisReport>(workingDir -> SecurityAnalysisExecutionHandlers.readResults(workingDir, subtaskCount, input.isWithLogs()), (workingDir, options) -> SecurityAnalysisExecutionHandlers.distributedOptions(workingDir, options, subtaskCount, input.isWithLogs()), (workingDir, cause) -> SecurityAnalysisExecutionHandlers.generateExceptionWithLogs(workingDir, cause, subtaskCount), subtaskCount, input);
    }

    public static SecurityAnalysisReport readSingleResult(Path workingDir, boolean withLogs) {
        Path taskResultFile = workingDir.resolve(OUTPUT_FILE);
        SecurityAnalysisResult re = SecurityAnalysisResultDeserializer.read(taskResultFile);
        SecurityAnalysisReport report = new SecurityAnalysisReport(re);
        if (withLogs) {
            ArrayList<String> collectedLogsFilename = new ArrayList<String>();
            collectedLogsFilename.add(workingDir.relativize(SecurityAnalysisExecutionHandlers.getLogPath(workingDir)).toString());
            collectedLogsFilename.add(SecurityAnalysisExecutionHandlers.saCmdOutLogName());
            collectedLogsFilename.add(SecurityAnalysisExecutionHandlers.saCmdErrLogName());
            byte[] logBytes = ZipPackager.archiveFilesToZipBytes((Path)workingDir, collectedLogsFilename);
            report.setLogBytes(logBytes);
        }
        return report;
    }

    private static String saCmdOutLogName() {
        return "security-analysis.out";
    }

    private static String saCmdErrLogName() {
        return "security-analysis.err";
    }

    public static void forwardedOptions(Path workingDir, SecurityAnalysisCommandOptions options, Integer taskCount, boolean withLogs) {
        options.outputFile(workingDir.resolve(OUTPUT_FILE), "JSON");
        if (taskCount != null) {
            options.taskCount(taskCount);
        }
        if (withLogs) {
            options.logFile(SecurityAnalysisExecutionHandlers.getLogPath(workingDir));
        }
    }

    public static void distributedOptions(Path workingDir, SecurityAnalysisCommandOptions options, int taskCount, boolean withLogs) {
        options.id(SA_TASK_CMD_ID);
        options.outputFile(i -> SecurityAnalysisExecutionHandlers.getOutputPathForTask(workingDir, i), "JSON");
        options.task(i -> new Partition(i + 1, taskCount));
        if (withLogs) {
            options.logFile(i -> SecurityAnalysisExecutionHandlers.getLogPathForTask(workingDir, i));
        }
    }

    public static Path getOutputPathForTask(Path workingDir, int taskIndex) {
        return workingDir.resolve(String.format(OUTPUT_FILE_FMT, taskIndex));
    }

    public static SecurityAnalysisReport readResults(Path workingDir, int subtaskCount, boolean withLogs) {
        List<SecurityAnalysisResult> results = IntStream.range(0, subtaskCount).mapToObj(taskIndex -> SecurityAnalysisExecutionHandlers.getOutputPathForTask(workingDir, taskIndex)).map(SecurityAnalysisResultDeserializer::read).collect(Collectors.toList());
        SecurityAnalysisResult re = SecurityAnalysisResultMerger.merge(results);
        SecurityAnalysisReport report = new SecurityAnalysisReport(re);
        if (withLogs) {
            ArrayList<String> collectedLogsFilename = new ArrayList<String>();
            for (int i = 0; i < subtaskCount; ++i) {
                collectedLogsFilename.add(workingDir.relativize(SecurityAnalysisExecutionHandlers.getLogPathForTask(workingDir, i)).toString());
                collectedLogsFilename.add(SecurityAnalysisExecutionHandlers.satOutName(i));
                collectedLogsFilename.add(SecurityAnalysisExecutionHandlers.satErrName(i));
            }
            byte[] logBytes = ZipPackager.archiveFilesToZipBytes((Path)workingDir, collectedLogsFilename);
            report.setLogBytes(logBytes);
        }
        return report;
    }

    private static ComputationException generateExceptionWithLogs(Path workingDir, Exception cause, int count) {
        ComputationExceptionBuilder ceb = new ComputationExceptionBuilder((Throwable)cause).message("An error occurred during security analysis command execution");
        IntStream.range(0, count).forEach(i -> {
            String outLogName = SecurityAnalysisExecutionHandlers.satOutName(i);
            String errLogName = SecurityAnalysisExecutionHandlers.satErrName(i);
            ceb.addOutLogIfExists(workingDir.resolve(outLogName)).addErrLogIfExists(workingDir.resolve(errLogName)).addFileIfExists(SecurityAnalysisExecutionHandlers.getLogPathForTask(workingDir, i));
        });
        return ceb.build();
    }

    private static ComputationException generateExceptionWithLogs(Path workingDir, Exception cause) {
        ComputationExceptionBuilder ceb = new ComputationExceptionBuilder((Throwable)cause).message("An error occurred during security analysis command execution");
        String outLogName = SecurityAnalysisExecutionHandlers.saCmdOutLogName();
        String errLogName = SecurityAnalysisExecutionHandlers.saCmdErrLogName();
        ceb.addOutLogIfExists(workingDir.resolve(outLogName)).addErrLogIfExists(workingDir.resolve(errLogName)).addFileIfExists(SecurityAnalysisExecutionHandlers.getLogPath(workingDir));
        return ceb.build();
    }

    private static String satErrName(int i) {
        return "security-analysis-task_" + i + ".err";
    }

    private static String satOutName(int i) {
        return "security-analysis-task_" + i + ".out";
    }

    public static Path getLogPathForTask(Path workingDir, int taskNumber) {
        return workingDir.resolve("logs_" + taskNumber + ".zip");
    }

    public static Path getLogPath(Path workingDir) {
        return workingDir.resolve("logs.zip");
    }
}

