/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.interceptors;

import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.network.Branch;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationType;
import com.powsybl.security.extensions.ActivePowerExtension;
import com.powsybl.security.extensions.CurrentExtension;
import com.powsybl.security.interceptors.DefaultSecurityAnalysisInterceptor;
import com.powsybl.security.interceptors.RunningContext;
import com.powsybl.security.interceptors.SecurityAnalysisResultContext;
import com.powsybl.security.results.PostContingencyResult;
import com.powsybl.security.results.PreContingencyResult;

public class CurrentLimitViolationInterceptor
extends DefaultSecurityAnalysisInterceptor {
    @Override
    public void onPreContingencyResult(PreContingencyResult preContingencyResult, SecurityAnalysisResultContext context) {
        for (LimitViolation limitViolation : preContingencyResult.getLimitViolationsResult().getLimitViolations()) {
            if (limitViolation.getLimitType() != LimitViolationType.CURRENT) continue;
            Branch branch = context.getNetwork().getBranch(limitViolation.getSubjectId());
            double preContingencyValue = branch.getTerminal(limitViolation.getSide()).getP();
            limitViolation.addExtension(ActivePowerExtension.class, new ActivePowerExtension(preContingencyValue));
        }
    }

    @Override
    public void onPostContingencyResult(PostContingencyResult postContingencyResult, SecurityAnalysisResultContext context) {
        String workingStateId = context.getNetwork().getVariantManager().getWorkingVariantId();
        if (context instanceof RunningContext) {
            RunningContext runningContext = (RunningContext)context;
            for (LimitViolation limitViolation : postContingencyResult.getLimitViolationsResult().getLimitViolations()) {
                if (limitViolation.getLimitType() != LimitViolationType.CURRENT) continue;
                Branch branch = context.getNetwork().getBranch(limitViolation.getSubjectId());
                context.getNetwork().getVariantManager().setWorkingVariant(runningContext.getInitialStateId());
                limitViolation.addExtension(CurrentExtension.class, (Extension)new CurrentExtension(branch.getTerminal(limitViolation.getSide()).getI()));
                double preContingencyValue = branch.getTerminal(limitViolation.getSide()).getP();
                context.getNetwork().getVariantManager().setWorkingVariant(workingStateId);
                double postContingencyValue = branch.getTerminal(limitViolation.getSide()).getP();
                limitViolation.addExtension(ActivePowerExtension.class, new ActivePowerExtension(preContingencyValue, postContingencyValue));
            }
        }
    }
}

