/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.common.base.Suppliers;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.commons.extensions.ExtensionProviders;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.security.results.BranchResult;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public class BranchResultDeserializer
extends StdDeserializer<BranchResult> {
    private static final Supplier<ExtensionProviders<ExtensionJsonSerializer>> SUPPLIER = Suppliers.memoize(() -> ExtensionProviders.createProvider(ExtensionJsonSerializer.class, (String)"security-analysis"));

    public BranchResultDeserializer() {
        super(BranchResult.class);
    }

    public BranchResult deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ParsingContext context = new ParsingContext();
        JsonUtil.parseObject((JsonParser)jsonParser, name -> {
            switch (name) {
                case "branchId": {
                    context.branchId = jsonParser.nextTextValue();
                    return true;
                }
                case "p1": {
                    jsonParser.nextToken();
                    context.p1 = jsonParser.getValueAsDouble();
                    return true;
                }
                case "q1": {
                    jsonParser.nextToken();
                    context.q1 = jsonParser.getValueAsDouble();
                    return true;
                }
                case "i1": {
                    jsonParser.nextToken();
                    context.i1 = jsonParser.getValueAsDouble();
                    return true;
                }
                case "p2": {
                    jsonParser.nextToken();
                    context.p2 = jsonParser.getValueAsDouble();
                    return true;
                }
                case "q2": {
                    jsonParser.nextToken();
                    context.q2 = jsonParser.getValueAsDouble();
                    return true;
                }
                case "i2": {
                    jsonParser.nextToken();
                    context.i2 = jsonParser.getValueAsDouble();
                    return true;
                }
                case "flowTransfer": {
                    jsonParser.nextToken();
                    context.flowTransfer = jsonParser.getValueAsDouble();
                    return true;
                }
                case "extensions": {
                    jsonParser.nextToken();
                    context.extensions = JsonUtil.readExtensions((JsonParser)jsonParser, (DeserializationContext)deserializationContext, SUPPLIER.get());
                    break;
                }
                default: {
                    return false;
                }
            }
            return false;
        });
        BranchResult branchResult = new BranchResult(context.branchId, context.p1, context.q1, context.i1, context.p2, context.q2, context.i2, context.flowTransfer);
        SUPPLIER.get().addExtensions((Extendable)branchResult, context.extensions);
        return branchResult;
    }

    private static class ParsingContext {
        String branchId;
        double p1 = Double.NaN;
        double q1 = Double.NaN;
        double i1 = Double.NaN;
        double p2 = Double.NaN;
        double q2 = Double.NaN;
        double i2 = Double.NaN;
        double flowTransfer = Double.NaN;
        List<Extension<BranchResult>> extensions = Collections.emptyList();

        private ParsingContext() {
        }
    }
}

