/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.security.condition.AbstractFilteredCondition;
import com.powsybl.security.condition.AllViolationCondition;
import com.powsybl.security.condition.AtLeastOneViolationCondition;
import com.powsybl.security.condition.Condition;
import java.io.IOException;

public class ConditionSerializer
extends StdSerializer<Condition> {
    public ConditionSerializer() {
        super(Condition.class);
    }

    public void serialize(Condition condition, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", condition.getType());
        switch (condition.getType()) {
            case "ALL_VIOLATION": {
                this.serializeFilters((AbstractFilteredCondition)condition, jsonGenerator, serializerProvider);
                serializerProvider.defaultSerializeField("violationIds", ((AllViolationCondition)condition).getViolationIds(), jsonGenerator);
                break;
            }
            case "AT_LEAST_ONE_VIOLATION": {
                this.serializeFilters((AbstractFilteredCondition)condition, jsonGenerator, serializerProvider);
                serializerProvider.defaultSerializeField("violationIds", ((AtLeastOneViolationCondition)condition).getViolationIds(), jsonGenerator);
                break;
            }
            case "TRUE_CONDITION": {
                break;
            }
            case "ANY_VIOLATION_CONDITION": {
                this.serializeFilters((AbstractFilteredCondition)condition, jsonGenerator, serializerProvider);
                break;
            }
            default: {
                throw new IllegalArgumentException("condition type '" + condition.getType() + "' does not exist");
            }
        }
        jsonGenerator.writeEndObject();
    }

    public void serializeFilters(AbstractFilteredCondition filteredCondition, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (!filteredCondition.getFilters().isEmpty()) {
            serializerProvider.defaultSerializeField("filters", filteredCondition.getFilters(), jsonGenerator);
        }
    }
}

