/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.security.LimitViolationsResult;
import com.powsybl.security.PostContingencyComputationStatus;
import com.powsybl.security.results.NetworkResult;
import com.powsybl.security.results.OperatorStrategyResult;
import com.powsybl.security.strategy.OperatorStrategy;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;

public class OperatorStrategyResultDeserializer
extends StdDeserializer<OperatorStrategyResult> {
    private static final String CONTEXT_NAME = "OperatorStrategyResult";

    public OperatorStrategyResultDeserializer() {
        super(OperatorStrategyResult.class);
    }

    public OperatorStrategyResult deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        OperatorStrategy operatorStrategy = null;
        LimitViolationsResult limitViolationsResult = null;
        NetworkResult networkResult = null;
        PostContingencyComputationStatus status = null;
        String version = JsonUtil.getSourceVersion((DatabindContext)deserializationContext, (String)"sourceVersionAttribute");
        if (version == null) {
            version = "1.5";
        }
        block12: while (parser.nextToken() != JsonToken.END_OBJECT) {
            switch (parser.getCurrentName()) {
                case "operatorStrategy": {
                    parser.nextToken();
                    operatorStrategy = (OperatorStrategy)((Object)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, OperatorStrategy.class));
                    continue block12;
                }
                case "limitViolationsResult": {
                    parser.nextToken();
                    limitViolationsResult = (LimitViolationsResult)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, LimitViolationsResult.class);
                    continue block12;
                }
                case "networkResult": {
                    parser.nextToken();
                    networkResult = (NetworkResult)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, NetworkResult.class);
                    continue block12;
                }
                case "status": {
                    parser.nextToken();
                    status = (PostContingencyComputationStatus)((Object)JsonUtil.readValue((DeserializationContext)deserializationContext, (JsonParser)parser, PostContingencyComputationStatus.class));
                    JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)CONTEXT_NAME, (String)"Tag: contingencyStatus", (String)version, (String)"1.3");
                    continue block12;
                }
            }
            throw new JsonMappingException((Closeable)parser, "Unexpected field: " + parser.getCurrentName());
        }
        if (version.compareTo("1.3") < 0) {
            Objects.requireNonNull(limitViolationsResult);
            return new OperatorStrategyResult(operatorStrategy, limitViolationsResult.isComputationOk() ? PostContingencyComputationStatus.CONVERGED : PostContingencyComputationStatus.FAILED, limitViolationsResult, networkResult);
        }
        return new OperatorStrategyResult(operatorStrategy, status, limitViolationsResult, networkResult);
    }
}

