/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json.action;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.security.action.AbstractTapChangerTapPositionAction;
import java.io.IOException;

public abstract class AbstractTapChangerTapPositionActionDeserializer<T extends AbstractTapChangerTapPositionAction>
extends StdDeserializer<T> {
    protected AbstractTapChangerTapPositionActionDeserializer(Class<T> vc) {
        super(vc);
    }

    protected boolean deserializeCommonAttributes(JsonParser jsonParser, ParsingContext context, String name, String version) throws IOException {
        switch (name) {
            case "id": {
                context.id = jsonParser.nextTextValue();
                return true;
            }
            case "transformerId": {
                context.transformerId = jsonParser.nextTextValue();
                return true;
            }
            case "value": {
                JsonUtil.assertLessThanOrEqualToReferenceVersion((String)"actions", (String)"Tag: value", (String)version, (String)"1.0");
                jsonParser.nextToken();
                context.tapPosition = jsonParser.getValueAsInt();
                return true;
            }
            case "tapPosition": {
                JsonUtil.assertGreaterOrEqualThanReferenceVersion((String)"actions", (String)"Tag: tapPosition", (String)version, (String)"1.1");
                jsonParser.nextToken();
                context.tapPosition = jsonParser.getValueAsInt();
                return true;
            }
            case "relativeValue": {
                jsonParser.nextToken();
                context.relativeValue = jsonParser.getValueAsBoolean();
                return true;
            }
            case "side": {
                context.side = ThreeWindingsTransformer.Side.valueOf((String)jsonParser.nextTextValue());
                return true;
            }
        }
        return false;
    }

    protected void checkFields(ParsingContext context, JsonParser jsonParser) throws JsonMappingException {
        if (context.relativeValue == null) {
            throw JsonMappingException.from((JsonParser)jsonParser, (String)"for phase tap changer tap position action relative value field can't be null");
        }
    }

    protected static class ParsingContext {
        String id;
        String transformerId;
        int tapPosition;
        Boolean relativeValue;
        ThreeWindingsTransformer.Side side = null;

        protected ParsingContext() {
        }
    }
}

