/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json.action;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.security.action.LineConnectionAction;
import java.io.IOException;

public class LineConnectionActionDeserializer
extends StdDeserializer<LineConnectionAction> {
    public LineConnectionActionDeserializer() {
        super(LineConnectionAction.class);
    }

    public LineConnectionAction deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ParsingContext context = new ParsingContext();
        JsonUtil.parsePolymorphicObject((JsonParser)jsonParser, name -> {
            switch (name) {
                case "type": {
                    if (!"LINE_CONNECTION".equals(jsonParser.nextTextValue())) {
                        throw JsonMappingException.from((JsonParser)jsonParser, (String)"Expected type LINE_CONNECTION");
                    }
                    return true;
                }
                case "id": {
                    context.id = jsonParser.nextTextValue();
                    return true;
                }
                case "lineId": {
                    context.lineId = jsonParser.nextTextValue();
                    return true;
                }
                case "openSide1": {
                    jsonParser.nextToken();
                    context.openSide1 = jsonParser.getValueAsBoolean();
                    return true;
                }
                case "openSide2": {
                    jsonParser.nextToken();
                    context.openSide2 = jsonParser.getValueAsBoolean();
                    return true;
                }
            }
            return false;
        });
        if (context.openSide1 == null || context.openSide2 == null) {
            throw JsonMappingException.from((JsonParser)jsonParser, (String)"for line action openSide1 and openSide2 fields can't be null");
        }
        return new LineConnectionAction(context.id, context.lineId, context.openSide1, context.openSide2);
    }

    private static class ParsingContext {
        String id;
        String lineId;
        Boolean openSide1;
        Boolean openSide2;

        private ParsingContext() {
        }
    }
}

