/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.monitor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.contingency.ContingencyContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class StateMonitor {
    private final ContingencyContext contingencyContext;
    private final Set<String> branchIds = new LinkedHashSet<String>();
    private final Set<String> voltageLevelIds = new LinkedHashSet<String>();
    private final Set<String> threeWindingsTransformerIds = new LinkedHashSet<String>();

    public ContingencyContext getContingencyContext() {
        return this.contingencyContext;
    }

    public Set<String> getBranchIds() {
        return this.branchIds;
    }

    public Set<String> getVoltageLevelIds() {
        return this.voltageLevelIds;
    }

    public Set<String> getThreeWindingsTransformerIds() {
        return this.threeWindingsTransformerIds;
    }

    public StateMonitor(@JsonProperty(value="contingencyContext") ContingencyContext contingencyContext, @JsonProperty(value="branchIds") Set<String> branchIds, @JsonProperty(value="voltageLevelIds") Set<String> voltageLevelIds, @JsonProperty(value="threeWindingsTransformerIds") Set<String> threeWindingsTransformerIds) {
        this.contingencyContext = Objects.requireNonNull(contingencyContext);
        this.branchIds.addAll((Collection<String>)Objects.requireNonNull(branchIds));
        this.voltageLevelIds.addAll((Collection<String>)Objects.requireNonNull(voltageLevelIds));
        this.threeWindingsTransformerIds.addAll((Collection<String>)Objects.requireNonNull(threeWindingsTransformerIds));
    }

    public StateMonitor merge(StateMonitor monitorTobeMerged) {
        this.branchIds.addAll(monitorTobeMerged.getBranchIds());
        this.voltageLevelIds.addAll(monitorTobeMerged.getVoltageLevelIds());
        this.threeWindingsTransformerIds.addAll(monitorTobeMerged.getThreeWindingsTransformerIds());
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateMonitor that = (StateMonitor)o;
        return Objects.equals(this.contingencyContext, that.contingencyContext) && Objects.equals(this.branchIds, that.branchIds) && Objects.equals(this.voltageLevelIds, that.voltageLevelIds) && Objects.equals(this.threeWindingsTransformerIds, that.threeWindingsTransformerIds);
    }

    public int hashCode() {
        return Objects.hash(this.contingencyContext, this.branchIds, this.voltageLevelIds, this.threeWindingsTransformerIds);
    }

    public String toString() {
        return "StateMonitor{contingencyContext=" + this.contingencyContext + ", branchIds=" + this.branchIds + ", voltageLevelIds=" + this.voltageLevelIds + ", threeWindingsTransformerIds=" + this.threeWindingsTransformerIds + "}";
    }

    public static void write(List<StateMonitor> monitors, Path jsonFile) {
        try {
            OutputStream out = Files.newOutputStream(jsonFile, new OpenOption[0]);
            JsonUtil.createObjectMapper().writer().writeValue(out, monitors);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static List<StateMonitor> read(Path jsonFile) {
        try {
            return (List)JsonUtil.createObjectMapper().readerFor((TypeReference)new TypeReference<List<StateMonitor>>(){}).readValue(Files.newInputStream(jsonFile, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

