/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.action;

import com.powsybl.security.action.AbstractAction;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;

public class GeneratorAction
extends AbstractAction {
    public static final String NAME = "GENERATOR";
    private final String generatorId;
    private final Boolean activePowerRelativeValue;
    private final Double activePowerValue;
    private final Boolean voltageRegulatorOn;
    private final Double targetV;
    private final Double targetQ;

    GeneratorAction(String id, String generatorId, Boolean activePowerRelativeValue, Double activePowerValue, Boolean voltageRegulatorOn, Double targetV, Double targetQ) {
        super(id);
        this.generatorId = Objects.requireNonNull(generatorId);
        this.activePowerRelativeValue = activePowerRelativeValue;
        this.activePowerValue = activePowerValue;
        this.voltageRegulatorOn = voltageRegulatorOn;
        this.targetV = targetV;
        this.targetQ = targetQ;
    }

    @Override
    public String getType() {
        return NAME;
    }

    public String getGeneratorId() {
        return this.generatorId;
    }

    public Optional<Boolean> isActivePowerRelativeValue() {
        return Optional.ofNullable(this.activePowerRelativeValue);
    }

    public OptionalDouble getActivePowerValue() {
        return this.activePowerValue == null ? OptionalDouble.empty() : OptionalDouble.of(this.activePowerValue);
    }

    public Optional<Boolean> isVoltageRegulatorOn() {
        return Optional.ofNullable(this.voltageRegulatorOn);
    }

    public OptionalDouble getTargetV() {
        return this.targetV == null ? OptionalDouble.empty() : OptionalDouble.of(this.targetV);
    }

    public OptionalDouble getTargetQ() {
        return this.targetQ == null ? OptionalDouble.empty() : OptionalDouble.of(this.targetQ);
    }
}

