/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.action;

import com.powsybl.security.action.LoadAction;

public class LoadActionBuilder {
    private String id;
    private String loadId;
    private Boolean relativeValue;
    private Double activePowerValue;
    private Double reactivePowerValue;

    public LoadAction build() {
        if (this.relativeValue == null) {
            throw new IllegalArgumentException("For a load action, relativeValue must be provided");
        }
        if (this.activePowerValue == null && this.reactivePowerValue == null) {
            throw new IllegalArgumentException("For a load action, activePowerValue or reactivePowerValue must be provided");
        }
        return new LoadAction(this.id, this.loadId, this.relativeValue, this.activePowerValue, this.reactivePowerValue);
    }

    public LoadActionBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public LoadActionBuilder withLoadId(String loadId) {
        this.loadId = loadId;
        return this;
    }

    public LoadActionBuilder withRelativeValue(boolean relativeValue) {
        this.relativeValue = relativeValue;
        return this;
    }

    public LoadActionBuilder withActivePowerValue(double activePowerValue) {
        this.activePowerValue = activePowerValue;
        return this;
    }

    public LoadActionBuilder withReactivePowerValue(double reactivePowerValue) {
        this.reactivePowerValue = reactivePowerValue;
        return this;
    }
}

