/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.json.action;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.security.action.Action;
import com.powsybl.security.action.ActionList;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;

public class ActionListDeserializer
extends StdDeserializer<ActionList> {
    public static final String VERSION = "version";

    public ActionListDeserializer() {
        super(ActionList.class);
    }

    public ActionList deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        ParsingContext context = new ParsingContext();
        JsonUtil.parseObject((JsonParser)parser, fieldName -> {
            switch (fieldName) {
                case "version": {
                    context.version = parser.nextTextValue();
                    deserializationContext.setAttribute((Object)VERSION, (Object)context.version);
                    return true;
                }
                case "actions": {
                    parser.nextToken();
                    context.actions = JsonUtil.readList((DeserializationContext)deserializationContext, (JsonParser)parser, Action.class);
                    return true;
                }
            }
            return false;
        });
        if (context.version == null) {
            throw new JsonMappingException((Closeable)parser, "version is missing");
        }
        JsonUtil.assertLessThanOrEqualToReferenceVersion((String)"actions", (String)"Tag: tapPosition", (String)context.version, (String)"1.1");
        return new ActionList(context.actions);
    }

    private static class ParsingContext {
        String version;
        List<Action> actions;

        private ParsingContext() {
        }
    }
}

