/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.monitor;

import com.powsybl.contingency.ContingencyContext;
import com.powsybl.contingency.ContingencyContextType;
import com.powsybl.security.monitor.StateMonitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class StateMonitorIndex {
    private final StateMonitor allStateMonitor;
    private final StateMonitor noneStateMonitor;
    private final Map<String, StateMonitor> specificStateMonitors = new HashMap<String, StateMonitor>();

    public StateMonitorIndex(List<StateMonitor> stateMonitors) {
        this.allStateMonitor = new StateMonitor(new ContingencyContext(null, ContingencyContextType.ALL), new HashSet<String>(), new HashSet<String>(), new HashSet<String>());
        this.noneStateMonitor = new StateMonitor(new ContingencyContext(null, ContingencyContextType.NONE), new HashSet<String>(), new HashSet<String>(), new HashSet<String>());
        stateMonitors.forEach(monitor -> {
            String id = monitor.getContingencyContext().getContingencyId();
            if (id != null) {
                this.specificStateMonitors.merge(id, (StateMonitor)monitor, StateMonitor::merge);
            } else if (monitor.getContingencyContext().getContextType() == ContingencyContextType.ALL) {
                this.allStateMonitor.merge((StateMonitor)monitor);
            } else if (monitor.getContingencyContext().getContextType() == ContingencyContextType.NONE) {
                this.noneStateMonitor.merge((StateMonitor)monitor);
            }
        });
    }

    public StateMonitor getAllStateMonitor() {
        return this.allStateMonitor;
    }

    public StateMonitor getNoneStateMonitor() {
        return this.noneStateMonitor;
    }

    public Map<String, StateMonitor> getSpecificStateMonitors() {
        return this.specificStateMonitors;
    }
}

