/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.tools;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.io.FileUtil;
import com.powsybl.commons.io.table.AsciiTableFormatterFactory;
import com.powsybl.commons.io.table.TableFormatterConfig;
import com.powsybl.commons.io.table.TableFormatterFactory;
import com.powsybl.computation.ComputationException;
import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.Partition;
import com.powsybl.contingency.ContingenciesProviders;
import com.powsybl.iidm.network.ImportConfig;
import com.powsybl.iidm.network.ImportersLoader;
import com.powsybl.iidm.network.ImportersServiceLoader;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.tools.ConversionToolUtils;
import com.powsybl.loadflow.LoadFlowResult;
import com.powsybl.security.LimitViolationFilter;
import com.powsybl.security.LimitViolationType;
import com.powsybl.security.Security;
import com.powsybl.security.SecurityAnalysisInput;
import com.powsybl.security.SecurityAnalysisParameters;
import com.powsybl.security.SecurityAnalysisReport;
import com.powsybl.security.SecurityAnalysisResult;
import com.powsybl.security.action.ActionList;
import com.powsybl.security.converter.SecurityAnalysisResultExporters;
import com.powsybl.security.distributed.ExternalSecurityAnalysisConfig;
import com.powsybl.security.execution.SecurityAnalysisExecution;
import com.powsybl.security.execution.SecurityAnalysisExecutionBuilder;
import com.powsybl.security.execution.SecurityAnalysisExecutionInput;
import com.powsybl.security.execution.SecurityAnalysisInputBuildStrategy;
import com.powsybl.security.interceptors.SecurityAnalysisInterceptors;
import com.powsybl.security.json.JsonSecurityAnalysisParameters;
import com.powsybl.security.monitor.StateMonitor;
import com.powsybl.security.preprocessor.SecurityAnalysisPreprocessorFactory;
import com.powsybl.security.preprocessor.SecurityAnalysisPreprocessors;
import com.powsybl.security.strategy.OperatorStrategyList;
import com.powsybl.tools.Command;
import com.powsybl.tools.Tool;
import com.powsybl.tools.ToolOptions;
import com.powsybl.tools.ToolRunningContext;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

@AutoService(value={Tool.class})
public class SecurityAnalysisTool
implements Tool {
    public Command getCommand() {
        return new Command(){

            public String getName() {
                return "security-analysis";
            }

            public String getTheme() {
                return "Computation";
            }

            public String getDescription() {
                return "Run security analysis";
            }

            public Options getOptions() {
                Options options = new Options();
                options.addOption(Option.builder().longOpt("case-file").desc("the case path").hasArg().argName("FILE").required().build());
                options.addOption(Option.builder().longOpt("parameters-file").desc("loadflow parameters as JSON file").hasArg().argName("FILE").build());
                options.addOption(Option.builder().longOpt("limit-types").desc("limit type filter (all if not set)").hasArg().argName("LIMIT-TYPES").build());
                options.addOption(Option.builder().longOpt("output-file").desc("the output path").hasArg().argName("FILE").build());
                options.addOption(Option.builder().longOpt("output-format").desc("the output format " + SecurityAnalysisResultExporters.getFormats()).hasArg().argName("FORMAT").build());
                options.addOption(Option.builder().longOpt("contingencies-file").desc("the contingencies path").hasArg().argName("FILE").build());
                options.addOption(Option.builder().longOpt("with-extensions").desc("the extension list to enable").hasArg().argName("EXTENSIONS").build());
                options.addOption(Option.builder().longOpt("task-count").desc("number of tasks used for parallelization").hasArg().argName("NTASKS").build());
                options.addOption(Option.builder().longOpt("task").desc("task identifier (task-index/task-count)").hasArg().argName("TASKID").build());
                options.addOption(Option.builder().longOpt("external").desc("external execution").build());
                options.addOption(ConversionToolUtils.createImportParametersFileOption());
                options.addOption(ConversionToolUtils.createImportParameterOption());
                options.addOption(Option.builder().longOpt("log-file").desc("log output path (.zip)").hasArg().argName("FILE").build());
                options.addOption(Option.builder().longOpt("monitoring-file").desc("monitoring file (.json) to get network's infos after computation").hasArg().argName("FILE").build());
                return options;
            }

            public String getUsageFooter() {
                return String.join((CharSequence)System.lineSeparator(), "Allowed LIMIT-TYPES values are " + Arrays.toString((Object[])LimitViolationType.values()), "Allowed EXTENSIONS values are " + SecurityAnalysisInterceptors.getExtensionNames());
            }
        };
    }

    static void updateInput(ToolOptions options, SecurityAnalysisExecutionInput inputs) {
        options.getPath("parameters-file").ifPresent(f -> JsonSecurityAnalysisParameters.update(inputs.getParameters(), f));
        options.getPath("contingencies-file").map(x$0 -> FileUtil.asByteSource((Path)x$0, (OpenOption[])new OpenOption[0])).ifPresent(inputs::setContingenciesSource);
        options.getValues("limit-types").map(types -> types.stream().map(LimitViolationType::valueOf).collect(Collectors.toList())).ifPresent(inputs::addViolationTypes);
        options.getValues("with-extensions").ifPresent(inputs::addResultExtensions);
        options.getValues("log-file").ifPresent(f -> inputs.setWithLogs(true));
    }

    private static SecurityAnalysisInputBuildStrategy configBasedInputBuildStrategy(PlatformConfig config) {
        return SecurityAnalysisTool.preprocessedInputBuildStrategy(() -> LimitViolationFilter.load(config), SecurityAnalysisPreprocessors.configuredFactory(config).orElseGet(() -> SecurityAnalysisPreprocessors.wrap(ContingenciesProviders.newDefaultFactory((PlatformConfig)config))));
    }

    private static SecurityAnalysisInputBuildStrategy preprocessedInputBuildStrategy(Supplier<LimitViolationFilter> filterInitializer, SecurityAnalysisPreprocessorFactory preprocessorFactory) {
        return executionInput -> SecurityAnalysisTool.buildPreprocessedInput(executionInput, filterInitializer, preprocessorFactory);
    }

    static SecurityAnalysisInput buildPreprocessedInput(SecurityAnalysisExecutionInput executionInput, Supplier<LimitViolationFilter> filterInitializer, SecurityAnalysisPreprocessorFactory preprocessorFactory) {
        SecurityAnalysisInput input = new SecurityAnalysisInput(executionInput.getNetworkVariant()).setParameters(executionInput.getParameters()).setFilter(filterInitializer.get());
        executionInput.getResultExtensions().stream().map(SecurityAnalysisInterceptors::createInterceptor).forEach(input::addInterceptor);
        if (!executionInput.getViolationTypes().isEmpty()) {
            input.getFilter().setViolationTypes((Set<LimitViolationType>)ImmutableSet.copyOf(executionInput.getViolationTypes()));
        }
        executionInput.getContingenciesSource().map(preprocessorFactory::newPreprocessor).ifPresent(p -> p.preprocess(input));
        return input;
    }

    private static SecurityAnalysisExecutionBuilder createBuilder(PlatformConfig platformConfig) {
        String providerName = platformConfig.getOptionalModuleConfig("security-analysis").flatMap(c -> c.getOptionalStringProperty("default-impl-name")).orElse(null);
        return new SecurityAnalysisExecutionBuilder(() -> ExternalSecurityAnalysisConfig.load(platformConfig), providerName, SecurityAnalysisTool.configBasedInputBuildStrategy(platformConfig));
    }

    private static SecurityAnalysisExecution buildExecution(ToolOptions options, SecurityAnalysisExecutionBuilder builder) {
        builder.forward(options.hasOption("external"));
        options.getInt("task-count").ifPresent(builder::distributed);
        options.getValue("task", Partition::parse).ifPresent(builder::subTask);
        return builder.build();
    }

    private static SecurityAnalysisReport runSecurityAnalysisWithLog(ComputationManager computationManager, SecurityAnalysisExecution execution, SecurityAnalysisExecutionInput input, Path logPath) {
        try {
            SecurityAnalysisReport report = execution.execute(computationManager, input).join();
            report.getLogBytes().ifPresent(logBytes -> SecurityAnalysisTool.uncheckedWriteBytes(logBytes, logPath));
            return report;
        }
        catch (CompletionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof ComputationException) {
                ComputationException computationException = (ComputationException)throwable;
                byte[] bytes = computationException.toZipBytes();
                SecurityAnalysisTool.uncheckedWriteBytes(bytes, logPath);
            }
            throw e;
        }
    }

    static Network readNetwork(CommandLine line, ToolRunningContext context, ImportersLoader importersLoader) throws IOException {
        ToolOptions options = new ToolOptions(line, context);
        Path caseFile = (Path)options.getPath("case-file").orElseThrow(IllegalStateException::new);
        Properties inputParams = ConversionToolUtils.readProperties((CommandLine)line, (ConversionToolUtils.OptionType)ConversionToolUtils.OptionType.IMPORT, (ToolRunningContext)context);
        context.getOutputStream().println("Loading network '" + caseFile + "'");
        Network network = Network.read((Path)caseFile, (ComputationManager)context.getShortTimeExecutionComputationManager(), (ImportConfig)ImportConfig.load(), (Properties)inputParams, (ImportersLoader)importersLoader);
        network.getVariantManager().allowVariantMultiThreadAccess(true);
        return network;
    }

    private static void uncheckedWriteBytes(byte[] bytes, Path path) {
        try {
            Files.write(path, bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void run(CommandLine line, ToolRunningContext context) throws Exception {
        this.run(line, context, SecurityAnalysisTool.createBuilder(PlatformConfig.defaultConfig()), SecurityAnalysisParameters::load, (ImportersLoader)new ImportersServiceLoader(), TableFormatterConfig::load);
    }

    void run(CommandLine line, ToolRunningContext context, SecurityAnalysisExecutionBuilder executionBuilder, Supplier<SecurityAnalysisParameters> parametersLoader, ImportersLoader importersLoader, Supplier<TableFormatterConfig> tableFormatterConfigLoader) throws Exception {
        ToolOptions options = new ToolOptions(line, context);
        Path outputFile = options.getPath("output-file").orElse(null);
        String format = null;
        if (outputFile != null) {
            format = (String)options.getValue("output-format").orElseThrow(() -> new ParseException("Missing required option: output-format"));
        }
        Network network = SecurityAnalysisTool.readNetwork(line, context, importersLoader);
        SecurityAnalysisExecutionInput executionInput = new SecurityAnalysisExecutionInput().setNetworkVariant(network, "InitialState").setParameters(parametersLoader.get());
        options.getPath("monitoring-file").ifPresent(monitorFilePath -> executionInput.setMonitors(StateMonitor.read(monitorFilePath)));
        options.getPath("strategies-file").ifPresent(operatorStrategyFilePath -> executionInput.setOperatorStrategies(OperatorStrategyList.read(operatorStrategyFilePath).getOperatorStrategies()));
        options.getPath("actions-file").ifPresent(actionFilePath -> executionInput.setActions(ActionList.readJsonFile(actionFilePath).getActions()));
        SecurityAnalysisTool.updateInput(options, executionInput);
        SecurityAnalysisExecution execution = SecurityAnalysisTool.buildExecution(options, executionBuilder);
        ComputationManager computationManager = options.hasOption("task") ? context.getShortTimeExecutionComputationManager() : context.getLongTimeExecutionComputationManager();
        SecurityAnalysisReport report = options.getPath("log-file").map(logPath -> SecurityAnalysisTool.runSecurityAnalysisWithLog(computationManager, execution, executionInput, logPath)).orElseGet(() -> execution.execute(computationManager, executionInput).join());
        SecurityAnalysisResult result = report.getResult();
        if (result.getPreContingencyResult().getStatus() != LoadFlowResult.ComponentResult.Status.CONVERGED) {
            context.getErrorStream().println("Pre-contingency state divergence");
        }
        if (outputFile != null) {
            context.getOutputStream().println("Writing results to '" + outputFile + "'");
            SecurityAnalysisResultExporters.export(result, outputFile, format);
        } else {
            OutputStreamWriter writer = new OutputStreamWriter(context.getOutputStream());
            Security.print(result, network, (Writer)writer, (TableFormatterFactory)new AsciiTableFormatterFactory(), tableFormatterConfigLoader.get());
        }
    }
}

