/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationType;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class LimitViolationBuilder {
    private String subjectId;
    private String subjectName;
    private LimitViolationType type;
    private Double limit;
    private String limitName;
    private Integer duration;
    private float reduction = 1.0f;
    private Double value;
    private ThreeSides side;

    public LimitViolationBuilder type(LimitViolationType type) {
        this.type = Objects.requireNonNull(type);
        return this;
    }

    public LimitViolationBuilder subject(String subjectId) {
        this.subjectId = Objects.requireNonNull(subjectId);
        return this;
    }

    public LimitViolationBuilder subjectName(String subjectName) {
        this.subjectName = subjectName;
        return this;
    }

    public LimitViolationBuilder limitName(String name) {
        this.limitName = name;
        return this;
    }

    public LimitViolationBuilder duration(int duration) {
        this.duration = duration;
        return this;
    }

    public LimitViolationBuilder duration(int duration, TimeUnit unit) {
        this.duration = (int)unit.toSeconds(duration);
        return this;
    }

    public LimitViolationBuilder limit(double limit) {
        this.limit = limit;
        return this;
    }

    public LimitViolationBuilder value(double value) {
        this.value = value;
        return this;
    }

    public LimitViolationBuilder reduction(float reduction) {
        this.reduction = reduction;
        return this;
    }

    public LimitViolationBuilder side(ThreeSides side) {
        this.side = Objects.requireNonNull(side);
        return this;
    }

    public LimitViolationBuilder side(TwoSides side) {
        return this.side(Objects.requireNonNull(side).toThreeSides());
    }

    public LimitViolationBuilder side1() {
        return this.side(TwoSides.ONE);
    }

    public LimitViolationBuilder side2() {
        return this.side(TwoSides.TWO);
    }

    public LimitViolationBuilder current() {
        return this.type(LimitViolationType.CURRENT);
    }

    public LimitViolation build() {
        Objects.requireNonNull(this.type);
        Objects.requireNonNull(this.limit, "Violated limit value must be defined.");
        Objects.requireNonNull(this.value, "Violation value must be defined.");
        switch (this.type) {
            case ACTIVE_POWER: 
            case APPARENT_POWER: 
            case CURRENT: {
                Objects.requireNonNull(this.duration, "Acceptable duration must be defined.");
                Objects.requireNonNull(this.side, "Violation side must be defined.");
                return new LimitViolation(this.subjectId, this.subjectName, this.type, this.limitName, (int)this.duration, (double)this.limit, this.reduction, (double)this.value, this.side);
            }
            case LOW_VOLTAGE: 
            case HIGH_VOLTAGE: 
            case LOW_SHORT_CIRCUIT_CURRENT: 
            case HIGH_SHORT_CIRCUIT_CURRENT: 
            case LOW_VOLTAGE_ANGLE: 
            case HIGH_VOLTAGE_ANGLE: {
                return new LimitViolation(this.subjectId, this.subjectName, this.type, this.limitName, Integer.MAX_VALUE, this.limit, this.reduction, this.value);
            }
        }
        throw new UnsupportedOperationException(String.format("Building %s limits is not supported.", this.type.name()));
    }
}

