/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.powsybl.commons.PowsyblException;
import com.powsybl.contingency.Contingency;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Overload;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.VoltageAngleLimit;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.util.LimitViolationUtils;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationType;
import java.util.function.Consumer;

public interface LimitViolationDetector {
    default public void checkCurrent(Contingency contingency, Branch branch, TwoSides side, double currentValue, Consumer<LimitViolation> consumer) {
        this.checkCurrent(branch, side, currentValue, consumer);
    }

    default public void checkCurrent(Contingency contingency, ThreeWindingsTransformer transformer, ThreeSides side, double currentValue, Consumer<LimitViolation> consumer) {
        this.checkCurrent(transformer, side, currentValue, consumer);
    }

    default public void checkCurrent(Contingency contingency, Branch branch, TwoSides side, Consumer<LimitViolation> consumer) {
        this.checkCurrent(branch, side, consumer);
    }

    default public void checkCurrent(Contingency contingency, ThreeWindingsTransformer transformer, ThreeSides side, Consumer<LimitViolation> consumer) {
        this.checkCurrent(transformer, side, consumer);
    }

    default public void checkVoltage(Contingency contingency, Bus bus, double voltageValue, Consumer<LimitViolation> consumer) {
        this.checkVoltage(bus, voltageValue, consumer);
    }

    default public void checkVoltage(Contingency contingency, Bus bus, Consumer<LimitViolation> consumer) {
        this.checkVoltage(bus, consumer);
    }

    default public void checkVoltage(Contingency contingency, VoltageLevel voltageLevel, Consumer<LimitViolation> consumer) {
        this.checkVoltage(voltageLevel, consumer);
    }

    default public void checkVoltageAngle(Contingency contingency, VoltageAngleLimit voltageAngleLimit, double voltageAngleDifference, Consumer<LimitViolation> consumer) {
        this.checkVoltageAngle(voltageAngleLimit, voltageAngleDifference, consumer);
    }

    default public void checkVoltageAngle(Contingency contingency, VoltageAngleLimit voltageAngleLimit, Consumer<LimitViolation> consumer) {
        this.checkVoltageAngle(voltageAngleLimit, consumer);
    }

    default public void checkCurrent(Contingency contingency, Branch branch, Consumer<LimitViolation> consumer) {
        this.checkCurrent(branch, consumer);
    }

    default public void checkCurrent(Contingency contingency, ThreeWindingsTransformer transformer, Consumer<LimitViolation> consumer) {
        this.checkCurrent(transformer, consumer);
    }

    default public void checkAll(Contingency contingency, Network network, Consumer<LimitViolation> consumer) {
        this.checkAll(network, consumer);
    }

    public void checkCurrent(Branch var1, TwoSides var2, double var3, Consumer<LimitViolation> var5);

    public void checkCurrent(ThreeWindingsTransformer var1, ThreeSides var2, double var3, Consumer<LimitViolation> var5);

    public void checkActivePower(Branch var1, TwoSides var2, double var3, Consumer<LimitViolation> var5);

    public void checkActivePower(ThreeWindingsTransformer var1, ThreeSides var2, double var3, Consumer<LimitViolation> var5);

    public void checkApparentPower(Branch var1, TwoSides var2, double var3, Consumer<LimitViolation> var5);

    public void checkApparentPower(ThreeWindingsTransformer var1, ThreeSides var2, double var3, Consumer<LimitViolation> var5);

    public void checkCurrent(Branch var1, TwoSides var2, Consumer<LimitViolation> var3);

    public void checkCurrent(ThreeWindingsTransformer var1, ThreeSides var2, Consumer<LimitViolation> var3);

    public void checkCurrentDc(Branch var1, TwoSides var2, double var3, Consumer<LimitViolation> var5);

    public void checkCurrentDc(ThreeWindingsTransformer var1, ThreeSides var2, double var3, Consumer<LimitViolation> var5);

    public void checkVoltage(Bus var1, double var2, Consumer<LimitViolation> var4);

    public void checkVoltage(Bus var1, Consumer<LimitViolation> var2);

    public void checkVoltage(VoltageLevel var1, Consumer<LimitViolation> var2);

    public void checkVoltageAngle(VoltageAngleLimit var1, double var2, Consumer<LimitViolation> var4);

    public void checkVoltageAngle(VoltageAngleLimit var1, Consumer<LimitViolation> var2);

    public void checkCurrent(Branch var1, Consumer<LimitViolation> var2);

    public void checkCurrent(ThreeWindingsTransformer var1, Consumer<LimitViolation> var2);

    public void checkCurrentDc(Branch var1, double var2, Consumer<LimitViolation> var4);

    public void checkCurrentDc(ThreeWindingsTransformer var1, double var2, Consumer<LimitViolation> var4);

    public void checkAll(Network var1, Consumer<LimitViolation> var2);

    public void checkAllDc(Network var1, double var2, Consumer<LimitViolation> var4);

    default public LimitViolationType toLimitViolationType(LimitType type) {
        switch (type) {
            case ACTIVE_POWER: {
                return LimitViolationType.ACTIVE_POWER;
            }
            case APPARENT_POWER: {
                return LimitViolationType.APPARENT_POWER;
            }
            case CURRENT: {
                return LimitViolationType.CURRENT;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported conversion for %s from limit type to limit violation type.", type.name()));
    }

    default public void checkPermanentLimit(Branch<?> branch, TwoSides side, float limitReduction, double value, Consumer<LimitViolation> consumer, LimitType type) {
        if (LimitViolationUtils.checkPermanentLimit(branch, (TwoSides)side, (float)limitReduction, (double)value, (LimitType)type)) {
            double limit = branch.getLimits(type, side).map(LoadingLimits::getPermanentLimit).orElseThrow(PowsyblException::new);
            consumer.accept(new LimitViolation(branch.getId(), (String)branch.getOptionalName().orElse(null), this.toLimitViolationType(type), "permanent", Integer.MAX_VALUE, limit, limitReduction, value, side));
        }
    }

    default public void checkPermanentLimit(ThreeWindingsTransformer transformer, ThreeSides side, float limitReduction, double value, Consumer<LimitViolation> consumer, LimitType type) {
        if (LimitViolationUtils.checkPermanentLimit((ThreeWindingsTransformer)transformer, (ThreeSides)side, (float)limitReduction, (double)value, (LimitType)type)) {
            double limit = transformer.getLeg(side).getLimits(type).map(LoadingLimits::getPermanentLimit).orElseThrow(PowsyblException::new);
            consumer.accept(new LimitViolation(transformer.getId(), (String)transformer.getOptionalName().orElse(null), this.toLimitViolationType(type), "permanent", Integer.MAX_VALUE, limit, limitReduction, value, side));
        }
    }

    default public void checkTemporary(Branch<?> branch, TwoSides side, float limitReduction, double value, Consumer<LimitViolation> consumer, LimitType type) {
        Overload overload = LimitViolationUtils.checkTemporaryLimits(branch, (TwoSides)side, (float)limitReduction, (double)value, (LimitType)type);
        if (overload != null) {
            consumer.accept(new LimitViolation(branch.getId(), (String)branch.getOptionalName().orElse(null), this.toLimitViolationType(type), overload.getPreviousLimitName(), overload.getTemporaryLimit().getAcceptableDuration(), overload.getPreviousLimit(), limitReduction, value, side));
        }
    }

    default public void checkTemporary(ThreeWindingsTransformer transformer, ThreeSides side, float limitReduction, double value, Consumer<LimitViolation> consumer, LimitType type) {
        Overload overload = LimitViolationUtils.checkTemporaryLimits((ThreeWindingsTransformer)transformer, (ThreeSides)side, (float)limitReduction, (double)value, (LimitType)type);
        if (overload != null) {
            consumer.accept(new LimitViolation(transformer.getId(), (String)transformer.getOptionalName().orElse(null), this.toLimitViolationType(type), overload.getPreviousLimitName(), overload.getTemporaryLimit().getAcceptableDuration(), overload.getPreviousLimit(), limitReduction, value, side));
        }
    }
}

