/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security;

import com.powsybl.commons.Versionable;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.config.PlatformConfigNamedProvider;
import com.powsybl.commons.reporter.Reporter;
import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.local.LocalComputationManager;
import com.powsybl.contingency.ContingenciesProvider;
import com.powsybl.contingency.Contingency;
import com.powsybl.iidm.network.Network;
import com.powsybl.security.LimitViolationDetector;
import com.powsybl.security.LimitViolationFilter;
import com.powsybl.security.SecurityAnalysisParameters;
import com.powsybl.security.SecurityAnalysisProvider;
import com.powsybl.security.SecurityAnalysisReport;
import com.powsybl.security.action.Action;
import com.powsybl.security.detectors.DefaultLimitViolationDetector;
import com.powsybl.security.interceptors.SecurityAnalysisInterceptor;
import com.powsybl.security.monitor.StateMonitor;
import com.powsybl.security.strategy.OperatorStrategy;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class SecurityAnalysis {
    private SecurityAnalysis() {
        throw new IllegalStateException("Utility class should not been instantiated");
    }

    public static Runner find(String name) {
        return new Runner((SecurityAnalysisProvider)PlatformConfigNamedProvider.Finder.find((String)name, (String)"security-analysis", SecurityAnalysisProvider.class, (PlatformConfig)PlatformConfig.defaultConfig()));
    }

    public static Runner find() {
        return SecurityAnalysis.find(null);
    }

    public static CompletableFuture<SecurityAnalysisReport> runAsync(Network network, String workingStateId, ContingenciesProvider contingenciesProvider, SecurityAnalysisParameters parameters, ComputationManager computationManager, LimitViolationFilter filter, LimitViolationDetector detector, List<SecurityAnalysisInterceptor> interceptors, List<OperatorStrategy> operatorStrategies, List<Action> actions, Reporter reporter) {
        return SecurityAnalysis.find().runAsync(network, workingStateId, contingenciesProvider, parameters, computationManager, filter, detector, interceptors, operatorStrategies, actions, Collections.emptyList(), reporter);
    }

    public static CompletableFuture<SecurityAnalysisReport> runAsync(Network network, ContingenciesProvider contingenciesProvider, SecurityAnalysisParameters parameters, ComputationManager computationManager, LimitViolationFilter filter) {
        return SecurityAnalysis.find().runAsync(network, contingenciesProvider, parameters, computationManager, filter);
    }

    public static CompletableFuture<SecurityAnalysisReport> runAsync(Network network, ContingenciesProvider contingenciesProvider, SecurityAnalysisParameters parameters, ComputationManager computationManager) {
        return SecurityAnalysis.find().runAsync(network, contingenciesProvider, parameters, computationManager);
    }

    public static CompletableFuture<SecurityAnalysisReport> runAsync(Network network, List<Contingency> contingencies, SecurityAnalysisParameters parameters) {
        return SecurityAnalysis.find().runAsync(network, contingencies, parameters);
    }

    public static CompletableFuture<SecurityAnalysisReport> runAsync(Network network, List<Contingency> contingencies) {
        return SecurityAnalysis.find().runAsync(network, contingencies);
    }

    public static SecurityAnalysisReport run(Network network, String workingStateId, ContingenciesProvider contingenciesProvider, SecurityAnalysisParameters parameters, ComputationManager computationManager, LimitViolationFilter filter, LimitViolationDetector detector, List<SecurityAnalysisInterceptor> interceptors, List<OperatorStrategy> operatorStrategies, List<Action> actions) {
        return SecurityAnalysis.find().run(network, workingStateId, contingenciesProvider, parameters, computationManager, filter, detector, interceptors, operatorStrategies, actions);
    }

    public static SecurityAnalysisReport run(Network network, String workingStateId, ContingenciesProvider contingenciesProvider, SecurityAnalysisParameters parameters, ComputationManager computationManager, LimitViolationFilter filter, LimitViolationDetector detector, List<SecurityAnalysisInterceptor> interceptors, List<OperatorStrategy> operatorStrategies, List<Action> actions, List<StateMonitor> monitors, Reporter reporter) {
        return SecurityAnalysis.find().run(network, workingStateId, contingenciesProvider, parameters, computationManager, filter, detector, interceptors, operatorStrategies, actions, monitors, reporter);
    }

    public static SecurityAnalysisReport run(Network network, ContingenciesProvider contingenciesProvider, SecurityAnalysisParameters parameters, ComputationManager computationManager, LimitViolationFilter filter) {
        return SecurityAnalysis.find().run(network, contingenciesProvider, parameters, computationManager, filter);
    }

    public static SecurityAnalysisReport run(Network network, ContingenciesProvider contingenciesProvider, SecurityAnalysisParameters parameters, ComputationManager computationManager) {
        return SecurityAnalysis.find().run(network, contingenciesProvider, parameters, computationManager);
    }

    public static SecurityAnalysisReport run(Network network, List<Contingency> contingencies, SecurityAnalysisParameters parameters) {
        return SecurityAnalysis.find().run(network, contingencies, parameters);
    }

    public static SecurityAnalysisReport run(Network network, List<Contingency> contingencies) {
        return SecurityAnalysis.find().run(network, contingencies);
    }

    public static final class Runner
    implements Versionable {
        private final SecurityAnalysisProvider provider;

        public Runner(SecurityAnalysisProvider provider) {
            this.provider = Objects.requireNonNull(provider);
        }

        public CompletableFuture<SecurityAnalysisReport> runAsync(Network network, String workingStateId, ContingenciesProvider contingenciesProvider, SecurityAnalysisParameters parameters, ComputationManager computationManager, LimitViolationFilter filter, LimitViolationDetector detector, List<SecurityAnalysisInterceptor> interceptors, List<OperatorStrategy> operatorStrategies, List<Action> actions, List<StateMonitor> monitors, Reporter reporter) {
            Objects.requireNonNull(network, "Network should not be null");
            Objects.requireNonNull(workingStateId, "WorkingVariantId should not be null");
            Objects.requireNonNull(detector, "LimitViolation detector should not be null");
            Objects.requireNonNull(filter, "LimitViolation filter should not be null");
            Objects.requireNonNull(computationManager, "ComputationManager should not be null");
            Objects.requireNonNull(contingenciesProvider, "Contingencies provider should not be null");
            Objects.requireNonNull(parameters, "Security analysis parameters should not be null");
            Objects.requireNonNull(interceptors, "Interceptor list should not be null");
            Objects.requireNonNull(reporter, "Reporter should not be null");
            return this.provider.run(network, workingStateId, detector, filter, computationManager, parameters, contingenciesProvider, interceptors, operatorStrategies, actions, monitors, reporter);
        }

        public CompletableFuture<SecurityAnalysisReport> runAsync(Network network, ContingenciesProvider contingenciesProvider, SecurityAnalysisParameters parameters, ComputationManager computationManager, LimitViolationFilter filter) {
            return this.runAsync(network, network.getVariantManager().getWorkingVariantId(), contingenciesProvider, parameters, computationManager, filter, new DefaultLimitViolationDetector(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Reporter.NO_OP);
        }

        public CompletableFuture<SecurityAnalysisReport> runAsync(Network network, ContingenciesProvider contingenciesProvider, SecurityAnalysisParameters parameters, ComputationManager computationManager) {
            return this.runAsync(network, contingenciesProvider, parameters, computationManager, LimitViolationFilter.load());
        }

        public CompletableFuture<SecurityAnalysisReport> runAsync(Network network, List<Contingency> contingencies, SecurityAnalysisParameters parameters) {
            return this.runAsync(network, n -> contingencies, parameters, LocalComputationManager.getDefault());
        }

        public CompletableFuture<SecurityAnalysisReport> runAsync(Network network, List<Contingency> contingencies) {
            return this.runAsync(network, contingencies, SecurityAnalysisParameters.load());
        }

        public SecurityAnalysisReport run(Network network, String workingStateId, ContingenciesProvider contingenciesProvider, SecurityAnalysisParameters parameters, ComputationManager computationManager, LimitViolationFilter filter, LimitViolationDetector detector, List<SecurityAnalysisInterceptor> interceptors, List<OperatorStrategy> operatorStrategies, List<Action> actions, List<StateMonitor> monitors, Reporter reporter) {
            return this.runAsync(network, workingStateId, contingenciesProvider, parameters, computationManager, filter, detector, interceptors, operatorStrategies, actions, monitors, reporter).join();
        }

        public SecurityAnalysisReport run(Network network, String workingStateId, ContingenciesProvider contingenciesProvider, SecurityAnalysisParameters parameters, ComputationManager computationManager, LimitViolationFilter filter, LimitViolationDetector detector, List<SecurityAnalysisInterceptor> interceptors, List<OperatorStrategy> operatorStrategies, List<Action> actions) {
            return this.runAsync(network, workingStateId, contingenciesProvider, parameters, computationManager, filter, detector, interceptors, operatorStrategies, actions, Collections.emptyList(), Reporter.NO_OP).join();
        }

        public SecurityAnalysisReport run(Network network, ContingenciesProvider contingenciesProvider, SecurityAnalysisParameters parameters, ComputationManager computationManager, LimitViolationFilter filter) {
            return this.run(network, network.getVariantManager().getWorkingVariantId(), contingenciesProvider, parameters, computationManager, filter, new DefaultLimitViolationDetector(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }

        public SecurityAnalysisReport run(Network network, ContingenciesProvider contingenciesProvider, SecurityAnalysisParameters parameters, ComputationManager computationManager) {
            return this.run(network, contingenciesProvider, parameters, computationManager, LimitViolationFilter.load());
        }

        public SecurityAnalysisReport run(Network network, List<Contingency> contingencies, SecurityAnalysisParameters parameters) {
            return this.run(network, n -> contingencies, parameters, LocalComputationManager.getDefault());
        }

        public SecurityAnalysisReport run(Network network, List<Contingency> contingencies) {
            return this.run(network, contingencies, SecurityAnalysisParameters.load());
        }

        public String getName() {
            return this.provider.getName();
        }

        public String getVersion() {
            return this.provider.getVersion();
        }
    }
}

