/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.action;

import com.powsybl.security.action.AbstractAction;
import java.util.Objects;
import java.util.OptionalDouble;

public class LoadAction
extends AbstractAction {
    public static final String NAME = "LOAD";
    private final String loadId;
    private final boolean relativeValue;
    private final Double activePowerValue;
    private final Double reactivePowerValue;

    LoadAction(String id, String loadId, boolean relativeValue, Double activePowerValue, Double reactivePowerValue) {
        super(id);
        this.loadId = Objects.requireNonNull(loadId);
        this.relativeValue = relativeValue;
        this.activePowerValue = activePowerValue;
        this.reactivePowerValue = reactivePowerValue;
    }

    @Override
    public String getType() {
        return NAME;
    }

    public String getLoadId() {
        return this.loadId;
    }

    public boolean isRelativeValue() {
        return this.relativeValue;
    }

    public OptionalDouble getActivePowerValue() {
        return this.activePowerValue == null ? OptionalDouble.empty() : OptionalDouble.of(this.activePowerValue);
    }

    public OptionalDouble getReactivePowerValue() {
        return this.reactivePowerValue == null ? OptionalDouble.empty() : OptionalDouble.of(this.reactivePowerValue);
    }
}

