/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.comparator;

import com.google.common.base.Equivalence;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationType;
import java.util.Objects;

public class LimitViolationEquivalence
extends Equivalence<LimitViolation> {
    private final double threshold;

    public LimitViolationEquivalence(double threshold) {
        this.threshold = threshold;
    }

    protected boolean doEquivalent(LimitViolation violation1, LimitViolation violation2) {
        return violation1.getSubjectId().equals(violation2.getSubjectId()) && violation1.getLimitType() == violation2.getLimitType() && Math.abs(violation1.getLimit() - violation2.getLimit()) <= this.threshold && (violation1.getLimitName() == null ? violation2.getLimitName() == null : violation1.getLimitName().equals(violation2.getLimitName())) && (double)Math.abs(violation1.getAcceptableDuration() - violation2.getAcceptableDuration()) <= this.threshold && (double)Math.abs(violation1.getLimitReduction() - violation2.getLimitReduction()) <= this.threshold && Math.abs(violation1.getValue() - violation2.getValue()) <= this.threshold && (violation1.getLimitType() != LimitViolationType.CURRENT || violation1.getSide() == violation2.getSide());
    }

    protected int doHash(LimitViolation violation) {
        return Objects.hashCode((Object)violation);
    }
}

