/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.converter;

import com.powsybl.commons.PowsyblException;
import com.powsybl.security.SecurityAnalysisResult;
import com.powsybl.security.converter.SecurityAnalysisResultExporter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;

public final class SecurityAnalysisResultExporters {
    private SecurityAnalysisResultExporters() {
    }

    public static Collection<String> getFormats() {
        ArrayList<String> formats = new ArrayList<String>();
        for (SecurityAnalysisResultExporter e : ServiceLoader.load(SecurityAnalysisResultExporter.class, SecurityAnalysisResultExporters.class.getClassLoader())) {
            formats.add(e.getFormat());
        }
        return formats;
    }

    public static SecurityAnalysisResultExporter getExporter(String format) {
        Objects.requireNonNull(format);
        for (SecurityAnalysisResultExporter e : ServiceLoader.load(SecurityAnalysisResultExporter.class, SecurityAnalysisResultExporters.class.getClassLoader())) {
            if (!format.equals(e.getFormat())) continue;
            return e;
        }
        return null;
    }

    public static void export(SecurityAnalysisResult result, Path path, String format) {
        Objects.requireNonNull(path);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            SecurityAnalysisResultExporters.export(result, writer, format);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void export(SecurityAnalysisResult result, Properties parameters, Path path, String format) {
        Objects.requireNonNull(path);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            SecurityAnalysisResultExporters.export(result, parameters, writer, format);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void export(SecurityAnalysisResult result, Writer writer, String format) {
        SecurityAnalysisResultExporter exporter = SecurityAnalysisResultExporters.getExporter(format);
        if (exporter == null) {
            throw new PowsyblException("Unsupported format: " + format + " [" + SecurityAnalysisResultExporters.getFormats() + "]");
        }
        exporter.export(result, writer);
    }

    public static void export(SecurityAnalysisResult result, Properties parameters, Writer writer, String format) {
        SecurityAnalysisResultExporter exporter = SecurityAnalysisResultExporters.getExporter(format);
        if (exporter == null) {
            throw new PowsyblException("Unsupported format: " + format + " [" + SecurityAnalysisResultExporters.getFormats() + "]");
        }
        exporter.export(result, parameters, writer);
    }
}

