/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.detectors;

import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.VoltageAngleLimit;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationDetector;
import java.util.function.Consumer;

public abstract class AbstractContingencyBlindDetector
implements LimitViolationDetector {
    @Override
    public void checkCurrent(Branch branch, TwoSides side, Consumer<LimitViolation> consumer) {
        this.checkCurrent(branch, side, branch.getTerminal(side).getI(), consumer);
    }

    @Override
    public void checkCurrent(ThreeWindingsTransformer transformer, ThreeSides side, Consumer<LimitViolation> consumer) {
        this.checkCurrent(transformer, side, transformer.getTerminal(side).getI(), consumer);
    }

    private double getTerminalIOrAnApproximation(Terminal terminal, double dcPowerFactor) {
        return Double.isNaN(terminal.getI()) ? 1000.0 * terminal.getP() / (terminal.getVoltageLevel().getNominalV() * Math.sqrt(3.0) * dcPowerFactor) : terminal.getI();
    }

    @Override
    public void checkCurrentDc(Branch branch, TwoSides side, double dcPowerFactor, Consumer<LimitViolation> consumer) {
        double i = this.getTerminalIOrAnApproximation(branch.getTerminal(side), dcPowerFactor);
        this.checkCurrent(branch, side, i, consumer);
    }

    @Override
    public void checkCurrentDc(ThreeWindingsTransformer transformer, ThreeSides side, double dcPowerFactor, Consumer<LimitViolation> consumer) {
        double i = this.getTerminalIOrAnApproximation(transformer.getTerminal(side), dcPowerFactor);
        this.checkCurrent(transformer, side, i, consumer);
    }

    @Override
    public void checkVoltage(Bus bus, Consumer<LimitViolation> consumer) {
        this.checkVoltage(bus, bus.getV(), consumer);
    }

    @Override
    public void checkVoltage(VoltageLevel voltageLevel, Consumer<LimitViolation> consumer) {
        voltageLevel.getBusView().getBusStream().forEach(b -> this.checkVoltage((Bus)b, consumer));
    }

    @Override
    public void checkVoltageAngle(VoltageAngleLimit voltageAngleLimit, Consumer<LimitViolation> consumer) {
        Bus referenceBus = voltageAngleLimit.getTerminalFrom().getBusView().getBus();
        Bus otherBus = voltageAngleLimit.getTerminalTo().getBusView().getBus();
        if (referenceBus != null && otherBus != null && referenceBus.getConnectedComponent().getNum() == otherBus.getConnectedComponent().getNum() && referenceBus.getSynchronousComponent().getNum() == otherBus.getSynchronousComponent().getNum()) {
            double voltageAngleDifference = otherBus.getAngle() - referenceBus.getAngle();
            this.checkVoltageAngle(voltageAngleLimit, voltageAngleDifference, consumer);
        }
    }

    @Override
    public void checkCurrent(Branch branch, Consumer<LimitViolation> consumer) {
        this.checkCurrent(branch, TwoSides.ONE, consumer);
        this.checkCurrent(branch, TwoSides.TWO, consumer);
    }

    @Override
    public void checkCurrent(ThreeWindingsTransformer transformer, Consumer<LimitViolation> consumer) {
        this.checkCurrent(transformer, ThreeSides.ONE, consumer);
        this.checkCurrent(transformer, ThreeSides.TWO, consumer);
        this.checkCurrent(transformer, ThreeSides.THREE, consumer);
    }

    @Override
    public void checkCurrentDc(Branch branch, double dcPowerFactor, Consumer<LimitViolation> consumer) {
        this.checkCurrentDc(branch, TwoSides.ONE, dcPowerFactor, consumer);
        this.checkCurrentDc(branch, TwoSides.TWO, dcPowerFactor, consumer);
    }

    @Override
    public void checkCurrentDc(ThreeWindingsTransformer transformer, double dcPowerFactor, Consumer<LimitViolation> consumer) {
        this.checkCurrentDc(transformer, ThreeSides.ONE, dcPowerFactor, consumer);
        this.checkCurrentDc(transformer, ThreeSides.TWO, dcPowerFactor, consumer);
        this.checkCurrentDc(transformer, ThreeSides.THREE, dcPowerFactor, consumer);
    }

    @Override
    public void checkAll(Network network, Consumer<LimitViolation> consumer) {
        network.getBranchStream().forEach(b -> this.checkCurrent((Branch)b, consumer));
        network.getThreeWindingsTransformerStream().forEach(t -> this.checkCurrent((ThreeWindingsTransformer)t, consumer));
        network.getVoltageLevelStream().flatMap(vl -> vl.getBusView().getBusStream()).forEach(b -> this.checkVoltage((Bus)b, consumer));
        network.getVoltageAngleLimitsStream().forEach(valOk -> this.checkVoltageAngle((VoltageAngleLimit)valOk, consumer));
    }

    @Override
    public void checkAllDc(Network network, double dcPowerFactor, Consumer<LimitViolation> consumer) {
        network.getBranchStream().forEach(b -> this.checkCurrentDc((Branch)b, dcPowerFactor, consumer));
        network.getThreeWindingsTransformerStream().forEach(b -> this.checkCurrentDc((ThreeWindingsTransformer)b, dcPowerFactor, consumer));
        network.getVoltageAngleLimitsStream().forEach(valOk -> this.checkVoltageAngle((VoltageAngleLimit)valOk, consumer));
    }
}

