/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.distributed;

import com.google.common.base.Preconditions;
import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.ExecutionEnvironment;
import com.powsybl.computation.ExecutionHandler;
import com.powsybl.security.SecurityAnalysisReport;
import com.powsybl.security.distributed.ExternalSecurityAnalysisConfig;
import com.powsybl.security.distributed.SecurityAnalysisExecutionHandlers;
import com.powsybl.security.execution.SecurityAnalysisExecution;
import com.powsybl.security.execution.SecurityAnalysisExecutionInput;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class ForwardedSecurityAnalysisExecution
implements SecurityAnalysisExecution {
    private final ExternalSecurityAnalysisConfig config;
    private Integer forwardedTaskCount;

    public ForwardedSecurityAnalysisExecution(ExternalSecurityAnalysisConfig config) {
        this(config, null);
    }

    public ForwardedSecurityAnalysisExecution(ExternalSecurityAnalysisConfig config, Integer forwardedTaskCount) {
        this.config = Objects.requireNonNull(config);
        this.forwardedTaskCount = ForwardedSecurityAnalysisExecution.checkForwardedTaskCount(forwardedTaskCount);
    }

    @Override
    public CompletableFuture<SecurityAnalysisReport> execute(ComputationManager computationManager, SecurityAnalysisExecutionInput data) {
        ExecutionEnvironment itoolsEnv = new ExecutionEnvironment(Collections.emptyMap(), "security_analysis_", this.config.isDebug());
        ExecutionHandler<SecurityAnalysisReport> executionHandler = SecurityAnalysisExecutionHandlers.forwarded(data, this.forwardedTaskCount);
        return computationManager.execute(itoolsEnv, executionHandler);
    }

    private static Integer checkForwardedTaskCount(Integer count) {
        Preconditions.checkArgument((count == null || count > 0 ? 1 : 0) != 0, (Object)"Forwarded task count must be positive.");
        return count;
    }
}

