/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.distributed;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.powsybl.computation.AbstractExecutionHandler;
import com.powsybl.computation.Command;
import com.powsybl.computation.CommandExecution;
import com.powsybl.computation.ComputationException;
import com.powsybl.computation.ExecutionReport;
import com.powsybl.computation.Partition;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.serde.NetworkSerDe;
import com.powsybl.security.SecurityAnalysisParameters;
import com.powsybl.security.action.Action;
import com.powsybl.security.action.ActionList;
import com.powsybl.security.distributed.SecurityAnalysisCommandOptions;
import com.powsybl.security.execution.NetworkVariant;
import com.powsybl.security.execution.SecurityAnalysisExecutionInput;
import com.powsybl.security.json.JsonSecurityAnalysisParameters;
import com.powsybl.security.monitor.StateMonitor;
import com.powsybl.security.strategy.OperatorStrategy;
import com.powsybl.security.strategy.OperatorStrategyList;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityAnalysisExecutionHandler<R>
extends AbstractExecutionHandler<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityAnalysisExecutionHandler.class);
    private static final String NETWORK_FILE = "network.xiidm";
    private static final String CONTINGENCIES_FILE = "contingencies.groovy";
    private static final String PARAMETERS_FILE = "parameters.json";
    private static final String ACTIONS_FILE = "actions.json";
    private static final String STRATEGIES_FILE = "strategies.json";
    private final ResultReader<R> reader;
    private final OptionsCustomizer optionsCustomizer;
    private final ExceptionHandler exceptionHandler;
    private final int executionCount;
    private final SecurityAnalysisExecutionInput input;

    public SecurityAnalysisExecutionHandler(ResultReader<R> reader, OptionsCustomizer optionsCustomizer, ExceptionHandler exceptionHandler, int executionCount, SecurityAnalysisExecutionInput input) {
        this.reader = Objects.requireNonNull(reader);
        this.optionsCustomizer = optionsCustomizer;
        this.exceptionHandler = exceptionHandler;
        Preconditions.checkArgument((executionCount > 0 ? 1 : 0) != 0, (Object)"Execution count must be positive.");
        this.executionCount = executionCount;
        this.input = Objects.requireNonNull(input);
    }

    public List<CommandExecution> before(Path workingDir) throws IOException {
        CommandExecution execution = this.createSecurityAnalysisCommandExecution(workingDir);
        if (!this.input.getMonitors().isEmpty()) {
            StateMonitor.write(this.input.getMonitors(), workingDir.resolve("montoring_file.json"));
        }
        return Collections.singletonList(execution);
    }

    public R after(Path workingDir, ExecutionReport report) throws IOException {
        try {
            super.after(workingDir, report);
            R result = this.reader.read(workingDir);
            LOGGER.debug("End of command execution in {}. ", (Object)workingDir);
            return result;
        }
        catch (Exception exception) {
            throw this.exceptionHandler.createComputationException(workingDir, exception);
        }
    }

    private CommandExecution createSecurityAnalysisCommandExecution(Path workingDir) {
        SecurityAnalysisCommandOptions options = new SecurityAnalysisCommandOptions().id("security-analysis").resultExtensions(this.input.getResultExtensions()).violationTypes(this.input.getViolationTypes());
        SecurityAnalysisExecutionHandler.addCaseFile(options, workingDir, this.input.getNetworkVariant());
        SecurityAnalysisExecutionHandler.addParametersFile(options, workingDir, this.input.getParameters());
        this.input.getContingenciesSource().ifPresent(source -> SecurityAnalysisExecutionHandler.addContingenciesFile(options, workingDir, source));
        if (this.executionCount > 1) {
            options.task(taskNumber -> new Partition(taskNumber + 1, this.executionCount));
        }
        if (this.optionsCustomizer != null) {
            this.optionsCustomizer.customizeOptions(workingDir, options);
        }
        SecurityAnalysisExecutionHandler.addOperatorStrategyFile(options, workingDir, this.input.getOperatorStrategies());
        SecurityAnalysisExecutionHandler.addActionFile(options, workingDir, this.input.getActions());
        return new CommandExecution((Command)options.toCommand(), this.executionCount);
    }

    private static Path getCasePath(Path workingDir) {
        return workingDir.resolve(NETWORK_FILE);
    }

    private static Path getParametersPath(Path workingDir) {
        return workingDir.resolve(PARAMETERS_FILE);
    }

    private static Path getActionsPath(Path workingDir) {
        return workingDir.resolve(ACTIONS_FILE);
    }

    private static Path getStrategiesPath(Path workingDir) {
        return workingDir.resolve(STRATEGIES_FILE);
    }

    private static Path getContingenciesPath(Path workingDir) {
        return workingDir.resolve(CONTINGENCIES_FILE);
    }

    private static void addCaseFile(SecurityAnalysisCommandOptions options, Path workingDir, NetworkVariant variant) {
        Path dest = SecurityAnalysisExecutionHandler.getCasePath(workingDir);
        options.caseFile(dest);
        LOGGER.debug("Copying network to file {}", (Object)dest);
        NetworkSerDe.write((Network)variant.getVariant(), (Path)dest);
    }

    private static void addContingenciesFile(SecurityAnalysisCommandOptions options, Path workingDir, ByteSource source) {
        Path dest = SecurityAnalysisExecutionHandler.getContingenciesPath(workingDir);
        options.contingenciesFile(dest);
        LOGGER.debug("Writing contingencies to file {}", (Object)dest);
        SecurityAnalysisExecutionHandler.copySourceToPath(source, dest);
    }

    private static void addParametersFile(SecurityAnalysisCommandOptions options, Path workingDir, SecurityAnalysisParameters parameters) {
        Path parametersPath = SecurityAnalysisExecutionHandler.getParametersPath(workingDir);
        options.parametersFile(parametersPath);
        LOGGER.debug("Writing parameters to file {}", (Object)parametersPath);
        JsonSecurityAnalysisParameters.write(parameters, parametersPath);
    }

    private static void addOperatorStrategyFile(SecurityAnalysisCommandOptions options, Path workingDir, List<OperatorStrategy> operatorStrategies) {
        if (operatorStrategies.isEmpty()) {
            return;
        }
        Path path = SecurityAnalysisExecutionHandler.getStrategiesPath(workingDir);
        options.strategiesFile(path);
        LOGGER.debug("Writing operator strategies to file {}", (Object)path);
        new OperatorStrategyList(operatorStrategies).write(path);
    }

    private static void addActionFile(SecurityAnalysisCommandOptions options, Path workingDir, List<Action> actions) {
        if (actions.isEmpty()) {
            return;
        }
        Path path = SecurityAnalysisExecutionHandler.getActionsPath(workingDir);
        options.actionsFile(path);
        LOGGER.debug("Writing actions to file {}", (Object)path);
        new ActionList(actions).writeJsonFile(path);
    }

    private static void copySourceToPath(ByteSource source, Path dest) {
        try (InputStream is = source.openBufferedStream();){
            Files.copy(is, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @FunctionalInterface
    static interface ResultReader<R> {
        public R read(Path var1);
    }

    @FunctionalInterface
    static interface OptionsCustomizer {
        public void customizeOptions(Path var1, SecurityAnalysisCommandOptions var2);
    }

    @FunctionalInterface
    static interface ExceptionHandler {
        public ComputationException createComputationException(Path var1, Exception var2);
    }
}

