/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.security.execution;

import com.powsybl.computation.Partition;
import com.powsybl.contingency.ContingenciesProvider;
import com.powsybl.contingency.ContingenciesProviders;
import com.powsybl.security.SecurityAnalysis;
import com.powsybl.security.SecurityAnalysisInput;
import com.powsybl.security.distributed.DistributedSecurityAnalysisExecution;
import com.powsybl.security.distributed.ExternalSecurityAnalysisConfig;
import com.powsybl.security.distributed.ForwardedSecurityAnalysisExecution;
import com.powsybl.security.execution.SecurityAnalysisExecution;
import com.powsybl.security.execution.SecurityAnalysisExecutionImpl;
import com.powsybl.security.execution.SecurityAnalysisInputBuildStrategy;
import java.util.Objects;
import java.util.function.Supplier;

public class SecurityAnalysisExecutionBuilder {
    private final Supplier<ExternalSecurityAnalysisConfig> externalConfig;
    private final String providerName;
    private final SecurityAnalysisInputBuildStrategy inputBuildStrategy;
    private boolean forward = false;
    private Integer taskCount = null;
    private Partition subPart = null;

    public SecurityAnalysisExecutionBuilder(Supplier<ExternalSecurityAnalysisConfig> externalConfig, String providerName, SecurityAnalysisInputBuildStrategy inputBuildStrategy) {
        this.externalConfig = Objects.requireNonNull(externalConfig);
        this.providerName = providerName;
        this.inputBuildStrategy = Objects.requireNonNull(inputBuildStrategy);
    }

    public SecurityAnalysisExecutionBuilder forward(boolean forward) {
        this.forward = forward;
        return this;
    }

    public SecurityAnalysisExecutionBuilder distributed(Integer taskCount) {
        this.taskCount = taskCount;
        return this;
    }

    public SecurityAnalysisExecutionBuilder subTask(Partition part) {
        this.subPart = part;
        return this;
    }

    public SecurityAnalysisExecution build() {
        if (this.forward) {
            return new ForwardedSecurityAnalysisExecution(this.externalConfig.get(), this.taskCount);
        }
        if (this.taskCount != null) {
            return new DistributedSecurityAnalysisExecution(this.externalConfig.get(), this.taskCount);
        }
        return new SecurityAnalysisExecutionImpl(SecurityAnalysis.find(this.providerName), this.inputBuildStrategy());
    }

    private SecurityAnalysisInputBuildStrategy subPartBuildStrategy() {
        return executionInput -> {
            SecurityAnalysisInput input = this.inputBuildStrategy.buildFrom(executionInput);
            input.setContingencies(ContingenciesProviders.newSubProvider((ContingenciesProvider)input.getContingenciesProvider(), (Partition)this.subPart));
            return input;
        };
    }

    private SecurityAnalysisInputBuildStrategy inputBuildStrategy() {
        if (this.subPart != null) {
            return this.subPartBuildStrategy();
        }
        return this.inputBuildStrategy;
    }
}

